/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.serialization.jvm;

import net.lomeli.lomlib.repack.kotlin.jvm.JvmStatic;
import net.lomeli.lomlib.repack.kotlin.jvm.internal.Intrinsics;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.name.ClassId;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import net.lomeli.lomlib.repack.kotlin.text.StringsKt;
import net.lomeli.lomlib.repack.org.jetbrains.annotations.NotNull;

public final class ClassMapperLite {
    public static final ClassMapperLite INSTANCE;

    @JvmStatic
    @NotNull
    public static final String mapClass(@NotNull ClassId classId) {
        ClassId javaClassId;
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        String internalName = StringsKt.replace$default(classId.asString(), '.', '$', false, 4, null);
        String simpleName = StringsKt.removePrefix(internalName, (CharSequence)"net/lomeli/lomlib/repack/kotlin/");
        if (Intrinsics.areEqual(simpleName, internalName) ^ true) {
            JvmPrimitiveType[] jvmPrimitiveTypeArray = JvmPrimitiveType.values();
            for (int i = 0; i < jvmPrimitiveTypeArray.length; ++i) {
                JvmPrimitiveType jvmPrimitive = jvmPrimitiveTypeArray[i];
                PrimitiveType primitiveType = jvmPrimitive.getPrimitiveType();
                if (Intrinsics.areEqual(simpleName, primitiveType.getTypeName().asString())) {
                    String string = jvmPrimitive.getDesc();
                    Intrinsics.checkExpressionValueIsNotNull(string, "jvmPrimitive.desc");
                    return string;
                }
                if (!Intrinsics.areEqual(simpleName, primitiveType.getArrayTypeName().asString())) continue;
                return "[" + jvmPrimitive.getDesc();
            }
            if (Intrinsics.areEqual(simpleName, KotlinBuiltIns.FQ_NAMES.unit.shortName().asString())) {
                return "V";
            }
        }
        if ((javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(classId.asSingleFqName().toUnsafe())) != null) {
            return "L" + StringsKt.replace$default(javaClassId.asString(), '.', '$', false, 4, null) + ";";
        }
        return "L" + internalName + ";";
    }

    private ClassMapperLite() {
        INSTANCE = this;
    }

    static {
        new ClassMapperLite();
    }
}

