/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types;

import java.util.Iterator;
import java.util.List;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationWithTarget;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.KotlinType;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.TypeCapabilities;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import net.lomeli.lomlib.repack.kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import net.lomeli.lomlib.repack.org.jetbrains.annotations.NotNull;
import net.lomeli.lomlib.repack.org.jetbrains.annotations.Nullable;

public abstract class AbstractKotlinType
implements KotlinType {
    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        if (capabilityClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capabilityClass", "net/lomeli/lomlib/repack/kotlin/reflect/jvm/internal/impl/types/AbstractKotlinType", "getCapability"));
        }
        return this.getCapabilities().getCapability(capabilityClass);
    }

    @Override
    @NotNull
    public TypeCapabilities getCapabilities() {
        TypeCapabilities.NONE nONE = TypeCapabilities.NONE.INSTANCE;
        if (nONE == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/lomeli/lomlib/repack/kotlin/reflect/jvm/internal/impl/types/AbstractKotlinType", "getCapabilities"));
        }
        return nONE;
    }

    public final int hashCode() {
        int result = this.getConstructor().hashCode();
        result = 31 * result + ((Object)this.getArguments()).hashCode();
        result = 31 * result + (this.isMarkedNullable() ? 1 : 0);
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KotlinType)) {
            return false;
        }
        KotlinType type2 = (KotlinType)obj;
        return this.isMarkedNullable() == type2.isMarkedNullable() && KotlinTypeChecker.FLEXIBLE_UNEQUAL_TO_INFLEXIBLE.equalTypes(this, type2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (AnnotationWithTarget annotationWithTarget : this.getAnnotations().getAllAnnotations()) {
            sb.append("[");
            sb.append(DescriptorRenderer.DEBUG_TEXT.renderAnnotation(annotationWithTarget.getAnnotation(), annotationWithTarget.getTarget()));
            sb.append("] ");
        }
        sb.append(this.getConstructor());
        List<TypeProjection> arguments2 = this.getArguments();
        if (!arguments2.isEmpty()) {
            sb.append("<");
            Iterator<TypeProjection> i = arguments2.iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(">");
        }
        if (this.isMarkedNullable()) {
            sb.append("?");
        }
        return sb.toString();
    }
}

