/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.trophyslots;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.ILanguageAdapter;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KotlinAdapter
implements ILanguageAdapter {
    private Logger log = LogManager.getLogger((String)"ILanguageAdapter/Kotlin");

    public Object getNewInstance(FMLModContainer container, Class<?> objectClass, ClassLoader classLoader, Method factoryMarkedAnnotation) throws Exception {
        this.log.debug("FML has asked for {} to be constructed...", new Object[]{objectClass.getSimpleName()});
        try {
            Object obj;
            Field f = objectClass.getField("INSTANCE");
            if (f == null) {
                objectClass.getField("INSTANCES");
            }
            if ((obj = f.get(null)) == null) {
                throw new NullPointerException();
            }
            this.log.debug("Found an object INSTANCE reference in {}, using that. ({})", new Object[]{objectClass.getSimpleName(), obj});
            return obj;
        }
        catch (Exception ex) {
            this.log.debug("Failed to get object reference, trying class construction.");
            try {
                Object obj = objectClass.newInstance();
                if (obj == null) {
                    throw new NullPointerException();
                }
                this.log.debug("Constructed an object from a class type ({}), using that. ({})", new Object[]{objectClass, obj});
                return obj;
            }
            catch (Exception e) {
                throw new KotlinAdapterException(e);
            }
        }
    }

    public boolean supportsStatics() {
        return false;
    }

    public void setProxy(Field target, Class<?> proxyTarget, Object proxy) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        this.log.debug("Setting proxy: {}.{} -> {}", new Object[]{target.getDeclaringClass().getSimpleName(), target.getName(), proxy});
        for (Field x : proxyTarget.getFields()) {
            Object obj;
            if (x.getName().equals("INSTANCE")) {
                try {
                    this.log.debug("Setting proxy on INSTANCE; singleton target.");
                    obj = proxyTarget.getField("INSTANCE").get(null);
                    target.set(obj, proxy);
                    continue;
                }
                catch (Exception ex) {
                    throw new KotlinAdapterException(ex);
                }
            }
            if (x.getName().equals("INSTANCE$")) {
                try {
                    this.log.debug("Setting proxy on INSTANCE$; singleton target.");
                    obj = proxyTarget.getField("INSTANCE$").get(null);
                    target.set(obj, proxy);
                    continue;
                }
                catch (Exception ex) {
                    throw new KotlinAdapterException(ex);
                }
            }
            target.set(proxyTarget, proxy);
        }
    }

    public void setInternalProxies(ModContainer mod, Side side, ClassLoader loader) {
    }

    private class KotlinAdapterException
    extends RuntimeException {
        public KotlinAdapterException(Exception ex) {
            super("Kotlin adapter error - do not report to Forge!", ex);
        }
    }
}

