/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.trophyslots.core;

import java.io.File;
import java.util.List;
import net.lomeli.lomlib.repack.kotlin.Metadata;
import net.lomeli.lomlib.repack.kotlin.Unit;
import net.lomeli.lomlib.repack.kotlin.jvm.internal.Intrinsics;
import net.lomeli.lomlib.repack.kotlin.text.StringsKt;
import net.lomeli.lomlib.repack.org.jetbrains.annotations.NotNull;
import net.lomeli.trophyslots.TrophySlots;
import net.lomeli.trophyslots.core.Proxy;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lnet/lomeli/trophyslots/core/Config;", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "config", "Lnet/minecraftforge/common/config/Configuration;", "getConfig", "()Lnet/minecraftforge/common/config/Configuration;", "fillWhiteList", "", "whiteList", "", "loadConfig", "onConfigChange", "event", "Lnet/minecraftforge/fml/client/event/ConfigChangedEvent$OnConfigChangedEvent;", "translate", "st", "TrophySlots-compileKotlin"})
public final class Config {
    @NotNull
    private final Configuration config;

    @NotNull
    public final Configuration getConfig() {
        return this.config;
    }

    public final void loadConfig() {
        Unit unit;
        Proxy proxy = TrophySlots.proxy;
        if (proxy != null) {
            proxy.setStartingSlots(this.config.getInt("startingSlots", "general", 9, 0, 36, this.translate("config.trophyslots.startingSlots")));
        }
        TrophySlots.unlockViaAchievements = this.config.getBoolean("unlockViaAchievements", "general", true, this.translate("config.trophyslots.unlockAchieve"));
        TrophySlots.canUseTrophy = this.config.getBoolean("canUseTrophy", "general", true, this.translate("config.trophyslots.canUseTrophy"));
        TrophySlots.canBuyTrophy = this.config.getBoolean("canBuyTrophies", "general", false, this.translate("config.trophyslots.canBuyTrophy"));
        TrophySlots.disable3 = this.config.getBoolean("disableFirst3", "general", false, this.translate("config.trophyslots.disable3"));
        TrophySlots.checkForUpdates = this.config.getBoolean("checkForUpdates", "general", true, this.translate("config.trophyslots.update"));
        TrophySlots.useWhiteList = this.config.getBoolean("useWhitelist", "general", false, this.translate("config.trophyslots.useWhitelist"));
        TrophySlots.slotRenderType = this.config.getInt("slotRenderType", "general", 0, 0, 4, this.translate("config.trophyslots.renderLockedSlots"));
        Proxy proxy2 = TrophySlots.proxy;
        if (proxy2 != null) {
            proxy2.setReverse(this.config.getBoolean("reverseUnlock", "general", false, this.translate("config.trophyslots.reverse")));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        TrophySlots.loseSlots = this.config.getBoolean("loseSlotsOnDeath", "general", false, this.translate("config.trophyslots.loseSlots"));
        TrophySlots.loseSlotNum = this.config.getInt("slotsLost", "general", 1, -1, 36, this.translate("config.trophyslots.loseSlots.num"));
        String whiteList = this.config.getString("WhiteList", "general", "", this.translate("config.trophyslots.whitelist"));
        if (TrophySlots.useWhiteList) {
            String string = whiteList;
            Intrinsics.checkExpressionValueIsNotNull(string, "whiteList");
            this.fillWhiteList(string);
        }
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public final void fillWhiteList(@NotNull String whiteList) {
        Intrinsics.checkParameterIsNotNull(whiteList, "whiteList");
        List achievementIDs = StringsKt.split$default((CharSequence)whiteList, new String[]{";"}, false, 0, 6, null);
        if (achievementIDs.size() > 0) {
            Unit unit;
            Proxy proxy = TrophySlots.proxy;
            if (proxy != null) {
                proxy.setWhiteList(achievementIDs);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
    }

    @NotNull
    public final String translate(@NotNull String st) {
        Intrinsics.checkParameterIsNotNull(st, "st");
        String string = I18n.func_74838_a((String)st);
        Intrinsics.checkExpressionValueIsNotNull(string, "I18n.translateToLocal(st)");
        return string;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public final void onConfigChange(@NotNull ConfigChangedEvent.OnConfigChangedEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (event.getModID().equals("trophyslots")) {
            Unit unit;
            Config config = TrophySlots.modConfig;
            if (config != null) {
                config.loadConfig();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
    }

    public Config(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        this.config = new Configuration(file);
    }
}

