/*
 * Decompiled with CFR 0.152.
 */
package mca.items;

import cpw.mods.fml.common.registry.GameRegistry;
import java.text.DecimalFormat;
import java.util.List;
import mca.core.MCA;
import mca.core.minecraft.ModAchievements;
import mca.data.NBTPlayerData;
import mca.data.PlayerMemory;
import mca.entity.EntityHuman;
import mca.enums.EnumDialogueType;
import mca.enums.EnumRelation;
import mca.packets.PacketOpenBabyNameGUI;
import mca.util.TutorialManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;

public class ItemBaby
extends Item {
    private final boolean isBoy;

    public ItemBaby(boolean isBoy) {
        String itemName = isBoy ? "BabyBoy" : "BabyGirl";
        this.isBoy = isBoy;
        this.func_77637_a(MCA.getCreativeTabMain());
        this.func_77625_d(1);
        this.func_77655_b(itemName);
        this.func_111206_d("mca:" + itemName);
        GameRegistry.registerItem((Item)this, (String)itemName);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int unknownInt, boolean unknownBoolean) {
        super.func_77663_a(itemStack, world, entity, unknownInt, unknownBoolean);
        if (!world.field_72995_K) {
            if (!itemStack.func_77942_o()) {
                String ownerName = entity instanceof EntityPlayer ? entity.func_70005_c_() : (entity instanceof EntityHuman ? ((EntityHuman)entity).getSpouseName() : "Unknown");
                itemStack.field_77990_d = new NBTTagCompound();
                itemStack.field_77990_d.func_74778_a("name", "Unnamed");
                itemStack.field_77990_d.func_74768_a("age", 0);
                itemStack.field_77990_d.func_74778_a("owner", ownerName);
                itemStack.field_77990_d.func_74757_a("isInfected", false);
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    if (player.field_71075_bZ.field_75098_d) {
                        TutorialManager.sendMessageToPlayer(player, "You can name a baby retrieved from", "creative mode by right-clicking the air.");
                    }
                }
            } else {
                this.updateBabyGrowth(itemStack);
            }
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World worldObj, int posX, int posY, int posZ, int meta, float playerPosX, float playerPosY, float playerPosZ) {
        if (!worldObj.field_72995_K && this.isReadyToGrowUp(stack)) {
            ItemBaby baby = (ItemBaby)stack.func_77973_b();
            NBTPlayerData data = MCA.getPlayerData(player);
            boolean isPlayerMale = data.getIsMale();
            String motherName = "N/A";
            int motherId = 0;
            String fatherName = "N/A";
            int fatherId = 0;
            if (isPlayerMale) {
                motherName = data.getSpouseName();
                motherId = data.getSpousePermanentId();
                fatherName = player.func_70005_c_();
                fatherId = data.getPermanentId();
            } else {
                fatherName = data.getSpouseName();
                fatherId = data.getSpousePermanentId();
                motherName = player.func_70005_c_();
                motherId = data.getPermanentId();
            }
            EntityHuman child = new EntityHuman(worldObj, baby.isBoy, true, motherName, fatherName, motherId, fatherId, true);
            child.func_70107_b(posX, posY + 1, posZ);
            child.setName(stack.field_77990_d.func_74779_i("name"));
            if (stack.field_77990_d.func_74767_n("isInfected")) {
                child.setIsInfected(true);
            }
            worldObj.func_72838_d((Entity)child);
            PlayerMemory childMemory = child.getPlayerMemory(player);
            childMemory.setHearts(100);
            childMemory.setDialogueType(EnumDialogueType.CHILDP);
            childMemory.setRelation(child.getIsMale() ? EnumRelation.SON : EnumRelation.DAUGHTER);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            player.func_71029_a((StatBase)ModAchievements.babyToChild);
            data.setShouldHaveBaby(false);
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K && itemStack.field_77990_d.func_74779_i("name").equals("Unnamed")) {
            ItemBaby baby = (ItemBaby)itemStack.func_77973_b();
            MCA.getPacketHandler().sendPacketToPlayer(new PacketOpenBabyNameGUI(baby.isBoy), (EntityPlayerMP)player);
        }
        return super.func_77659_a(itemStack, world, player);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.func_92059_d() != null) {
            this.updateBabyGrowth(entityItem.func_92059_d());
        }
        return super.onEntityItemUpdate(entityItem);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List infoList, boolean unknown) {
        super.func_77624_a(itemStack, entityPlayer, infoList, unknown);
        DecimalFormat nearestTenth = new DecimalFormat("0.0");
        if (itemStack.func_77942_o()) {
            String textColor = ((ItemBaby)itemStack.func_77973_b()).isBoy ? "\u00a7B" : "\u00a7D";
            float ageInMinutes = (float)itemStack.field_77990_d.func_74762_e("age") / 1200.0f;
            String ownerName = itemStack.field_77990_d.func_74779_i("owner");
            ownerName = ownerName.equals(entityPlayer.func_70005_c_()) ? "You" : ownerName;
            infoList.add(textColor + "Name: " + "\u00a7r" + itemStack.field_77990_d.func_74779_i("name"));
            infoList.add(textColor + "Age: " + "\u00a7r" + nearestTenth.format(ageInMinutes) + " minutes.");
            infoList.add(textColor + "Parent: " + "\u00a7r" + ownerName);
            if (itemStack.field_77990_d.func_74767_n("isInfected")) {
                infoList.add("\u00a7AInfected!");
            }
            if (this.isReadyToGrowUp(itemStack)) {
                infoList.add("\u00a7AReady to grow up!");
            }
        }
    }

    private void updateBabyGrowth(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            int age = itemStack.field_77990_d.func_74762_e("age");
            itemStack.field_77990_d.func_74768_a("age", ++age);
        }
    }

    private boolean isReadyToGrowUp(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            float ageInMinutes = (float)itemStack.field_77990_d.func_74762_e("age") / 1200.0f;
            return ageInMinutes >= (float)MCA.getConfig().babyGrowUpTime;
        }
        return false;
    }

    public boolean getIsBoy() {
        return this.isBoy;
    }
}

