/*
 * Decompiled with CFR 0.152.
 */
package mca.items;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import mca.core.MCA;
import mca.core.minecraft.ModBlocks;
import mca.data.VillagerSaveData;
import mca.enums.EnumMemorialType;
import mca.enums.EnumProfession;
import mca.enums.EnumRelation;
import mca.tile.TileMemorial;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import radixcore.math.Point3D;
import radixcore.util.BlockHelper;

public class ItemMemorial
extends Item {
    private EnumMemorialType type;

    public ItemMemorial(EnumMemorialType type) {
        this.type = type;
        this.func_77655_b(type.getTypeName());
        this.func_111206_d("mca:" + type.getTypeName());
        GameRegistry.registerItem((Item)this, (String)type.getTypeName());
        this.func_77637_a(MCA.getCreativeTabMain());
        this.func_77625_d(1);
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int posX, int posY, int posZ, int meta, float xOffset, float yOffset, float zOffset) {
        if (!world.field_72995_K && itemStack.func_77942_o()) {
            BlockHelper.setBlock((World)world, (Point3D)new Point3D(posX, ++posY, posZ), (Block)ModBlocks.memorial);
            TileMemorial tile = (TileMemorial)BlockHelper.getTileEntity((World)world, (int)posX, (int)posY, (int)posZ);
            tile.setType(this.type);
            tile.setVillagerSaveData(VillagerSaveData.fromNBT(itemStack.func_77978_p()));
            tile.setOwnerName(itemStack.func_77978_p().func_74779_i("ownerName"));
            if (itemStack.func_77942_o()) {
                tile.setRelation(EnumRelation.getById(itemStack.func_77978_p().func_74762_e("relation")));
            } else {
                tile.setRelation(EnumRelation.NONE);
            }
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
        }
        return true;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List infoList, boolean unknown) {
        super.func_77624_a(itemStack, entityPlayer, infoList, unknown);
        if (itemStack.func_77942_o()) {
            VillagerSaveData data = VillagerSaveData.fromNBT(itemStack.func_77978_p());
            String ownerName = itemStack.func_77978_p().func_74779_i("ownerName");
            String name = data.name;
            String relationId = EnumRelation.getById(itemStack.func_77978_p().func_74762_e("relation")).getPhraseId();
            infoList.add("\u00a7FBelonged to: ");
            if (!relationId.equals("relation.none")) {
                infoList.add("\u00a7A" + name + ", " + MCA.getLanguageManager().getString(relationId) + " of " + ownerName);
            } else {
                infoList.add("\u00a7A" + name + " the " + MCA.getLanguageManager().getString(EnumProfession.getProfessionById(data.professionId).getLocalizationId()));
                infoList.add("Captured by: " + ownerName);
            }
        } else {
            infoList.add("\u00a7ACREATIVE \u00a7r- No villager attached.");
            infoList.add("Right-click a villager to attach them");
            infoList.add("to this object.");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            infoList.add("");
            infoList.add("An item once owned by a");
            infoList.add("villager who has died. Revive ");
            infoList.add("them using the \u00a7EStaff of Life\u00a77.");
        } else {
            infoList.add("");
            infoList.add("Hold \u00a7ESHIFT\u00a77 for info.");
        }
    }
}

