/*
 * Decompiled with CFR 0.152.
 */
package radixcore.data;

import cpw.mods.fml.common.ModMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import radixcore.core.RadixCore;
import radixcore.data.DataWatcherEx;
import radixcore.data.IWatchable;
import radixcore.util.RadixExcept;

public abstract class AbstractPlayerData
implements Serializable,
IWatchable {
    public static final long serialVersionUID = 1L;
    protected static final transient String playerDataPath = "%WorldDir%/playerdata-%ModID%/";
    protected transient EntityPlayer owner;
    protected String ownerIdentifier;
    protected DataWatcherEx dataWatcher;

    public AbstractPlayerData(EntityPlayer player, String modId) {
        this.owner = player;
        this.ownerIdentifier = player.func_110124_au().toString();
        this.dataWatcher = new DataWatcherEx(this, modId);
        this.instantiateData();
        File dataFolder = new File(playerDataPath.replace("%WorldDir%", player.field_70170_p.func_72860_G().func_75765_b().getAbsolutePath()).replace("%ModID%", this.getModMetadata().modId.toLowerCase()));
        dataFolder.mkdirs();
    }

    public AbstractPlayerData(String ownerIdentifier, String modId, World world) {
        this.ownerIdentifier = ownerIdentifier;
        this.dataWatcher = new DataWatcherEx(this, modId);
        this.instantiateData();
        File dataFolder = new File(playerDataPath.replace("%WorldDir%", world.func_72860_G().func_75765_b().getAbsolutePath()).replace("%ModID%", this.getModMetadata().modId.toLowerCase()));
    }

    public abstract void instantiateData();

    public abstract void initializeNewData(EntityPlayer var1);

    public abstract ModMetadata getModMetadata();

    @Override
    public DataWatcherEx getDataWatcherEx() {
        return this.dataWatcher;
    }

    public String getDataFile() {
        WorldServer baseWorld = MinecraftServer.func_71276_C().func_71218_a(0);
        String fileName = this.owner != null ? this.owner.func_110124_au().toString() + ".dat" : this.ownerIdentifier + ".dat";
        return playerDataPath.replace("%WorldDir%", baseWorld.func_72860_G().func_75765_b().getAbsolutePath()).replace("%ModID%", this.getModMetadata().modId.toLowerCase()) + fileName;
    }

    public void saveDataToFile() {
        try {
            FileOutputStream fileOut = new FileOutputStream(this.getDataFile());
            ObjectOutputStream objOut = new ObjectOutputStream(fileOut);
            objOut.writeObject(this);
            objOut.close();
        }
        catch (IOException e) {
            RadixExcept.logErrorCatch(e, "IOException while saving player data to file! Data may be lost or corrupted.");
        }
    }

    public <generic extends AbstractPlayerData> generic readDataFromFile(EntityPlayer player, Class<generic> type, File file) {
        AbstractPlayerData returnData = null;
        try {
            FileInputStream fileIn = new FileInputStream(file != null ? file.getAbsolutePath() : this.getDataFile());
            ObjectInputStream objIn = new ObjectInputStream(fileIn);
            returnData = (AbstractPlayerData)objIn.readObject();
            returnData.owner = player;
            objIn.close();
        }
        catch (IOException e) {
            RadixExcept.logErrorCatch(e, "IOException while saving player data to file! Data may be lost or corrupted.");
        }
        catch (ClassNotFoundException e) {
            RadixExcept.logErrorCatch(e, "ClassNotFoundException while saving player data to file!");
        }
        return (generic)returnData;
    }

    public boolean dataExists() {
        File dataFile = new File(this.getDataFile());
        return dataFile.exists();
    }

    public static String getPlayerDataPath(World world, String modID) {
        return playerDataPath.replace("%WorldDir%", world.func_72860_G().func_75765_b().getAbsolutePath()).replace("%ModID%", RadixCore.getModMetadataByID((String)modID).modId.toLowerCase());
    }
}

