/*
 * Decompiled with CFR 0.152.
 */
package radixcore.inventory;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Inventory
extends InventoryBasic {
    public Inventory(String name, boolean displayCustomName, int size) {
        super(name, displayCustomName, size);
    }

    private int getFirstEmptyStack() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) != null) continue;
            return i;
        }
        return -1;
    }

    public boolean addItemStackToInventory(ItemStack itemStack) {
        if (itemStack.field_77994_a > 0) {
            int slotId;
            if (itemStack.func_77951_h()) {
                int slotId2 = this.getFirstEmptyStack();
                if (slotId2 >= 0) {
                    this.func_70299_a(slotId2, ItemStack.func_77944_b((ItemStack)itemStack));
                    itemStack.field_77994_a = 0;
                    this.combinePartialStacks();
                    return true;
                }
                this.combinePartialStacks();
                return false;
            }
            do {
                slotId = itemStack.field_77994_a;
                itemStack.field_77994_a = this.storePartialItemStack(itemStack);
            } while (itemStack.field_77994_a > 0 && itemStack.field_77994_a < slotId);
            this.combinePartialStacks();
            return itemStack.field_77994_a < slotId;
        }
        return false;
    }

    public boolean contains(Class clazz) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            Item item;
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || (item = stack.func_77973_b()).getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Item item) {
        return this.contains(item.getClass());
    }

    public boolean contains(Block block) {
        return this.contains(block.getClass());
    }

    public boolean containsCountOf(Item item, int threshold) {
        int totalCount = 0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            Item stackItem;
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || (stackItem = stack.func_77973_b()).getClass() != item.getClass()) continue;
            totalCount += stack.field_77994_a;
        }
        return totalCount >= threshold;
    }

    public void loadInventoryFromNBT(NBTTagList tagList) {
        int i;
        for (i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, null);
        }
        for (i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbt = tagList.func_150305_b(i);
            int slot = nbt.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)nbt));
        }
    }

    public NBTTagList saveInventoryToNBT() {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (itemstack == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbt);
            tagList.func_74742_a((NBTBase)nbt);
        }
        return tagList;
    }

    public ItemStack getBestItemOfType(Class type) {
        return this.func_70301_a(this.getBestItemOfTypeSlot(type));
    }

    public int getBestItemOfTypeSlot(Class type) {
        int highestMaxDamage = 0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            String itemClassName;
            ItemStack stackInInventory = this.func_70301_a(i);
            if (stackInInventory == null || !(itemClassName = stackInInventory.func_77973_b().getClass().getName()).equals(type.getName()) || highestMaxDamage >= stackInInventory.func_77958_k()) continue;
            highestMaxDamage = stackInInventory.func_77958_k();
            return i;
        }
        return -1;
    }

    public boolean damageItem(int slotId, int amount) {
        ItemStack stack = this.func_70301_a(slotId);
        if (stack != null) {
            stack.func_96631_a(amount, new Random());
            if (stack.func_77960_j() >= stack.func_77958_k()) {
                stack.field_77994_a = 0;
                this.func_70299_a(slotId, null);
                return true;
            }
        }
        return false;
    }

    private void combinePartialStacks() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack currentStack = this.func_70301_a(i);
            if (currentStack == null || currentStack.field_77994_a == currentStack.func_77976_d()) continue;
            block1: for (int i2 = 0; i2 < this.func_70302_i_(); ++i2) {
                ItemStack searchingStack = this.func_70301_a(i2);
                if (searchingStack == null || currentStack.func_77973_b() != searchingStack.func_77973_b() || i == i2 || currentStack.func_77960_j() != searchingStack.func_77960_j()) continue;
                while (searchingStack.field_77994_a < searchingStack.func_77976_d()) {
                    ++currentStack.field_77994_a;
                    --searchingStack.field_77994_a;
                    if (searchingStack.field_77994_a != 0) continue;
                    this.func_70299_a(i2, null);
                    continue block1;
                }
            }
        }
    }

    private int storePartialItemStack(ItemStack itemStack) {
        int itemStackSize;
        int stackSize = itemStack.field_77994_a;
        if (itemStack.func_77976_d() == 1) {
            int slotId = this.getFirstEmptyStack();
            if (slotId < 0) {
                return stackSize;
            }
            if (this.func_70301_a(slotId) == null) {
                this.func_70299_a(slotId, ItemStack.func_77944_b((ItemStack)itemStack));
            }
            return 0;
        }
        int slotId = this.storeItemStack(itemStack);
        if (slotId < 0) {
            slotId = this.getFirstEmptyStack();
        }
        if (slotId < 0) {
            return stackSize;
        }
        if (this.func_70301_a(slotId) == null) {
            this.func_70299_a(slotId, new ItemStack(itemStack.func_77973_b(), 0, itemStack.func_77960_j()));
            if (itemStack.func_77942_o()) {
                ItemStack stack = this.func_70301_a(slotId);
                stack.func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
                this.func_70299_a(slotId, stack);
            }
        }
        if ((itemStackSize = stackSize) > this.func_70301_a(slotId).func_77976_d() - this.func_70301_a((int)slotId).field_77994_a) {
            itemStackSize = this.func_70301_a(slotId).func_77976_d() - this.func_70301_a((int)slotId).field_77994_a;
        }
        if (itemStackSize > this.func_70297_j_() - this.func_70301_a((int)slotId).field_77994_a) {
            itemStackSize = this.func_70297_j_() - this.func_70301_a((int)slotId).field_77994_a;
        }
        if (itemStackSize == 0) {
            return stackSize;
        }
        ItemStack oldStack = this.func_70301_a(slotId);
        oldStack.field_77994_a += itemStackSize;
        oldStack.field_77992_b = 5;
        this.func_70299_a(slotId, oldStack);
        return stackSize -= itemStackSize;
    }

    private int storeItemStack(ItemStack itemStack) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || stack != itemStack || !stack.func_77985_e() || stack.field_77994_a >= stack.func_77976_d() || stack.field_77994_a >= this.func_70297_j_() || stack.func_77981_g() && stack.func_77960_j() != itemStack.func_77960_j() || !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)itemStack)) continue;
            return i;
        }
        return -1;
    }

    public int getFirstSlotContainingItem(Item item) {
        int slot = 0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack != null && stack.func_77973_b() == item) {
                return slot;
            }
            ++slot;
        }
        return -1;
    }

    public void removeCountOfItem(Item item, int qtyToRemove) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item) continue;
            while (stack.field_77994_a != 0) {
                --stack.field_77994_a;
                --qtyToRemove;
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                }
                if (qtyToRemove != 0) continue;
            }
        }
    }
}

