/*
 * Decompiled with CFR 0.152.
 */
package radixcore.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import radixcore.data.DataWatcherEx;
import radixcore.data.IWatchable;
import radixcore.packets.AbstractPacket;
import radixcore.packets.PacketDataSync;
import radixcore.util.RadixExcept;

public class PacketDataSyncReq
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketDataSyncReq, IMessage> {
    private int entityId;

    public PacketDataSyncReq() {
    }

    public PacketDataSyncReq(int entityId) {
        this.entityId = entityId;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.entityId = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.entityId);
    }

    public IMessage onMessage(PacketDataSyncReq packet, MessageContext context) {
        try {
            IWatchable watchable = (IWatchable)context.getServerHandler().field_147369_b.field_70170_p.func_73045_a(packet.entityId);
            if (watchable != null) {
                DataWatcherEx dataWatcherEx = watchable.getDataWatcherEx();
                return new PacketDataSync(packet.entityId, dataWatcherEx);
            }
        }
        catch (Throwable e) {
            RadixExcept.logErrorCatch(e, "Error sending sync data to client.");
        }
        return null;
    }
}

