/*
 * Decompiled with CFR 0.152.
 */
package radixcore.util;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import radixcore.core.RadixCore;
import radixcore.data.IPermanent;
import radixcore.math.Point3D;
import radixcore.util.RadixMath;

public final class RadixLogic {
    public static Entity getEntityByPermanentId(World world, int desiredId) {
        if (world.field_72995_K) {
            RadixCore.getLogger().warn("getEntityByPermId() accessed client-side! Any changes could cause sync issues!");
        }
        for (Entity entity : world.field_72996_f) {
            IPermanent idInterface;
            if (!(entity instanceof IPermanent) || (idInterface = (IPermanent)entity).getPermanentId() != desiredId) continue;
            return entity;
        }
        return null;
    }

    public static int generatePermanentEntityId(Entity entity) {
        int generatedId = (int)Math.abs((long)entity.func_145782_y() + System.currentTimeMillis() % 0x100000L);
        if (entity instanceof EntityPlayer) {
            return generatedId * -1;
        }
        return generatedId;
    }

    public static Object getEntityOfTypeAtXYZ(Class type, World world, int x, int y, int z) {
        for (Object obj : world.field_72996_f) {
            if (!type.isInstance(obj)) continue;
            Entity entity = (Entity)obj;
            int posX = (int)entity.field_70165_t;
            int posY = (int)entity.field_70163_u;
            int posZ = (int)entity.field_70161_v;
            if (x != posX || y != posY || z != posZ) continue;
            return obj;
        }
        Entity nearestEntity = null;
        for (Entity obj : RadixLogic.getAllEntitiesWithinDistanceOfCoordinates(world, x, y, z, 5)) {
            if (!type.isInstance(obj)) continue;
            if (nearestEntity == null) {
                nearestEntity = obj;
                continue;
            }
            Entity otherEntity = obj;
            double nearestEntityDistance = RadixMath.getDistanceToXYZ(nearestEntity.field_70165_t, nearestEntity.field_70163_u, nearestEntity.field_70161_v, x, y, z);
            double nearestCandidateDistance = RadixMath.getDistanceToXYZ(otherEntity.field_70165_t, otherEntity.field_70163_u, otherEntity.field_70161_v, x, y, z);
            if (nearestEntityDistance == 1.0) {
                return nearestEntity;
            }
            if (nearestCandidateDistance == 1.0) {
                return otherEntity;
            }
            if (!(nearestCandidateDistance < nearestEntityDistance)) continue;
            nearestEntity = otherEntity;
        }
        return nearestEntity;
    }

    public static Entity getNearestEntityOfTypeWithinDistance(Class entityType, Entity entityOrigin, int maxDistanceAway) {
        try {
            double posX = entityOrigin.field_70165_t;
            double posY = entityOrigin.field_70163_u;
            double posZ = entityOrigin.field_70161_v;
            ArrayList<Entity> validEntities = new ArrayList<Entity>();
            List entitiesAroundMe = entityOrigin.field_70170_p.func_72839_b(entityOrigin, AxisAlignedBB.func_72330_a((double)(posX - (double)maxDistanceAway), (double)(posY - (double)maxDistanceAway), (double)(posZ - (double)maxDistanceAway), (double)(posX + (double)maxDistanceAway), (double)(posY + (double)maxDistanceAway), (double)(posZ + (double)maxDistanceAway)));
            for (Entity entityNearMe : entitiesAroundMe) {
                try {
                    entityType.cast(entityNearMe);
                    validEntities.add(entityNearMe);
                }
                catch (ClassCastException e) {}
            }
            int indexToReturn = -1;
            double lastMinDistance = 100.0;
            for (int i = 0; i < validEntities.size(); ++i) {
                double distance = RadixMath.getDistanceToEntity(entityOrigin, (Entity)validEntities.get(i));
                if (!(distance < lastMinDistance)) continue;
                lastMinDistance = distance;
                indexToReturn = i;
            }
            return (Entity)validEntities.get(indexToReturn);
        }
        catch (ConcurrentModificationException e) {
            return null;
        }
        catch (NoSuchElementException e) {
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static boolean getBooleanWithProbability(int probabilityOfTrue) {
        if (probabilityOfTrue <= 0) {
            return false;
        }
        return new Random().nextInt(100) + 1 <= probabilityOfTrue;
    }

    public static Point3D getFirstNearestBlock(Entity entity, Block block, int maxDistanceAway) {
        int x = (int)entity.field_70165_t;
        int y = (int)entity.field_70163_u;
        int z = (int)entity.field_70161_v;
        int xMov = 0 - maxDistanceAway;
        int yMov = 3;
        int zMov = 0 - maxDistanceAway;
        while (true) {
            Block currentBlock;
            if ((currentBlock = entity.field_70170_p.func_147439_a(x + xMov, y + yMov, z + zMov)) == block) {
                return new Point3D(x + xMov, y + yMov, z + zMov);
            }
            if (zMov == maxDistanceAway && xMov == maxDistanceAway && yMov == -3) break;
            if (zMov == maxDistanceAway && xMov == maxDistanceAway) {
                --yMov;
                xMov = 0 - maxDistanceAway;
                zMov = 0 - maxDistanceAway;
                continue;
            }
            if (xMov == maxDistanceAway) {
                ++zMov;
                xMov = 0 - maxDistanceAway;
                continue;
            }
            ++xMov;
        }
        return null;
    }

    public static Point3D getFirstNearestBlockWithMeta(Entity entity, Block block, int meta, int maxDistanceAway) {
        int x = (int)entity.field_70165_t;
        int y = (int)entity.field_70163_u;
        int z = (int)entity.field_70161_v;
        int xMov = 0 - maxDistanceAway;
        int yMov = 3;
        int zMov = 0 - maxDistanceAway;
        while (true) {
            Block currentBlock = entity.field_70170_p.func_147439_a(x + xMov, y + yMov, z + zMov);
            int currentMeta = entity.field_70170_p.func_72805_g(x + xMov, y + yMov, z + zMov);
            if (currentBlock == block && currentMeta == meta) {
                return new Point3D(x + xMov, y + yMov, z + zMov);
            }
            if (zMov == maxDistanceAway && xMov == maxDistanceAway && yMov == -3) break;
            if (zMov == maxDistanceAway && xMov == maxDistanceAway) {
                --yMov;
                xMov = 0 - maxDistanceAway;
                zMov = 0 - maxDistanceAway;
                continue;
            }
            if (xMov == maxDistanceAway) {
                ++zMov;
                xMov = 0 - maxDistanceAway;
                continue;
            }
            ++xMov;
        }
        return null;
    }

    public static Point3D getFirstFurthestBlock(Entity entity, Block block, int minDistanceAway) {
        Point3D returnPoint = Point3D.ZERO;
        double delta = 0.0;
        for (Point3D point : RadixLogic.getNearbyBlocks(entity, block, 20)) {
            double distance = RadixMath.getDistanceToXYZ(entity, point);
            if (!(distance > (double)minDistanceAway) || !(delta < distance)) continue;
            delta = distance;
            returnPoint = point;
        }
        return returnPoint;
    }

    public static Point3D getNearestBlockPosWithMetadata(Entity entity, Block block, int meta, int maxDistanceAway) {
        List<Point3D> points = RadixLogic.getNearbyBlocksWithMetadata(entity, block, meta, maxDistanceAway);
        Point3D returnPoint = null;
        int distance = -1;
        for (Point3D point : points) {
            int calculatedDistance = (int)RadixMath.getDistanceToXYZ(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, point.dPosX, point.dPosY, point.dPosZ);
            if (distance == -1) {
                distance = calculatedDistance;
                returnPoint = point;
                continue;
            }
            if (calculatedDistance >= distance) continue;
            distance = calculatedDistance;
            returnPoint = point;
        }
        return returnPoint;
    }

    public static List<Point3D> getNearbyBlocksWithMetadata(Entity entity, Block block, int meta, int maxDistanceAway) {
        List<Point3D> nearbyBlocks = RadixLogic.getNearbyBlocks(entity, block, maxDistanceAway);
        ArrayList<Point3D> returnList = new ArrayList<Point3D>();
        for (Point3D point : nearbyBlocks) {
            if (entity.field_70170_p.func_72805_g(point.iPosX, point.iPosY, point.iPosZ) != meta) continue;
            returnList.add(point);
        }
        return returnList;
    }

    public static List<Point3D> getNearbyBlocks(Entity entity, Block block, int maxDistanceAway) {
        int x = (int)entity.field_70165_t;
        int y = (int)entity.field_70163_u;
        int z = (int)entity.field_70161_v;
        int xMov = 0 - maxDistanceAway;
        int yMov = 3;
        int zMov = 0 - maxDistanceAway;
        ArrayList<Point3D> pointsList = new ArrayList<Point3D>();
        while (true) {
            Block currentBlock;
            if ((currentBlock = entity.field_70170_p.func_147439_a(x + xMov, y + yMov, z + zMov)) == block) {
                pointsList.add(new Point3D(x + xMov, y + yMov, z + zMov));
            }
            if (zMov == maxDistanceAway && xMov == maxDistanceAway && yMov == -3) break;
            if (zMov == maxDistanceAway && xMov == maxDistanceAway) {
                --yMov;
                xMov = 0 - maxDistanceAway;
                zMov = 0 - maxDistanceAway;
                continue;
            }
            if (xMov == maxDistanceAway) {
                ++zMov;
                xMov = 0 - maxDistanceAway;
                continue;
            }
            ++xMov;
        }
        return pointsList;
    }

    public static List<Point3D> getNearbyBlocks(Entity entity, Class blockClass, int maxDistanceAway) {
        int x = (int)entity.field_70165_t;
        int y = (int)entity.field_70163_u;
        int z = (int)entity.field_70161_v;
        int xMov = 0 - maxDistanceAway;
        int yMov = 3;
        int zMov = 0 - maxDistanceAway;
        ArrayList<Point3D> pointsList = new ArrayList<Point3D>();
        while (true) {
            Block currentBlock;
            if ((currentBlock = entity.field_70170_p.func_147439_a(x + xMov, y + yMov, z + zMov)).getClass().isAssignableFrom(blockClass)) {
                pointsList.add(new Point3D(x + xMov, y + yMov, z + zMov));
            }
            if (zMov == maxDistanceAway && xMov == maxDistanceAway && yMov == -3) break;
            if (zMov == maxDistanceAway && xMov == maxDistanceAway) {
                --yMov;
                xMov = 0 - maxDistanceAway;
                zMov = 0 - maxDistanceAway;
                continue;
            }
            if (xMov == maxDistanceAway) {
                ++zMov;
                xMov = 0 - maxDistanceAway;
                continue;
            }
            ++xMov;
        }
        return pointsList;
    }

    public static List<Entity> getAllEntitiesWithinDistanceOfCoordinates(World worldObj, double posX, double posY, double posZ, int maxDistanceAway) {
        List entitiesAroundMe = worldObj.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(posX - (double)maxDistanceAway), (double)(posY - (double)maxDistanceAway), (double)(posZ - (double)maxDistanceAway), (double)(posX + (double)maxDistanceAway), (double)(posY + (double)maxDistanceAway), (double)(posZ + (double)maxDistanceAway)));
        return entitiesAroundMe;
    }

    public static List<Entity> getAllEntitiesOfTypeWithinDistance(Class clazz, Entity entityOrigin, int maxDistanceAway) {
        List entitiesAroundMe = entityOrigin.field_70170_p.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(entityOrigin.field_70165_t - (double)maxDistanceAway), (double)(entityOrigin.field_70163_u - (double)maxDistanceAway), (double)(entityOrigin.field_70161_v - (double)maxDistanceAway), (double)(entityOrigin.field_70165_t + (double)maxDistanceAway), (double)(entityOrigin.field_70163_u + (double)maxDistanceAway), (double)(entityOrigin.field_70161_v + (double)maxDistanceAway)));
        ArrayList<Entity> returnList = new ArrayList<Entity>();
        for (Entity entity : entitiesAroundMe) {
            if (!entity.getClass().isAssignableFrom(clazz)) continue;
            returnList.add(entity);
        }
        return returnList;
    }

    public static EntityPlayer getPlayerByUUID(String uuid, World world) {
        for (Object obj : world.field_73010_i) {
            EntityPlayer player = (EntityPlayer)obj;
            if (!player.getPersistentID().toString().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    private RadixLogic() {
    }

    public static int getSpawnSafeTopLevel(World worldObj, int x, int z) {
        int y = 256;
        Block block = Blocks.field_150350_a;
        while (block == Blocks.field_150350_a) {
            block = worldObj.func_147439_a(x, --y, z);
        }
        return y + 1;
    }
}

