/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.capabilities;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.nbt.NBTTagCompound;

public class BaseOMTeslaContainer
implements ITeslaConsumer,
ITeslaProducer,
ITeslaHolder {
    private long stored;
    private long capacity;
    private long inputRate;
    private long outputRate;

    public BaseOMTeslaContainer() {
        this(50000L, 1000L, 1000L);
    }

    public BaseOMTeslaContainer(long capacity, long input, long output) {
        this(0L, capacity, input, output);
    }

    public BaseOMTeslaContainer(long power, long capacity, long input, long output) {
        this.stored = power;
        this.capacity = capacity;
        this.inputRate = input;
        this.outputRate = output;
    }

    public BaseOMTeslaContainer(NBTTagCompound dataTag) {
        this.deserializeNBT(dataTag);
    }

    public long getStoredPower() {
        return this.stored;
    }

    public long givePower(long Tesla, boolean simulated) {
        long acceptedTesla = Math.min(this.getCapacity() - this.stored, Math.min(this.getInputRate(), Tesla));
        if (!simulated) {
            this.stored += acceptedTesla;
        }
        return acceptedTesla;
    }

    public long takePower(long Tesla, boolean simulated) {
        long removedPower = Math.min(this.stored, Math.min(this.getOutputRate(), Tesla));
        if (!simulated) {
            this.stored -= removedPower;
        }
        return removedPower;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public NBTTagCompound serializeNBT(NBTTagCompound dataTag) {
        dataTag.func_74772_a("TeslaPower", this.stored);
        dataTag.func_74772_a("TeslaCapacity", this.capacity);
        dataTag.func_74772_a("TeslaInput", this.inputRate);
        dataTag.func_74772_a("TeslaOutput", this.outputRate);
        return dataTag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("TeslaPower")) {
            this.stored = nbt.func_74763_f("TeslaPower");
        }
        if (nbt.func_74764_b("TeslaCapacity")) {
            this.capacity = nbt.func_74763_f("TeslaCapacity");
        }
        if (nbt.func_74764_b("TeslaInput")) {
            this.inputRate = nbt.func_74763_f("TeslaInput");
        }
        if (nbt.func_74764_b("TeslaOutput")) {
            this.outputRate = nbt.func_74763_f("TeslaOutput");
        }
        if (this.stored > this.getCapacity()) {
            this.stored = this.getCapacity();
        }
    }

    public BaseOMTeslaContainer setCapacity(long capacity) {
        this.capacity = capacity;
        if (this.stored > capacity) {
            this.stored = capacity;
        }
        return this;
    }

    public long getInputRate() {
        return this.inputRate;
    }

    public BaseOMTeslaContainer setInputRate(long rate) {
        this.inputRate = rate;
        return this;
    }

    public long getOutputRate() {
        return this.outputRate;
    }

    public BaseOMTeslaContainer setOutputRate(long rate) {
        this.outputRate = rate;
        return this;
    }

    public BaseOMTeslaContainer setTransferRate(long rate) {
        this.setInputRate(rate);
        this.setOutputRate(rate);
        return this;
    }
}

