/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.tileentity;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import omtteam.omlib.capabilities.BaseOMTeslaContainer;
import omtteam.omlib.compatability.ModCompatibility;
import omtteam.omlib.handler.ConfigHandler;
import omtteam.omlib.tileentity.TileEntityContainer;
import omtteam.omlib.util.MathUtil;
import omtteam.omlib.util.PlayerUtil;
import omtteam.omlib.util.TrustedPlayer;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2")})
public abstract class TileEntityMachine
extends TileEntityContainer
implements IEnergyReceiver,
IEnergySink {
    protected EnergyStorage storage;
    protected Object teslaContainer;
    protected double storageEU;
    protected boolean active;
    protected boolean inverted;
    protected boolean redstone;
    protected boolean wasAddedToEnergyNet = false;
    protected List<TrustedPlayer> trustedPlayers = new ArrayList<TrustedPlayer>();

    public TileEntityMachine() {
        this.inventory = new ItemStack[13];
        this.storage = new EnergyStorage(10, 10);
        this.inverted = true;
        this.active = true;
    }

    public boolean addTrustedPlayer(String name) {
        TrustedPlayer trustedPlayer = new TrustedPlayer(name);
        trustedPlayer.uuid = PlayerUtil.getPlayerUUID(name);
        if (trustedPlayer.uuid != null) {
            for (TrustedPlayer player : this.trustedPlayers) {
                if (!player.getName().toLowerCase().equals(name.toLowerCase()) && !trustedPlayer.uuid.toString().equals(this.owner)) continue;
                return true;
            }
            this.trustedPlayers.add(trustedPlayer);
            return true;
        }
        return false;
    }

    public boolean removeTrustedPlayer(String name) {
        for (TrustedPlayer player : this.trustedPlayers) {
            if (!player.getName().equals(name)) continue;
            this.trustedPlayers.remove(player);
            return true;
        }
        return false;
    }

    public List<TrustedPlayer> getTrustedPlayers() {
        return this.trustedPlayers;
    }

    public TrustedPlayer getTrustedPlayer(String name) {
        for (TrustedPlayer trustedPlayer : this.trustedPlayers) {
            if (!trustedPlayer.name.equals(name)) continue;
            return trustedPlayer;
        }
        return null;
    }

    public TrustedPlayer getTrustedPlayer(UUID uuid) {
        for (TrustedPlayer trustedPlayer : this.trustedPlayers) {
            if (!trustedPlayer.uuid.equals(uuid)) continue;
            return trustedPlayer;
        }
        return null;
    }

    public void setTrustedPlayers(List<TrustedPlayer> list) {
        this.trustedPlayers = list;
    }

    private NBTTagList getTrustedPlayersAsNBT() {
        NBTTagList nbt = new NBTTagList();
        for (TrustedPlayer trustedPlayer : this.trustedPlayers) {
            NBTTagCompound nbtPlayer = new NBTTagCompound();
            nbtPlayer.func_74778_a("name", trustedPlayer.name);
            nbtPlayer.func_74757_a("canOpenGUI", trustedPlayer.canOpenGUI);
            nbtPlayer.func_74757_a("canChangeTargeting", trustedPlayer.canChangeTargeting);
            nbtPlayer.func_74757_a("admin", trustedPlayer.admin);
            if (trustedPlayer.uuid != null) {
                nbtPlayer.func_74778_a("UUID", trustedPlayer.uuid.toString());
            } else if (PlayerUtil.getPlayerUUID(trustedPlayer.name) != null) {
                nbtPlayer.func_74778_a("UUID", PlayerUtil.getPlayerUUID(trustedPlayer.name).toString());
            }
            nbt.func_74742_a((NBTBase)nbtPlayer);
        }
        return nbt;
    }

    private void buildTrustedPlayersFromNBT(NBTTagList nbt) {
        this.trustedPlayers.clear();
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            if (!nbt.func_150305_b(i).func_74779_i("name").equals("")) {
                NBTTagCompound nbtPlayer = nbt.func_150305_b(i);
                TrustedPlayer trustedPlayer = new TrustedPlayer(nbtPlayer.func_74779_i("name"));
                trustedPlayer.canOpenGUI = nbtPlayer.func_74767_n("canOpenGUI");
                trustedPlayer.canChangeTargeting = nbtPlayer.func_74767_n("canChangeTargeting");
                trustedPlayer.admin = nbtPlayer.func_74767_n("admin");
                trustedPlayer.uuid = nbtPlayer.func_74764_b("UUID") ? PlayerUtil.getPlayerUIDUnstable(nbtPlayer.func_74779_i("UUID")) : PlayerUtil.getPlayerUUID(trustedPlayer.name);
                if (trustedPlayer.uuid == null) continue;
                this.trustedPlayers.add(trustedPlayer);
                continue;
            }
            if (!nbt.func_150305_b(i).func_74779_i("name").equals("")) continue;
            TrustedPlayer trustedPlayer = new TrustedPlayer(nbt.func_150307_f(i));
            Logger.getGlobal().info("found legacy trusted Player: " + nbt.func_150307_f(i));
            trustedPlayer.uuid = PlayerUtil.getPlayerUUID(trustedPlayer.name);
            if (trustedPlayer.uuid == null) continue;
            this.trustedPlayers.add(trustedPlayer);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("maxStorage", this.storage.getMaxEnergyStored());
        nbtTagCompound.func_74768_a("energyStored", this.getEnergyStored(EnumFacing.DOWN));
        nbtTagCompound.func_74768_a("maxIO", this.storage.getMaxReceive());
        nbtTagCompound.func_74782_a("trustedPlayers", (NBTBase)this.getTrustedPlayersAsNBT());
        nbtTagCompound.func_74780_a("storageEU", this.storageEU);
        nbtTagCompound.func_74757_a("active", this.active);
        nbtTagCompound.func_74757_a("inverted", this.inverted);
        nbtTagCompound.func_74757_a("redstone", this.redstone);
        return nbtTagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.storage.setCapacity(nbtTagCompound.func_74762_e("maxStorage"));
        this.storage.setEnergyStored(nbtTagCompound.func_74762_e("energyStored"));
        this.storage.setMaxReceive(nbtTagCompound.func_74762_e("maxIO"));
        this.active = !nbtTagCompound.func_74764_b("active") || nbtTagCompound.func_74767_n("active");
        boolean bl = this.inverted = !nbtTagCompound.func_74764_b("inverted") || nbtTagCompound.func_74767_n("inverted");
        if (nbtTagCompound.func_74764_b("redstone")) {
            this.redstone = nbtTagCompound.func_74767_n("redstone");
        }
        this.buildTrustedPlayersFromNBT(nbtTagCompound.func_150295_c("trustedPlayers", 10));
        this.storageEU = nbtTagCompound.func_74764_b("storageEU") ? nbtTagCompound.func_74769_h("storageEU") : 0.0;
    }

    public boolean isActive() {
        return this.active;
    }

    protected boolean getInverted() {
        return this.inverted;
    }

    protected void setInverted(boolean inverted) {
        this.inverted = inverted;
        this.active = this.redstone ^ this.inverted;
        this.func_70296_d();
    }

    protected boolean getRedstone() {
        return this.redstone;
    }

    public void setRedstone(boolean redstone) {
        this.redstone = redstone;
        this.active = this.redstone ^ this.inverted;
        this.func_70296_d();
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        this.func_70296_d();
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    public void setEnergyStored(int energy) {
        this.storage.setEnergyStored(energy);
        this.func_70296_d();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(EnumFacing facing, double v, double v1) {
        this.storageEU += v;
        this.func_70296_d();
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        if (ConfigHandler.EUSupport && this.storage.getMaxEnergyStored() != this.storage.getEnergyStored() && this.storageEU > 0.0) {
            this.storage.modifyEnergyStored(MathUtil.truncateDoubleToInt(Math.min((double)(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()), this.storageEU * ConfigHandler.EUtoRFRatio)));
            this.storageEU -= Math.min((double)(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) / ConfigHandler.EUtoRFRatio, this.storageEU * ConfigHandler.EUtoRFRatio);
        }
        return Math.max(4000.0 - this.storageEU, 0.0);
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(IEnergyEmitter tileEntity, EnumFacing facing) {
        return true;
    }

    @Optional.Method(modid="IC2")
    protected void addToIc2EnergyNetwork() {
        if (!this.field_145850_b.field_72995_K) {
            EnergyTileLoadEvent event = new EnergyTileLoadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    @Optional.Method(modid="IC2")
    protected void removeFromIc2EnergyNetwork() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        if (this.wasAddedToEnergyNet && ModCompatibility.IC2Loaded) {
            this.removeFromIc2EnergyNetwork();
            this.wasAddedToEnergyNet = false;
        }
    }

    @Optional.Method(modid="tesla")
    private BaseOMTeslaContainer getTeslaContainer(Object container) {
        if (container instanceof BaseOMTeslaContainer) {
            return (BaseOMTeslaContainer)container;
        }
        container = new BaseOMTeslaContainer();
        return (BaseOMTeslaContainer)container;
    }

    @Optional.Method(modid="tesla")
    private void moveEnergyFromTeslaToRF() {
        int energyNeeded;
        if (this.getTeslaContainer(this.teslaContainer) != null && (energyNeeded = this.storage.getEnergyStored() - this.storage.getMaxEnergyStored()) > 0) {
            this.storage.modifyEnergyStored((int)((BaseOMTeslaContainer)this.teslaContainer).takePower(energyNeeded, false));
        }
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (ModCompatibility.TeslaLoaded && this.getTeslaCapability(capability, facing) != null) {
            return this.getTeslaCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (ModCompatibility.TeslaLoaded && this.hasTeslaCapability(capability, facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Optional.Method(modid="tesla")
    private boolean hasTeslaCapability(Capability<?> capability, EnumFacing facing) {
        return capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_HOLDER;
    }

    @Optional.Method(modid="tesla")
    private <T> T getTeslaCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_HOLDER) {
            this.moveEnergyFromTeslaToRF();
            this.func_70296_d();
            return (T)this.getTeslaContainer(this.teslaContainer);
        }
        return null;
    }
}

