/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.util;

import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.UsernameCache;
import omtteam.omlib.handler.ConfigHandler;
import omtteam.omlib.tileentity.TileEntityMachine;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.TrustedPlayer;

public class PlayerUtil {
    public static UUID getPlayerUUID(String username) {
        for (Map.Entry entry : UsernameCache.getMap().entrySet()) {
            if (!((String)entry.getValue()).equalsIgnoreCase(username)) continue;
            return (UUID)entry.getKey();
        }
        return null;
    }

    public static UUID getPlayerUIDUnstable(String possibleUUID) {
        UUID uuid;
        if (possibleUUID == null || possibleUUID.isEmpty()) {
            return null;
        }
        try {
            uuid = UUID.fromString(possibleUUID);
        }
        catch (IllegalArgumentException e) {
            uuid = PlayerUtil.getPlayerUUID(possibleUUID);
        }
        return uuid;
    }

    public static String getPlayerNameFromUUID(String possibleUUID) {
        if (possibleUUID == null || possibleUUID.isEmpty()) {
            return null;
        }
        return UsernameCache.getLastKnownUsername((UUID)UUID.fromString(possibleUUID));
    }

    public static TrustedPlayer getTrustedPlayer(EntityPlayer player, TileEntityMachine machine) {
        if (machine.getTrustedPlayer(player.func_110124_au()) != null || ConfigHandler.offlineModeSupport && machine.getTrustedPlayer(player.func_70005_c_()) != null) {
            return machine.getTrustedPlayer(player.func_110124_au()) == null ? machine.getTrustedPlayer(player.func_70005_c_()) : machine.getTrustedPlayer(player.func_110124_au());
        }
        return null;
    }

    public static boolean isPlayerOwner(EntityPlayer player, TileEntityOwnedBlock ownedBlock) {
        return ownedBlock.getOwner().equals(player.func_110124_au().toString()) || ConfigHandler.offlineModeSupport && ownedBlock.getOwnerName().equals(player.func_70005_c_());
    }
}

