/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.blocks;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.blocks.BlockAbstractTileEntity;
import omtteam.omlib.util.WorldUtil;
import omtteam.openmodularturrets.OpenModularTurrets;
import omtteam.openmodularturrets.init.ModBlocks;
import omtteam.openmodularturrets.tileentity.Expander;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class BlockExpander
extends BlockAbstractTileEntity {
    public static final PropertyInteger META = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)9);
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockExpander() {
        super(Material.field_151576_e);
        this.func_149647_a(OpenModularTurrets.modularTurretsTab);
        this.func_149752_b(3.0f);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)META, (Comparable)Integer.valueOf(0)));
        this.setRegistryName("openmodularturrets", "expander");
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)META);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{META, FACING});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Expander te = (Expander)worldIn.func_175625_s(pos);
        if (te != null) {
            return state.func_177226_a((IProperty)FACING, (Comparable)te.getOrientation());
        }
        return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)META) < 5) {
            return new Expander((Integer)state.func_177229_b((IProperty)META), false);
        }
        return new Expander((Integer)state.func_177229_b((IProperty)META), true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB((double)0.1f, (double)0.1f, (double)0.1f, (double)0.9f, (double)0.9f, (double)0.9f);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if ((Integer)state.func_177229_b((IProperty)META) > 4) {
            return true;
        }
        Expander expander = (Expander)world.func_175625_s(pos);
        if (expander == null) {
            return true;
        }
        TurretBase base = expander.getBase();
        if (base != null && base.getTrustedPlayer(player.func_110124_au()) != null && base.getTrustedPlayer((UUID)player.func_110124_au()).canOpenGUI) {
            player.openGui((Object)OpenModularTurrets.instance, 7, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (base != null && player.func_110124_au().toString().equals(base.getOwner())) {
            player.openGui((Object)OpenModularTurrets.instance, 7, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"status.ownership")));
        }
        return true;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (TileEntity tileEntity : WorldUtil.getTouchingTileEntities((World)worldIn, (BlockPos)pos)) {
            if (!(tileEntity instanceof TurretBase)) continue;
            return true;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            this.dropItems(worldIn, pos);
            super.func_180663_b(worldIn, pos, state);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        Expander expander = (Expander)worldIn.func_175625_s(pos);
        if (expander != null) {
            expander.setOwnerName(expander.getBase().getOwnerName());
            expander.setOwner(expander.getBase().getOwner());
        }
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)META);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subItems) {
        for (int i = 0; i < 10; ++i) {
            subItems.add(new ItemStack(ModBlocks.expander, 1, i));
        }
    }
}

