/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.blocks.BlockAbstractTileEntity;
import omtteam.omlib.tileentity.TileEntityMachine;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.PlayerUtil;
import omtteam.omlib.util.TrustedPlayer;
import omtteam.openmodularturrets.OpenModularTurrets;
import omtteam.openmodularturrets.handler.ConfigHandler;
import omtteam.openmodularturrets.init.ModBlocks;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class BlockTurretBase
extends BlockAbstractTileEntity {
    public static final PropertyInteger TIER = PropertyInteger.func_177719_a((String)"tier", (int)1, (int)5);

    public BlockTurretBase() {
        super(Material.field_151576_e);
        this.func_149647_a(OpenModularTurrets.modularTurretsTab);
        if (!ConfigHandler.turretBreakable) {
            this.func_149722_s();
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TIER, (Comparable)Integer.valueOf(1)));
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("turret_base");
        this.setRegistryName("openmodularturrets", "turret_base");
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((Integer)state.func_177229_b((IProperty)TIER) - 1) {
            case 0: {
                int MaxCharge = ConfigHandler.getBaseTierOneMaxCharge();
                int MaxIO = ConfigHandler.getBaseTierOneMaxIo();
                return new TurretBase(MaxCharge, MaxIO, 1);
            }
            case 1: {
                int MaxCharge = ConfigHandler.getBaseTierTwoMaxCharge();
                int MaxIO = ConfigHandler.getBaseTierTwoMaxIo();
                return new TurretBase(MaxCharge, MaxIO, 2);
            }
            case 2: {
                int MaxCharge = ConfigHandler.getBaseTierThreeMaxCharge();
                int MaxIO = ConfigHandler.getBaseTierThreeMaxIo();
                return new TurretBase(MaxCharge, MaxIO, 3);
            }
            case 3: {
                int MaxCharge = ConfigHandler.getBaseTierFourMaxCharge();
                int MaxIO = ConfigHandler.getBaseTierFourMaxIo();
                return new TurretBase(MaxCharge, MaxIO, 4);
            }
            case 4: {
                int MaxCharge = ConfigHandler.getBaseTierFiveMaxCharge();
                int MaxIO = ConfigHandler.getBaseTierFiveMaxIo();
                return new TurretBase(MaxCharge, MaxIO, 5);
            }
        }
        return null;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TIER, (Comparable)Integer.valueOf(meta + 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TIER) - 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TIER});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TurretBase base = (TurretBase)world.func_175625_s(pos);
        if (!world.field_72995_K && !player.func_70093_af() && base != null) {
            TrustedPlayer trustedPlayer = PlayerUtil.getTrustedPlayer((EntityPlayer)player, (TileEntityMachine)base);
            if (trustedPlayer != null && trustedPlayer.canOpenGUI) {
                world.func_184138_a(pos, state, state, 6);
                player.openGui((Object)OpenModularTurrets.instance, base.getTier(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return true;
            }
            if (PlayerUtil.isPlayerOwner((EntityPlayer)player, (TileEntityOwnedBlock)base)) {
                world.func_184138_a(pos, state, state, 6);
                player.openGui((Object)OpenModularTurrets.instance, base.getTier(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"status.ownership")));
            }
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!worldIn.field_72995_K) {
            TurretBase base = (TurretBase)worldIn.func_175625_s(pos);
            if (base != null && worldIn.func_175687_A(pos) > 0) {
                base.setRedstone(true);
            } else if (base != null && worldIn.func_175687_A(pos) == 0) {
                base.setRedstone(false);
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K && worldIn.func_175625_s(pos) instanceof TurretBase) {
            EntityPlayerMP player = (EntityPlayerMP)placer;
            TurretBase base = (TurretBase)worldIn.func_175625_s(pos);
            if (base == null) {
                return;
            }
            base.setOwner(player.func_110124_au().toString());
            if (worldIn.func_175687_A(pos) > 0) {
                base.setRedstone(true);
            } else if (worldIn.func_175687_A(pos) == 0) {
                base.setRedstone(false);
            }
            base.func_70296_d();
            switch ((Integer)state.func_177229_b((IProperty)TIER)) {
                case 1: {
                    this.func_149752_b(ConfigHandler.getBaseTierOneBlastResistance());
                    break;
                }
                case 2: {
                    this.func_149752_b(ConfigHandler.getBaseTierTwoBlastResistance());
                    break;
                }
                case 3: {
                    this.func_149752_b(ConfigHandler.getBaseTierThreeBlastResistance());
                    break;
                }
                case 4: {
                    this.func_149752_b(ConfigHandler.getBaseTierFourBlastResistance());
                    break;
                }
                case 5: {
                    this.func_149752_b(ConfigHandler.getBaseTierFiveBlastResistance());
                }
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            this.dropItems(worldIn, pos);
            super.func_180663_b(worldIn, pos, state);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(0, new ItemStack(ModBlocks.turretBase, 1, this.func_176201_c(state)));
        return drops;
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TIER) - 1;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ModBlocks.turretBase, 1, (Integer)state.func_177229_b((IProperty)TIER) - 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subItems) {
        for (int i = 0; i < 5; ++i) {
            subItems.add(new ItemStack(ModBlocks.turretBase, 1, i));
        }
    }
}

