/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.client.render.renderers.blockitem;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import omtteam.openmodularturrets.client.render.models.ModelDamageAmp;
import omtteam.openmodularturrets.client.render.models.ModelGrenadeLauncher;
import omtteam.openmodularturrets.client.render.models.ModelRedstoneReactor;
import omtteam.openmodularturrets.client.render.models.ModelSolarPanelAddon;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;
import omtteam.openmodularturrets.util.TurretHeadUtil;
import org.lwjgl.opengl.GL11;

public class GrenadeLauncherTurretRenderer
extends TileEntitySpecialRenderer {
    private final ModelSolarPanelAddon solar;
    private final ModelDamageAmp amp;
    private final ModelRedstoneReactor reac;
    private final ModelGrenadeLauncher model = new ModelGrenadeLauncher();

    public GrenadeLauncherTurretRenderer() {
        this.solar = new ModelSolarPanelAddon();
        this.amp = new ModelDamageAmp();
        this.reac = new ModelRedstoneReactor();
    }

    public void func_180535_a(TileEntity te, double x, double y, double z, float scale, int destroyStage) {
        TurretHead turretHead = (TurretHead)te;
        int rotation = 0;
        ResourceLocation textures = new ResourceLocation("openmodularturrets:textures/blocks/grenade_turret.png");
        Minecraft.func_71410_x().field_71446_o.func_110577_a(textures);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        if (te == null) {
            GL11.glScalef((float)0.7f, (float)-0.7f, (float)-0.7f);
            GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + 0.4f), (float)((float)z + 0.5f));
            GL11.glRotatef((float)45.0f, (float)2.5f, (float)-4.5f, (float)-1.0f);
            this.model.renderAll();
            GL11.glPopMatrix();
            return;
        }
        if (turretHead.shouldConceal) {
            GL11.glPopMatrix();
            return;
        }
        if (te.func_145831_w() != null) {
            rotation = te.func_145832_p();
            GL11.glRotatef((float)(rotation * 90), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            this.model.setRotationForTarget(turretHead.rotationXY, turretHead.rotationXZ);
            this.model.Base.field_78795_f = turretHead.baseFitRotationX;
            this.model.Base.field_78796_g = turretHead.baseFitRotationZ;
            this.model.Pole.field_78795_f = turretHead.baseFitRotationX;
            this.model.Pole.field_78796_g = turretHead.baseFitRotationZ;
            this.model.BoxUnder.field_78795_f = turretHead.baseFitRotationX;
        }
        this.model.renderAll();
        if (turretHead.base != null) {
            if (TurretHeadUtil.hasSolarPanelAddon(turretHead.base)) {
                ResourceLocation texturesSolar = new ResourceLocation("openmodularturrets:textures/blocks/addon_solar_panel.png");
                Minecraft.func_71410_x().field_71446_o.func_110577_a(texturesSolar);
                this.solar.setRotationForTarget(turretHead.rotationXY, turretHead.rotationXZ);
                this.solar.renderAll();
            }
            if (TurretHeadUtil.hasDamageAmpAddon(turretHead.base)) {
                ResourceLocation texturesAmp = new ResourceLocation("openmodularturrets:textures/blocks/addon_damage_amp.png");
                Minecraft.func_71410_x().field_71446_o.func_110577_a(texturesAmp);
                this.amp.setRotationForTarget(turretHead.rotationXY, turretHead.rotationXZ);
                this.amp.renderAll();
            }
            if (TurretHeadUtil.hasRedstoneReactor(turretHead.base)) {
                ResourceLocation texturesReac = new ResourceLocation("openmodularturrets:textures/blocks/redstone_reactor.png");
                Minecraft.func_71410_x().field_71446_o.func_110577_a(texturesReac);
                this.reac.setRotationForTarget(turretHead.rotationXY, turretHead.rotationXZ);
                this.reac.renderAll();
            }
        }
        GL11.glPopMatrix();
    }
}

