/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.entity.projectiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import omtteam.omlib.util.PlayerUtil;
import omtteam.openmodularturrets.handler.ConfigHandler;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.util.TurretHeadUtil;

public abstract class TurretProjectile
extends EntityThrowable {
    public float gravity;
    boolean isAmped;
    int amp_level;
    ItemStack ammo;
    private TurretBase turretBase;

    TurretProjectile(World world) {
        super(world);
    }

    TurretProjectile(World world, TurretBase turretBase) {
        super(world);
        this.turretBase = turretBase;
        if (TurretHeadUtil.getAmpLevel(turretBase) > 0) {
            this.isAmped = true;
            this.amp_level = TurretHeadUtil.getAmpLevel(turretBase);
        }
    }

    TurretProjectile(World world, ItemStack ammo, TurretBase turretBase) {
        super(world);
        this.ammo = ammo;
        this.turretBase = turretBase;
        if (TurretHeadUtil.getAmpLevel(turretBase) > 0) {
            this.isAmped = true;
            this.amp_level = TurretHeadUtil.getAmpLevel(turretBase);
        }
    }

    boolean canDamagePlayer(EntityPlayer entityPlayer) {
        return ConfigHandler.turretDamageTrustedPlayers || this.turretBase.getTrustedPlayer(entityPlayer.func_110124_au()) == null && !PlayerUtil.getPlayerUIDUnstable((String)this.turretBase.getOwner()).equals(entityPlayer.func_110124_au());
    }

    public boolean func_70039_c(NBTTagCompound nbtTagCompound) {
        this.func_70106_y();
        return false;
    }
}

