/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.network.messages;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import omtteam.omlib.util.TrustedPlayer;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class MessageTurretBase
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int rfStorage;
    private int tier;
    private boolean attacksMobs;
    private boolean attacksNeutrals;
    private boolean attacksPlayers;
    private boolean multiTargeting;
    private String owner;
    private String ownerName;
    private List<TrustedPlayer> trustedPlayers = new ArrayList<TrustedPlayer>();
    private ItemStack camoStack;

    public MessageTurretBase() {
    }

    public MessageTurretBase(TileEntity tileEntity) {
        if (tileEntity instanceof TurretBase) {
            TurretBase TurretBase2 = (TurretBase)tileEntity;
            this.x = TurretBase2.func_174877_v().func_177958_n();
            this.y = TurretBase2.func_174877_v().func_177956_o();
            this.z = TurretBase2.func_174877_v().func_177952_p();
            this.tier = TurretBase2.getTier();
            this.owner = TurretBase2.getOwner();
            this.ownerName = TurretBase2.getOwnerName();
            this.rfStorage = TurretBase2.getEnergyStored(EnumFacing.DOWN);
            this.attacksMobs = TurretBase2.isAttacksMobs();
            this.attacksNeutrals = TurretBase2.isAttacksNeutrals();
            this.attacksPlayers = TurretBase2.isAttacksPlayers();
            this.multiTargeting = TurretBase2.isMultiTargeting();
            this.trustedPlayers = TurretBase2.getTrustedPlayers();
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.tier = buf.readInt();
        int ownerLength = buf.readInt();
        this.owner = new String(buf.readBytes(ownerLength).array());
        int ownerNameLength = buf.readInt();
        this.ownerName = new String(buf.readBytes(ownerNameLength).array());
        this.rfStorage = buf.readInt();
        this.attacksMobs = buf.readBoolean();
        this.attacksNeutrals = buf.readBoolean();
        this.attacksPlayers = buf.readBoolean();
        this.multiTargeting = buf.readBoolean();
        int lengthOfTPList = buf.readInt();
        if (lengthOfTPList > 0) {
            for (int i = 0; i < lengthOfTPList; ++i) {
                int length = buf.readInt();
                String name = new String(buf.readBytes(length).array());
                TrustedPlayer trustedPlayer = new TrustedPlayer(name);
                length = buf.readInt();
                trustedPlayer.uuid = UUID.fromString(new String(buf.readBytes(length).array()));
                trustedPlayer.canOpenGUI = buf.readBoolean();
                trustedPlayer.canChangeTargeting = buf.readBoolean();
                trustedPlayer.admin = buf.readBoolean();
                this.trustedPlayers.add(trustedPlayer);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.tier);
        buf.writeInt(this.owner.length());
        buf.writeBytes(this.owner.getBytes());
        buf.writeInt(this.ownerName.length());
        buf.writeBytes(this.ownerName.getBytes());
        buf.writeInt(this.rfStorage);
        buf.writeBoolean(this.attacksMobs);
        buf.writeBoolean(this.attacksNeutrals);
        buf.writeBoolean(this.attacksPlayers);
        buf.writeBoolean(this.multiTargeting);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.camoStack);
        buf.writeInt(this.trustedPlayers.size());
        if (this.trustedPlayers.size() > 0) {
            for (TrustedPlayer trustedPlayer : this.trustedPlayers) {
                buf.writeInt(trustedPlayer.getName().length());
                buf.writeBytes(trustedPlayer.getName().getBytes());
                buf.writeInt(trustedPlayer.uuid.toString().length());
                buf.writeBytes(trustedPlayer.uuid.toString().getBytes());
                buf.writeBoolean(trustedPlayer.canOpenGUI);
                buf.writeBoolean(trustedPlayer.canChangeTargeting);
                buf.writeBoolean(trustedPlayer.admin);
            }
        }
    }

    public String toString() {
        return String.format("MessageTurretBase - x:%s, y:%s, z:%s, owner:%s, rfstorage:%s", this.x, this.y, this.z, this.owner, this.rfStorage);
    }

    public static class MessageHandlerTurretBase
    implements IMessageHandler<MessageTurretBase, IMessage> {
        public IMessage onMessage(MessageTurretBase messageIn, MessageContext ctx) {
            final MessageTurretBase message = messageIn;
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TileEntity tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_175625_s(new BlockPos(message.x, message.y, message.z));
                    if (tileEntity instanceof TurretBase) {
                        ((TurretBase)tileEntity).setOwner(message.owner);
                        ((TurretBase)tileEntity).setOwnerName(message.ownerName);
                        ((TurretBase)tileEntity).setEnergyStored(message.rfStorage);
                        ((TurretBase)tileEntity).setAttacksMobs(message.attacksMobs);
                        ((TurretBase)tileEntity).setAttacksNeutrals(message.attacksNeutrals);
                        ((TurretBase)tileEntity).setAttacksPlayers(message.attacksPlayers);
                        ((TurretBase)tileEntity).setMultiTargeting(message.multiTargeting);
                        ((TurretBase)tileEntity).setTrustedPlayers(message.trustedPlayers);
                        ((TurretBase)tileEntity).setTier(message.tier);
                    }
                }
            });
            return null;
        }
    }
}

