/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.proxy;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import omtteam.openmodularturrets.blocks.LeverBlock;
import omtteam.openmodularturrets.client.render.renderers.blockitem.TileEntityRenderers;
import omtteam.openmodularturrets.client.render.renderers.projectiles.ProjectileRenderers;
import omtteam.openmodularturrets.compatability.IGWHandler;
import omtteam.openmodularturrets.compatability.ModCompatibility;
import omtteam.openmodularturrets.init.ModBlocks;
import omtteam.openmodularturrets.init.ModItems;
import omtteam.openmodularturrets.init.ModTESRItems;
import omtteam.openmodularturrets.items.AddonMetaItem;
import omtteam.openmodularturrets.items.AmmoMetaItem;
import omtteam.openmodularturrets.items.IntermediateProductRegular;
import omtteam.openmodularturrets.items.IntermediateProductTiered;
import omtteam.openmodularturrets.items.ThrowableMetaItem;
import omtteam.openmodularturrets.items.UpgradeMetaItem;
import omtteam.openmodularturrets.proxy.CommonProxy;

public class ClientProxy
extends CommonProxy {
    private void registerItemModel(Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString().toLowerCase()));
    }

    private void registerItemModel(Item item, int meta, String variantName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(item.getRegistryName().toString().toLowerCase()), variantName));
    }

    private void registerItemModel(Item item, int meta, String customName, boolean useCustomName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("openmodularturrets".toLowerCase() + ":" + customName.toLowerCase()));
    }

    private void registerBlockModelAsItem(Block block, int meta, String blockName) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation("openmodularturrets".toLowerCase() + ":" + blockName, "inventory"));
    }

    private void registerBlockModelAsItem(Block block, int meta, String blockName, String variantName) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation("openmodularturrets".toLowerCase() + ":" + blockName, variantName));
    }

    @Override
    public void preInit() {
        int i;
        super.preInit();
        for (i = 0; i < 5; ++i) {
            this.registerBlockModelAsItem(ModBlocks.turretBase, i, "turret_base", "tier=" + (i + 1));
        }
        for (i = 0; i < 10; ++i) {
            this.registerBlockModelAsItem(ModBlocks.expander, i, "expander", "facing=north,meta=" + i);
        }
        for (i = 0; i < 15; ++i) {
            this.registerItemModel(ModItems.intermediateProductTiered, i, IntermediateProductTiered.subNames[i], true);
        }
        for (i = 0; i < 7; ++i) {
            this.registerItemModel(ModItems.addonMetaItem, i, AddonMetaItem.subNames[i], true);
        }
        for (i = 0; i < 5; ++i) {
            this.registerItemModel(ModItems.upgradeMetaItem, i, UpgradeMetaItem.subNames[i], true);
        }
        for (i = 0; i < 1; ++i) {
            this.registerItemModel(ModItems.intermediateProductRegular, i, IntermediateProductRegular.subNames[i], true);
        }
        for (i = 0; i < 5; ++i) {
            this.registerItemModel(ModItems.ammoMetaItem, i, AmmoMetaItem.subNames[i], true);
        }
        for (i = 0; i < 2; ++i) {
            this.registerItemModel(ModItems.throwableMetaItem, i, ThrowableMetaItem.subNames[i], true);
        }
        StateMap ignoreRotation = new StateMap.Builder().func_178442_a(new IProperty[]{LeverBlock.ROTATION}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)ModBlocks.leverBlock, (IStateMapper)ignoreRotation);
    }

    @Override
    public void initRenderers() {
        super.initRenderers();
        TileEntityRenderers.init();
        ProjectileRenderers.init();
        ModTESRItems.init();
    }

    @Override
    public void initHandlers() {
        super.initHandlers();
        if (ModCompatibility.IGWModLoaded) {
            ModCompatibility.igwHandler = IGWHandler.getInstance();
        }
    }
}

