/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import omtteam.omlib.tileentity.TileEntityContainer;
import omtteam.omlib.util.MathUtil;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.util.TurretHeadUtil;

public class Expander
extends TileEntityContainer
implements ITickable {
    public float baseFitRotationX;
    public float baseFitRotationZ;
    protected TurretBase base;
    private boolean hasSetSide = false;
    private boolean powerExpander;
    private EnumFacing orientation;
    protected int tier;

    public Expander() {
        this.inventory = new ItemStack[9];
        this.orientation = EnumFacing.NORTH;
    }

    public Expander(int tier, boolean powerExpander) {
        this.inventory = new ItemStack[9];
        this.tier = tier;
        this.powerExpander = powerExpander;
        this.orientation = EnumFacing.NORTH;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("powerExpander", this.powerExpander);
        nbtTagCompound.func_74774_a("direction", (byte)this.orientation.ordinal());
        nbtTagCompound.func_74768_a("tier", this.tier);
        return nbtTagCompound;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.powerExpander = nbtTagCompound.func_74767_n("powerExpander");
        this.tier = nbtTagCompound.func_74762_e("tier");
        if (nbtTagCompound.func_74764_b("direction")) {
            this.orientation = EnumFacing.func_82600_a((int)nbtTagCompound.func_74771_c("direction"));
        }
    }

    public int func_70297_j_() {
        return MathUtil.truncateDoubleToInt((double)Math.pow(2.0, this.tier + 1));
    }

    private void setSide() {
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177974_f()) instanceof TurretBase) {
            this.orientation = EnumFacing.EAST;
            this.hasSetSide = true;
            return;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177976_e()) instanceof TurretBase) {
            this.orientation = EnumFacing.WEST;
            this.hasSetSide = true;
            return;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b()) instanceof TurretBase) {
            this.orientation = EnumFacing.DOWN;
            this.hasSetSide = true;
            return;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a()) instanceof TurretBase) {
            this.orientation = EnumFacing.UP;
            this.hasSetSide = true;
            return;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177978_c()) instanceof TurretBase) {
            this.orientation = EnumFacing.NORTH;
            this.hasSetSide = true;
            return;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177968_d()) instanceof TurretBase) {
            this.orientation = EnumFacing.SOUTH;
            this.hasSetSide = true;
        }
    }

    public void func_73660_a() {
        if (!this.hasSetSide) {
            this.setSide();
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 2);
        }
        if (this.getBase() == null || this.dropBlock) {
            this.func_145831_w().func_175655_b(this.field_174879_c, true);
        }
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return !this.isPowerExpander();
    }

    public int getTier() {
        return this.tier;
    }

    public TurretBase getBase() {
        return TurretHeadUtil.getTurretBase(this.field_145850_b, this.field_174879_c);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean isPowerExpander() {
        return this.powerExpander;
    }

    public EnumFacing getOrientation() {
        return this.orientation;
    }

    public void setOrientation(EnumFacing orientation) {
        this.orientation = orientation;
    }
}

