/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity;

import cofh.api.energy.EnergyStorage;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.Optional;
import omtteam.omlib.tileentity.TileEntityMachine;
import omtteam.omlib.util.PlayerUtil;
import omtteam.omlib.util.TrustedPlayer;
import omtteam.openmodularturrets.compatability.ModCompatibility;
import omtteam.openmodularturrets.handler.ConfigHandler;
import omtteam.openmodularturrets.util.TurretHeadUtil;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TurretBase
extends TileEntityMachine
implements SimpleComponent,
ITickable {
    public int trustedPlayerIndex = 0;
    public IBlockState camoBlockState;
    public boolean shouldConcealTurrets;
    private boolean multiTargeting = false;
    private int yAxisDetect;
    private boolean attacksMobs;
    private boolean attacksNeutrals;
    private boolean attacksPlayers;
    private int ticks;
    private boolean computerAccessible = false;
    protected int tier;

    public TurretBase() {
    }

    public TurretBase(int MaxEnergyStorage, int MaxIO, int tier) {
        this.yAxisDetect = 2;
        this.storage = new EnergyStorage(MaxEnergyStorage, MaxIO);
        this.attacksMobs = true;
        this.attacksNeutrals = true;
        this.attacksPlayers = false;
        this.inventory = new ItemStack[tier == 5 ? 13 : (tier == 4 ? 12 : (tier == 3 ? 12 : (tier == 2 ? 12 : 9)))];
        this.tier = tier;
    }

    private static void updateRedstoneReactor(TurretBase base) {
        if (!TurretHeadUtil.hasRedstoneReactor(base)) {
            return;
        }
        if (ConfigHandler.getRedstoneReactorAddonGen() < base.getMaxEnergyStored(EnumFacing.DOWN) - base.getEnergyStored(EnumFacing.DOWN)) {
            ItemStack redstoneBlock = TurretHeadUtil.useSpecificItemStackBlockFromBase(base, new ItemStack(Blocks.field_150451_bX));
            if (redstoneBlock == null) {
                redstoneBlock = TurretHeadUtil.getSpecificItemFromInvExpanders(base.func_145831_w(), new ItemStack(Blocks.field_150451_bX), base);
            }
            if (redstoneBlock != null && ConfigHandler.getRedstoneReactorAddonGen() * 9 < base.getMaxEnergyStored(EnumFacing.DOWN) - base.getEnergyStored(EnumFacing.DOWN)) {
                base.storage.modifyEnergyStored(ConfigHandler.getRedstoneReactorAddonGen() * 9);
                return;
            }
            ItemStack redstone = TurretHeadUtil.useSpecificItemStackItemFromBase(base, new ItemStack(Items.field_151137_ax));
            if (redstone == null) {
                redstone = TurretHeadUtil.getSpecificItemFromInvExpanders(base.func_145831_w(), new ItemStack(Items.field_151137_ax), base);
            }
            if (redstone != null) {
                base.storage.modifyEnergyStored(ConfigHandler.getRedstoneReactorAddonGen());
            }
        }
    }

    private int getMaxEnergyStorageWithExtenders() {
        int tier = this.getTier();
        switch (tier) {
            case 1: {
                return ConfigHandler.getBaseTierOneMaxCharge() + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.field_145850_b, this.field_174879_c);
            }
            case 2: {
                return ConfigHandler.getBaseTierTwoMaxCharge() + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.field_145850_b, this.field_174879_c);
            }
            case 3: {
                return ConfigHandler.getBaseTierThreeMaxCharge() + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.field_145850_b, this.field_174879_c);
            }
            case 4: {
                return ConfigHandler.getBaseTierFourMaxCharge() + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.field_145850_b, this.field_174879_c);
            }
            case 5: {
                return ConfigHandler.getBaseTierFiveMaxCharge() + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.field_145850_b, this.field_174879_c);
            }
        }
        return 0;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("yAxisDetect", this.yAxisDetect);
        nbtTagCompound.func_74757_a("attacksMobs", this.attacksMobs);
        nbtTagCompound.func_74757_a("attacksNeutrals", this.attacksNeutrals);
        nbtTagCompound.func_74757_a("attacksPlayers", this.attacksPlayers);
        nbtTagCompound.func_74757_a("computerAccessible", this.computerAccessible);
        nbtTagCompound.func_74757_a("shouldConcealTurrets", this.shouldConcealTurrets);
        nbtTagCompound.func_74757_a("multiTargeting", this.multiTargeting);
        nbtTagCompound.func_74768_a("tier", this.tier);
        if (this.camoBlockState != null) {
            nbtTagCompound.func_74778_a("camoBlockState", this.camoBlockState.toString());
        }
        return nbtTagCompound;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.yAxisDetect = nbtTagCompound.func_74762_e("yAxisDetect");
        this.attacksMobs = nbtTagCompound.func_74767_n("attacksMobs");
        this.attacksNeutrals = nbtTagCompound.func_74767_n("attacksNeutrals");
        this.attacksPlayers = nbtTagCompound.func_74767_n("attacksPlayers");
        this.shouldConcealTurrets = nbtTagCompound.func_74767_n("shouldConcealTurrets");
        this.multiTargeting = nbtTagCompound.func_74767_n("multiTargeting");
        this.tier = nbtTagCompound.func_74762_e("tier");
        this.computerAccessible = nbtTagCompound.func_74764_b("computerAccessible") && nbtTagCompound.func_74767_n("computerAccessible");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.dropBlock) {
            this.field_145850_b.func_175655_b(this.field_174879_c, true);
            return;
        }
        if (omtteam.omlib.compatability.ModCompatibility.IC2Loaded && omtteam.omlib.handler.ConfigHandler.EUSupport && !this.wasAddedToEnergyNet && !this.field_145850_b.field_72995_K) {
            this.addToIc2EnergyNetwork();
            this.wasAddedToEnergyNet = true;
        }
        if (!this.field_145850_b.field_72995_K && this.ticks % 5 == 0) {
            this.shouldConcealTurrets = TurretHeadUtil.hasConcealmentAddon(this);
            this.storage.setCapacity(this.getMaxEnergyStorageWithExtenders());
            if (this.ticks % 20 == 0) {
                this.ticks = 0;
                TurretBase.updateRedstoneReactor(this);
                this.computerAccessible = (ModCompatibility.OpenComputersLoaded || ModCompatibility.ComputerCraftLoaded) && TurretHeadUtil.hasSerialPortAddon(this);
            }
        }
    }

    public boolean isAttacksMobs() {
        return this.attacksMobs;
    }

    public void setAttacksMobs(boolean attacksMobs) {
        this.attacksMobs = attacksMobs;
    }

    public boolean isAttacksNeutrals() {
        return this.attacksNeutrals;
    }

    public void setAttacksNeutrals(boolean attacksNeutrals) {
        this.attacksNeutrals = attacksNeutrals;
    }

    public boolean isAttacksPlayers() {
        return this.attacksPlayers;
    }

    public void setAttacksPlayers(boolean attacksPlayers) {
        this.attacksPlayers = attacksPlayers;
    }

    public boolean isMultiTargeting() {
        return this.multiTargeting;
    }

    public void setMultiTargeting(boolean multiTargeting) {
        this.multiTargeting = multiTargeting;
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public int getyAxisDetect() {
        return this.yAxisDetect;
    }

    public void setyAxisDetect(int yAxisDetect) {
        this.yAxisDetect = yAxisDetect;
        if (this.yAxisDetect > 9) {
            this.yAxisDetect = 9;
        }
        if (this.yAxisDetect < 0) {
            this.yAxisDetect = 0;
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "turretBase";
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():string; returns owner of turret base.")
    public Object[] getOwner(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.getOwner()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; returns if the turret is currently set to attack hostile mobs.")
    public Object[] isAttacksMobs(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.isAttacksMobs()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean;  sets to attack hostile mobs or not.")
    public Object[] setAttacksMobs(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.setAttacksMobs(args.checkBoolean(0));
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; returns if the turret is currently set to attack neutral mobs.")
    public Object[] isAttacksNeutrals(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.isAttacksNeutrals()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; sets to attack neutral mobs or not.")
    public Object[] setAttacksNeutrals(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.setAttacksNeutrals(args.checkBoolean(0));
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; returns if the turret is currently set to attack players.")
    public Object[] isAttacksPlayers(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.isAttacksPlayers()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; sets to attack players or not.")
    public Object[] setAttacksPlayers(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.setAttacksPlayers(args.checkBoolean(0));
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():table; returns a table of trusted players on this base.")
    public Object[] getTrustedPlayers(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.getTrustedPlayers()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(name:String, [canOpenGUI:boolean , canChangeTargeting:boolean , admin:boolean]):string; adds Trusted player to Trustlist.")
    public Object[] addTrustedPlayer(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        if (!this.addTrustedPlayer(args.checkString(0))) {
            return new Object[]{"Name not valid!"};
        }
        TrustedPlayer trustedPlayer = this.getTrustedPlayer(args.checkString(0));
        trustedPlayer.canOpenGUI = args.optBoolean(1, false);
        trustedPlayer.canChangeTargeting = args.optBoolean(1, false);
        trustedPlayer.admin = args.optBoolean(1, false);
        trustedPlayer.uuid = PlayerUtil.getPlayerUUID((String)args.checkString(0));
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():string; removes trusted player from trust list.")
    public Object[] removeTrustedPlayer(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.removeTrustedPlayer(args.checkString(0));
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():int; returns maximum energy storage.")
    public Object[] getMaxEnergyStorage(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.storage.getMaxEnergyStored()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():int; returns current energy stored.")
    public Object[] getCurrentEnergyStorage(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.getEnergyStored(EnumFacing.DOWN)};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; returns if the turret is currently active.")
    public Object[] getActive(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.isActive()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; toggles turret redstone inversion state.")
    public Object[] setInverted(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.setInverted(args.checkBoolean(0));
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; shows redstone inversion state.")
    public Object[] getInverted(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.getInverted()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; shows redstone state.")
    public Object[] getRedstone(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.getRedstone()};
    }
}

