/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity.turrets;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import omtteam.omlib.tileentity.TileEntityBase;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.entity.projectiles.TurretProjectile;
import omtteam.openmodularturrets.handler.ConfigHandler;
import omtteam.openmodularturrets.init.ModSounds;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.util.TurretHeadUtil;

public abstract class TurretHead
extends TileEntityBase
implements ITickable {
    int ticks;
    int targetingTicks;
    public float rotationXY;
    public float rotationXZ;
    public float baseFitRotationX;
    public float baseFitRotationZ;
    int turretTier;
    public TurretBase base;
    private boolean hasSetSide = false;
    public Entity target = null;
    public float rotationAnimation = 0.0f;
    public boolean shouldConceal = false;
    private boolean playedDeploy = false;
    private int ticksWithoutTarget;
    private double targetLastX = 0.0;
    private double targetLastY = 0.0;
    private double targetLastZ = 0.0;

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_189515_b(var1);
        return new SPacketUpdateTileEntity(this.field_174879_c, 2, var1);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound var1 = pkt.func_148857_g();
        this.func_145839_a(var1);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74776_a("rotationXY", this.rotationXY);
        nbtTagCompound.func_74776_a("rotationXZ", this.rotationXZ);
        nbtTagCompound.func_74768_a("ticksBeforeFire", this.ticks);
        nbtTagCompound.func_74757_a("shouldConceal", this.shouldConceal);
        super.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        this.rotationXY = par1.func_74760_g("rotationXY");
        this.rotationXZ = par1.func_74760_g("rotationXZ");
        this.shouldConceal = par1.func_74767_n("shouldConceal");
    }

    void setSide() {
        if (this.hasSetSide || this.field_145850_b == null) {
            return;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177974_f()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 1.565f;
            this.hasSetSide = true;
            return;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177976_e()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 4.705f;
            this.hasSetSide = true;
            return;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177968_d()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 3.145f;
            this.hasSetSide = true;
            return;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177978_c()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 0.0f;
            this.hasSetSide = true;
            return;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a()) instanceof TurretBase) {
            this.baseFitRotationX = 3.145f;
            this.baseFitRotationZ = 0.0f;
            this.hasSetSide = true;
            return;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b()) instanceof TurretBase) {
            this.baseFitRotationX = 0.0f;
            this.baseFitRotationZ = 0.0f;
            this.hasSetSide = true;
        }
    }

    Entity getTargetWithMinRange() {
        return TurretHeadUtil.getTargetWithMinimumRange(this.base, this.field_145850_b, this.base.getyAxisDetect(), this.field_174879_c, this.getTurretRange() + TurretHeadUtil.getRangeUpgrades(this.base), this);
    }

    Entity getTargetWithoutEffect() {
        return TurretHeadUtil.getTargetWithoutSlowEffect(this.base, this.field_145850_b, this.base.getyAxisDetect(), this.field_174879_c, this.getTurretRange() + TurretHeadUtil.getRangeUpgrades(this.base), this);
    }

    private Entity getTarget() {
        return TurretHeadUtil.getTarget(this.base, this.field_145850_b, this.base.getyAxisDetect(), this.field_174879_c, this.getTurretRange() + TurretHeadUtil.getRangeUpgrades(this.base), this);
    }

    protected abstract int getTurretRange();

    TurretBase getBase() {
        return TurretHeadUtil.getTurretBase(this.field_145850_b, this.field_174879_c);
    }

    public float getRotationXY() {
        return this.rotationXY;
    }

    public void setRotationXY(float rotationXY) {
        this.rotationXY = rotationXY;
    }

    public float getRotationXZ() {
        return this.rotationXZ;
    }

    public void setRotationXZ(float rotationXZ) {
        this.rotationXZ = rotationXZ;
    }

    private float getDistanceToEntity(Entity p_70032_1_) {
        float f = (float)((double)this.func_174877_v().func_177958_n() - p_70032_1_.field_70165_t);
        float f1 = (float)((double)this.func_174877_v().func_177956_o() - p_70032_1_.field_70163_u);
        float f2 = (float)((double)this.func_174877_v().func_177952_p() - p_70032_1_.field_70161_v);
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    protected abstract int getTurretPowerUsage();

    protected abstract int getTurretFireRate();

    protected abstract double getTurretAccuracy();

    protected abstract boolean requiresAmmo();

    protected abstract boolean requiresSpecificAmmo();

    protected abstract ItemStack getAmmo();

    protected abstract TurretProjectile createProjectile(World var1, Entity var2, ItemStack var3);

    protected abstract SoundEvent getLaunchSoundEffect();

    boolean chebyshevDistance(Entity target, TurretBase base) {
        return MathHelper.func_76132_a((double)MathHelper.func_76132_a((double)(target.field_70165_t - (double)this.func_174877_v().func_177958_n()), (double)(target.field_70163_u - (double)this.func_174877_v().func_177956_o())), (double)(target.field_70161_v - (double)this.func_174877_v().func_177952_p())) > (double)(this.getTurretRange() + TurretHeadUtil.getRangeUpgrades(base));
    }

    private int getPowerRequiredForNextShot() {
        return Math.round((float)this.getTurretPowerUsage() * (1.0f - TurretHeadUtil.getEfficiencyUpgrades(this.base)) * (float)(1 + TurretHeadUtil.getScattershotUpgrades(this.base)));
    }

    private void updateRotationAnimation() {
        if (this.rotationAnimation >= 360.0f) {
            this.rotationAnimation = 0.0f;
        }
        this.rotationAnimation += 0.03f;
    }

    public void func_73660_a() {
        this.setSide();
        this.base = this.getBase();
        if (this.field_145850_b.field_72995_K) {
            this.updateRotationAnimation();
            return;
        }
        if (this.ticks % 5 == 0) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
        ++this.ticks;
        if (this.base == null || this.base.getTier() < this.turretTier) {
            this.func_145831_w().func_175655_b(this.field_174879_c, true);
        } else {
            int i;
            EntityPlayerMP entity;
            if (this.base.isAttacksPlayers() && this.base.isActive() && ConfigHandler.globalCanTargetPlayers) {
                TurretHeadUtil.warnPlayers(this.base, this.base.func_145831_w(), this.base.getyAxisDetect(), this.field_174879_c, this.getTurretRange());
            }
            TurretHeadUtil.updateSolarPanelAddon(this.base);
            this.concealmentChecks();
            if (!this.base.isActive()) {
                return;
            }
            if (this.target == null && this.targetingTicks < ConfigHandler.getTurretTargetSearchTicks()) {
                ++this.targetingTicks;
                return;
            }
            this.targetingTicks = 0;
            if (this.base.getEnergyStored(EnumFacing.DOWN) < this.getPowerRequiredForNextShot()) {
                return;
            }
            if (this.target == null || this.target.field_70128_L || this.func_145831_w().func_73045_a(this.target.func_145782_y()) == null || ((EntityLivingBase)this.target).func_110143_aJ() <= 0.0f) {
                this.target = this.getTarget();
                if (this.target == null) {
                    return;
                }
                this.targetLastX = this.target.field_70169_q;
                this.targetLastY = this.target.field_70167_r;
                this.targetLastZ = this.target.field_70166_s;
            }
            this.rotationXZ = TurretHeadUtil.getAimYaw(this.target, this.field_174879_c) + 3.2f;
            this.rotationXY = TurretHeadUtil.getAimPitch(this.target, this.field_174879_c);
            double targetSpeedX = 0.0;
            double targetSpeedY = 0.0;
            double targetSpeedZ = 0.0;
            if (this.target != null && this.target instanceof EntityPlayerMP) {
                targetSpeedX = this.target.field_70165_t - this.targetLastX;
                targetSpeedY = this.target.field_70163_u - this.targetLastY;
                targetSpeedZ = this.target.field_70161_v - this.targetLastZ;
                this.targetLastX = this.target.field_70165_t;
                this.targetLastY = this.target.field_70163_u;
                this.targetLastZ = this.target.field_70161_v;
            }
            if ((float)this.ticks < (float)this.getTurretFireRate() * (1.0f - TurretHeadUtil.getFireRateUpgrades(this.base))) {
                return;
            }
            if (this.target != null && this.target instanceof EntityPlayerMP && (TurretHeadUtil.isTrustedPlayer((entity = (EntityPlayerMP)this.target).func_110124_au(), this.base) || entity.field_71075_bZ.field_75098_d || !this.base.isAttacksPlayers())) {
                this.target = null;
                return;
            }
            if (this.target != null && !TurretHeadUtil.canTurretSeeTarget(this, (EntityLivingBase)this.target)) {
                this.target = null;
                return;
            }
            if (this.target != null && this.chebyshevDistance(this.target, this.base)) {
                this.target = null;
                return;
            }
            ItemStack ammo = null;
            if (this.requiresAmmo()) {
                if (this.requiresSpecificAmmo()) {
                    for (i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
                        ammo = TurretHeadUtil.useSpecificItemStackItemFromBase(this.base, this.getAmmo());
                        if (ammo != null) continue;
                        ammo = TurretHeadUtil.getSpecificItemFromInvExpanders(this.field_145850_b, this.getAmmo(), this.base);
                    }
                } else {
                    for (i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
                        ammo = TurretHeadUtil.useAnyItemStackFromBase(this.base);
                        if (ammo != null) continue;
                        ammo = TurretHeadUtil.getAnyItemFromInvExpanders(this.field_145850_b, this.base);
                    }
                }
                if (ammo == null) {
                    return;
                }
            }
            this.base.setEnergyStored(this.base.getEnergyStored(EnumFacing.DOWN) - this.getPowerRequiredForNextShot());
            for (i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
                TurretProjectile projectile = this.createProjectile(this.func_145831_w(), this.target, ammo);
                projectile.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                Random random = new Random();
                double speedX = this.target instanceof EntityPlayerMP ? targetSpeedX : this.target.field_70165_t - this.target.field_70169_q;
                double speedY = this.target instanceof EntityPlayerMP ? targetSpeedY : this.target.field_70163_u - this.target.field_70167_r;
                double speedZ = this.target instanceof EntityPlayerMP ? targetSpeedZ : this.target.field_70161_v - this.target.field_70166_s;
                double d0 = this.target.field_70165_t - projectile.field_70165_t;
                double d1 = this.target.field_70163_u + (double)this.target.func_70047_e() - projectile.field_70163_u;
                double d2 = this.target.field_70161_v - projectile.field_70161_v;
                double dist = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f1 = (float)dist * (0.2f * (this.getDistanceToEntity(this.target) * 0.04f));
                double accuracy = this.getTurretAccuracy() * (double)(1.0f - TurretHeadUtil.getAccuraccyUpgrades(this.base)) * (double)(1 + TurretHeadUtil.getScattershotUpgrades(this.base));
                double time = dist / (projectile.gravity == 0.0f ? 3.0 : 1.6);
                double adjustedX = d0 + speedX * time;
                double adjustedY = d1 + speedY * time;
                double adjustedZ = d2 + speedZ * time;
                double dist2 = MathHelper.func_76133_a((double)(adjustedX * adjustedX + adjustedY * adjustedY + adjustedZ * adjustedZ));
                float speedFactor = (float)(dist2 / dist);
                if (projectile.gravity == 0.0f) {
                    projectile.func_70186_c(adjustedX, adjustedY, adjustedZ, 3.0f * speedFactor, (float)accuracy);
                } else {
                    projectile.func_70186_c(adjustedX, adjustedY, adjustedZ, 1.6f * speedFactor, (float)accuracy);
                }
                this.field_145850_b.func_184133_a(null, this.field_174879_c, this.getLaunchSoundEffect(), SoundCategory.BLOCKS, ConfigHandler.getTurretSoundVolume(), new Random().nextFloat() + 0.5f);
                this.func_145831_w().func_72838_d((Entity)projectile);
            }
            this.ticks = 0;
        }
    }

    void concealmentChecks() {
        if (this.base != null && this.base.shouldConcealTurrets) {
            if (!this.shouldConceal && this.target == null && this.ticksWithoutTarget >= 40) {
                this.ticksWithoutTarget = 0;
                this.shouldConceal = true;
                this.playedDeploy = false;
                this.field_145850_b.func_184133_a(null, this.field_174879_c, ModSounds.turretRetractSound, SoundCategory.BLOCKS, ConfigHandler.getTurretSoundVolume(), new Random().nextFloat() + 0.5f);
                this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockAbstractTurretHead.CONCEALED, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                ++this.ticksWithoutTarget;
            }
            if (this.base != null && this.target != null) {
                this.ticksWithoutTarget = 0;
                this.shouldConceal = false;
                if (!this.playedDeploy) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, ModSounds.turretDeploySound, SoundCategory.BLOCKS, ConfigHandler.getTurretSoundVolume(), new Random().nextFloat() + 0.5f);
                    this.playedDeploy = true;
                    this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockAbstractTurretHead.CONCEALED, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
        } else {
            this.shouldConceal = false;
            this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockAbstractTurretHead.CONCEALED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }
}

