/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.util;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import omtteam.omlib.util.TrustedPlayer;
import omtteam.omlib.util.WorldUtil;
import omtteam.openmodularturrets.compatability.ModCompatibility;
import omtteam.openmodularturrets.handler.ConfigHandler;
import omtteam.openmodularturrets.init.ModSounds;
import omtteam.openmodularturrets.tileentity.Expander;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;

public class TurretHeadUtil {
    private static final HashSet<EntityPlayerMP> warnedPlayers = new HashSet();

    public static void warnPlayers(TurretBase base, World worldObj, int downLowAmount, BlockPos pos, int turretRange) {
        if (base.isAttacksPlayers()) {
            int warnDistance = ConfigHandler.getTurretWarningDistance();
            AxisAlignedBB axis = new AxisAlignedBB((double)(pos.func_177958_n() - turretRange - warnDistance), (double)(pos.func_177956_o() - downLowAmount - warnDistance), (double)(pos.func_177952_p() - turretRange - warnDistance), (double)(pos.func_177958_n() + turretRange + warnDistance), (double)(pos.func_177956_o() + turretRange + warnDistance), (double)(pos.func_177952_p() + turretRange + warnDistance));
            if (worldObj.func_72820_D() % 2000L == 0L) {
                warnedPlayers.clear();
            }
            List targets = worldObj.func_72872_a(EntityPlayerMP.class, axis);
            for (EntityPlayerMP target : targets) {
                if (target.func_110124_au().toString().equals(base.getOwner()) || TurretHeadUtil.isTrustedPlayer(target.func_110124_au(), base) || warnedPlayers.contains(target) || target.field_71075_bZ.field_75098_d) continue;
                TurretHeadUtil.dispatchWarnMessage(target, worldObj);
                warnedPlayers.add(target);
            }
        }
    }

    private static void dispatchWarnMessage(EntityPlayerMP player, World worldObj) {
        if (ConfigHandler.turretAlarmSound) {
            player.func_184185_a(ModSounds.turretWarnSound, 1.0f, 1.0f);
        }
        if (ConfigHandler.turretWarnMessage) {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + I18n.func_74838_a((String)"status.warning")));
        }
    }

    public static Entity getTarget(TurretBase base, World worldObj, int downLowAmount, BlockPos pos, int turretRange, TurretHead turret) {
        EntityLivingBase target = null;
        if (!worldObj.field_72995_K && base != null && base.getOwner() != null) {
            AxisAlignedBB axis = new AxisAlignedBB((double)(pos.func_177958_n() - turretRange), (double)(pos.func_177956_o() - downLowAmount), (double)(pos.func_177952_p() - turretRange), (double)(pos.func_177958_n() + turretRange), (double)(pos.func_177956_o() + turretRange), (double)(pos.func_177952_p() + turretRange));
            List targets = worldObj.func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase target1 : targets) {
                EntityLivingBase targetELB;
                EntityPlayerMP entity;
                if (base.isAttacksNeutrals() && ConfigHandler.globalCanTargetNeutrals && target1 instanceof EntityAnimal && !target1.field_70128_L) {
                    target = target1;
                }
                if (base.isAttacksNeutrals() && ConfigHandler.globalCanTargetNeutrals && target1 instanceof EntityAmbientCreature && !target1.field_70128_L) {
                    target = target1;
                }
                if (base.isAttacksMobs() && ConfigHandler.globalCanTargetMobs && target1.isCreatureType(EnumCreatureType.MONSTER, false) && !target1.field_70128_L) {
                    target = target1;
                }
                if (base.isAttacksPlayers() && ConfigHandler.globalCanTargetPlayers && target1 instanceof EntityPlayerMP && !target1.field_70128_L && !(entity = (EntityPlayerMP)target1).func_110124_au().toString().equals(base.getOwner()) && !TurretHeadUtil.isTrustedPlayer(entity.func_110124_au(), base) && !entity.field_71075_bZ.field_75098_d) {
                    target = target1;
                }
                if (target == null || turret == null || base.isMultiTargeting() && TurretHeadUtil.isTargetAlreadyTargeted(base, (Entity)target) || !TurretHeadUtil.canTurretSeeTarget(turret, targetELB = target) || !(targetELB.func_110143_aJ() > 0.0f)) continue;
                return target;
            }
        }
        return null;
    }

    public static Entity getTargetWithMinimumRange(TurretBase base, World worldObj, int downLowAmount, BlockPos pos, int turretRange, TurretHead turret) {
        EntityLivingBase target = null;
        if (!worldObj.field_72995_K && base != null && base.getOwner() != null) {
            AxisAlignedBB axis = new AxisAlignedBB((double)(pos.func_177958_n() - turretRange), (double)(pos.func_177956_o() - downLowAmount), (double)(pos.func_177952_p() - turretRange), (double)(pos.func_177958_n() + turretRange), (double)(pos.func_177956_o() + turretRange), (double)(pos.func_177952_p() + turretRange));
            List targets = worldObj.func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase target1 : targets) {
                EntityLivingBase targetELB;
                EntityPlayerMP entity;
                if (base.isAttacksNeutrals() && ConfigHandler.globalCanTargetNeutrals && target1 instanceof EntityAnimal && !target1.field_70128_L && target1.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) >= 3.0) {
                    target = target1;
                }
                if (base.isAttacksNeutrals() && ConfigHandler.globalCanTargetNeutrals && target1 instanceof EntityAmbientCreature && !target1.field_70128_L && target1.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) >= 3.0) {
                    target = target1;
                }
                if (base.isAttacksMobs() && ConfigHandler.globalCanTargetMobs && target1 instanceof IMob && !target1.field_70128_L && target1.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) >= 3.0) {
                    target = target1;
                }
                if (base.isAttacksPlayers() && ConfigHandler.globalCanTargetPlayers && target1 instanceof EntityPlayerMP && !target1.field_70128_L && target1.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) >= 3.0 && !(entity = (EntityPlayerMP)target1).func_110124_au().toString().equals(base.getOwner()) && !TurretHeadUtil.isTrustedPlayer(entity.func_110124_au(), base) && !entity.field_71075_bZ.field_75098_d) {
                    target = target1;
                }
                if (target == null || turret == null || base.isMultiTargeting() && TurretHeadUtil.isTargetAlreadyTargeted(base, target) || !TurretHeadUtil.canTurretSeeTarget(turret, targetELB = (EntityLivingBase)target) || !(targetELB.func_110143_aJ() > 0.0f)) continue;
                return target;
            }
        }
        return null;
    }

    public static Entity getTargetWithoutSlowEffect(TurretBase base, World worldObj, int downLowAmount, BlockPos pos, int turretRange, TurretHead turret) {
        EntityLivingBase target = null;
        if (!worldObj.field_72995_K && base != null && base.getOwner() != null) {
            AxisAlignedBB axis = new AxisAlignedBB((double)(pos.func_177958_n() - turretRange), (double)(pos.func_177956_o() - downLowAmount), (double)(pos.func_177952_p() - turretRange), (double)(pos.func_177958_n() + turretRange), (double)(pos.func_177956_o() + turretRange), (double)(pos.func_177952_p() + turretRange));
            List targets = worldObj.func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase target1 : targets) {
                EntityPlayerMP entity;
                if (base.isAttacksNeutrals() && ConfigHandler.globalCanTargetNeutrals && target1 instanceof EntityAnimal && !target1.field_70128_L && !target1.func_70644_a(Potion.func_188412_a((int)2))) {
                    target = target1;
                }
                if (base.isAttacksNeutrals() && ConfigHandler.globalCanTargetNeutrals && target1 instanceof EntityAmbientCreature && !target1.field_70128_L && !target1.func_70644_a(Potion.func_188412_a((int)2))) {
                    target = target1;
                }
                if (base.isAttacksMobs() && ConfigHandler.globalCanTargetMobs && target1 instanceof IMob && !target1.field_70128_L && !target1.func_70644_a(Potion.func_188412_a((int)2))) {
                    target = target1;
                }
                if (base.isAttacksPlayers() && ConfigHandler.globalCanTargetPlayers && target1 instanceof EntityPlayerMP && !target1.field_70128_L && !target1.func_70644_a(Potion.func_188412_a((int)2)) && !(entity = (EntityPlayerMP)target1).func_110124_au().toString().equals(base.getOwner()) && !TurretHeadUtil.isTrustedPlayer(entity.func_110124_au(), base) && !entity.field_71075_bZ.field_75098_d) {
                    target = target1;
                }
                if (target == null || turret == null) continue;
                EntityLivingBase targetELB = target;
                if (base.isMultiTargeting() && TurretHeadUtil.isTargetAlreadyTargeted(base, (Entity)target) || !TurretHeadUtil.canTurretSeeTarget(turret, targetELB) || !(targetELB.func_110143_aJ() > 0.0f)) continue;
                return target;
            }
        }
        return null;
    }

    private static boolean isTargetAlreadyTargeted(TurretBase base, Entity entity) {
        for (TileEntity tileEntity : WorldUtil.getTouchingTileEntities((World)base.func_145831_w(), (BlockPos)base.func_174877_v())) {
            if (!(tileEntity instanceof TurretHead) || ((TurretHead)tileEntity).target == null || !entity.equals((Object)((TurretHead)tileEntity).target)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTrustedPlayer(UUID uuid, TurretBase base) {
        for (TrustedPlayer trusted_player : base.getTrustedPlayers()) {
            if (!trusted_player.uuid.equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public static int getPowerExpanderTotalExtraCapacity(World world, BlockPos pos) {
        int totalExtraCap = 0;
        for (TileEntity tileEntity : WorldUtil.getTouchingTileEntities((World)world, (BlockPos)pos)) {
            if (!(tileEntity instanceof Expander) || !((Expander)tileEntity).isPowerExpander()) continue;
            totalExtraCap += TurretHeadUtil.getPowerExtenderCapacityValue((Expander)tileEntity);
        }
        return totalExtraCap;
    }

    private static ItemStack deductFromInvExpander(ItemStack itemStack, Expander exp, TurretBase base) {
        for (int i = 0; i < exp.func_70302_i_(); ++i) {
            ItemStack ammoCheck = exp.func_70301_a(i);
            if (ammoCheck == null || ammoCheck.func_77973_b() != itemStack.func_77973_b()) continue;
            if (TurretHeadUtil.hasRecyclerAddon(base)) {
                int chance = new Random().nextInt(99);
                if (chance >= 0 && chance < ConfigHandler.getRecyclerNegateChance()) {
                    return new ItemStack(ammoCheck.func_77973_b());
                }
                if (chance > ConfigHandler.getRecyclerNegateChance() && chance < ConfigHandler.getRecyclerNegateChance() + ConfigHandler.getRecyclerAddChance()) {
                    exp.func_70298_a(i, -1);
                    return new ItemStack(ammoCheck.func_77973_b());
                }
                exp.func_70298_a(i, 1);
                return new ItemStack(ammoCheck.func_77973_b());
            }
            exp.func_70298_a(i, 1);
            return new ItemStack(ammoCheck.func_77973_b());
        }
        return null;
    }

    public static ItemStack getSpecificItemFromInvExpanders(World world, ItemStack itemStack, TurretBase base) {
        for (TileEntity tileEntity : WorldUtil.getTouchingTileEntities((World)world, (BlockPos)base.func_174877_v())) {
            Expander exp;
            ItemStack stack;
            if (!(tileEntity instanceof Expander) || ((Expander)tileEntity).isPowerExpander() || (stack = TurretHeadUtil.deductFromInvExpander(itemStack, exp = (Expander)tileEntity, base)) == null) continue;
            return stack;
        }
        return null;
    }

    public static ItemStack getAnyItemFromInvExpanders(World world, TurretBase base) {
        for (TileEntity tileEntity : WorldUtil.getTouchingTileEntities((World)world, (BlockPos)base.func_174877_v())) {
            if (!(tileEntity instanceof Expander) || ((Expander)tileEntity).isPowerExpander()) continue;
            Expander exp = (Expander)tileEntity;
            for (int i = 0; i < exp.func_70302_i_(); ++i) {
                ItemStack itemCheck = exp.func_70301_a(i);
                if (itemCheck == null) continue;
                exp.func_70298_a(i, 1);
                return new ItemStack(itemCheck.func_77973_b());
            }
        }
        return null;
    }

    private static int getPowerExtenderCapacityValue(Expander expander) {
        if (expander != null) {
            if (!expander.isPowerExpander()) {
                return 0;
            }
            int tier = expander.getTier();
            switch (tier) {
                case 1: {
                    return ConfigHandler.getExpanderPowerTierOneCapacity();
                }
                case 2: {
                    return ConfigHandler.getExpanderPowerTierTwoCapacity();
                }
                case 3: {
                    return ConfigHandler.getExpanderPowerTierThreeCapacity();
                }
                case 4: {
                    return ConfigHandler.getExpanderPowerTierFourCapacity();
                }
                case 5: {
                    return ConfigHandler.getExpanderPowerTierFiveCapacity();
                }
            }
            return 0;
        }
        return 0;
    }

    public static TurretBase getTurretBase(World world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            if (!(world.func_175625_s(offsetPos) instanceof TurretBase)) continue;
            return (TurretBase)world.func_175625_s(offsetPos);
        }
        return null;
    }

    public static float getAimYaw(Entity target, BlockPos pos) {
        double dX = target.field_70165_t - (double)pos.func_177958_n();
        double dZ = target.field_70161_v - (double)pos.func_177952_p();
        float yaw = (float)Math.atan2(dZ, dX);
        yaw = yaw - 1.570796f + 3.1f;
        return yaw;
    }

    public static float getAimPitch(Entity target, BlockPos pos) {
        double dX = target.field_70165_t - (double)0.2f - (double)((float)pos.func_177958_n() + 0.6f);
        double dY = target.field_70163_u + (double)0.6f - (double)((float)pos.func_177956_o() - 0.6f);
        double dZ = target.field_70161_v - (double)0.2f - (double)((float)pos.func_177952_p() + 0.6f);
        float pitch = (float)(Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI);
        return pitch += 1.65f;
    }

    public static ItemStack useAnyItemStackFromBase(TurretBase base) {
        for (int i = 0; i <= 8; ++i) {
            ItemStack ammoCheck = base.func_70301_a(i);
            if (ammoCheck == null || ammoCheck.field_77994_a <= 0) continue;
            base.func_70298_a(i, 1);
            return new ItemStack(ammoCheck.func_77973_b());
        }
        return null;
    }

    public static ItemStack useSpecificItemStackBlockFromBase(TurretBase base, ItemStack stack) {
        for (int i = 0; i <= 8; ++i) {
            ItemStack ammo_stack = base.func_70301_a(i);
            if (ammo_stack == null || ammo_stack.field_77994_a <= 0 || ammo_stack.func_77973_b() != stack.func_77973_b()) continue;
            base.func_70298_a(i, 1);
            return new ItemStack(ammo_stack.func_77973_b());
        }
        return null;
    }

    public static ItemStack useSpecificItemStackItemFromBase(TurretBase base, ItemStack ammoStackRequired) {
        for (int i = 0; i <= 8; ++i) {
            ItemStack ammo_stack = base.func_70301_a(i);
            if (ammo_stack == null || ammo_stack.field_77994_a <= 0 || ammo_stack.func_77973_b() != ammoStackRequired.func_77973_b() || ammo_stack.func_77960_j() != ammoStackRequired.func_77960_j()) continue;
            if (TurretHeadUtil.hasRecyclerAddon(base)) {
                int chance = new Random().nextInt(99);
                if (chance > 0 && chance < ConfigHandler.getRecyclerNegateChance()) {
                    return new ItemStack(ammo_stack.func_77973_b());
                }
                if (chance > ConfigHandler.getRecyclerNegateChance() && chance < ConfigHandler.getRecyclerNegateChance() + ConfigHandler.getRecyclerAddChance()) {
                    base.func_70298_a(i, -1);
                    return new ItemStack(ammo_stack.func_77973_b());
                }
                base.func_70298_a(i, 1);
                return new ItemStack(ammo_stack.func_77973_b());
            }
            base.func_70298_a(i, 1);
            return new ItemStack(ammo_stack.func_77973_b());
        }
        return null;
    }

    public static int getRangeUpgrades(TurretBase base) {
        int value = 0;
        int tier = base.getTier();
        if (tier == 1) {
            return value;
        }
        if (tier == 5 && base.func_70301_a(12) != null && base.func_70301_a(12).func_77952_i() == 3) {
            value += ConfigHandler.getRangeUpgradeBoost() * base.func_70301_a((int)12).field_77994_a;
        }
        if (base.func_70301_a(11) != null && base.func_70301_a(11).func_77952_i() == 3) {
            value += ConfigHandler.getRangeUpgradeBoost() * base.func_70301_a((int)11).field_77994_a;
        }
        return value;
    }

    public static int getScattershotUpgrades(TurretBase base) {
        int value = 0;
        int tier = base.getTier();
        if (tier == 1) {
            return value;
        }
        if (tier == 5 && base.func_70301_a(12) != null && base.func_70301_a(12).func_77952_i() == 4) {
            value += base.func_70301_a((int)12).field_77994_a;
        }
        if (base.func_70301_a(11) != null && base.func_70301_a(11).func_77952_i() == 4) {
            value += base.func_70301_a((int)11).field_77994_a;
        }
        return value;
    }

    public static float getAccuraccyUpgrades(TurretBase base) {
        float accuracy = 0.0f;
        int tier = base.getTier();
        if (tier == 1) {
            return accuracy;
        }
        if (tier == 5 && base.func_70301_a(12) != null && base.func_70301_a(12).func_77952_i() == 0) {
            accuracy = (float)((double)accuracy + ConfigHandler.getAccuracyUpgradeBoost() * (double)base.func_70301_a((int)12).field_77994_a);
        }
        if (base.func_70301_a(11) != null && base.func_70301_a(11).func_77952_i() == 0) {
            accuracy = (float)((double)accuracy + ConfigHandler.getAccuracyUpgradeBoost() * (double)base.func_70301_a((int)11).field_77994_a);
        }
        return accuracy;
    }

    public static float getEfficiencyUpgrades(TurretBase base) {
        float efficiency = 0.0f;
        int tier = base.getTier();
        if (tier == 1) {
            return efficiency;
        }
        if (tier == 5 && base.func_70301_a(12) != null && base.func_70301_a(12).func_77952_i() == 1) {
            efficiency = (float)((double)efficiency + ConfigHandler.getEfficiencyUpgradeBoostPercentage() * (double)base.func_70301_a((int)12).field_77994_a);
        }
        if (base.func_70301_a(11) != null && base.func_70301_a(11).func_77952_i() == 1) {
            efficiency = (float)((double)efficiency + ConfigHandler.getEfficiencyUpgradeBoostPercentage() * (double)base.func_70301_a((int)11).field_77994_a);
        }
        return efficiency;
    }

    public static float getFireRateUpgrades(TurretBase base) {
        float rof = 0.0f;
        int tier = base.getTier();
        if (tier == 1) {
            return rof;
        }
        if (tier == 5 && base.func_70301_a(12) != null && base.func_70301_a(12).func_77952_i() == 2) {
            rof = (float)((double)rof + ConfigHandler.getFireRateUpgradeBoostPercentage() * (double)base.func_70301_a((int)12).field_77994_a);
        }
        if (base.func_70301_a(11) != null && base.func_70301_a(11).func_77952_i() == 2) {
            rof = (float)((double)rof + ConfigHandler.getFireRateUpgradeBoostPercentage() * (double)base.func_70301_a((int)11).field_77994_a);
        }
        return rof;
    }

    public static boolean hasRedstoneReactor(TurretBase base) {
        boolean found = false;
        if (base.getTier() == 1) {
            return false;
        }
        if (base.func_70301_a(9) != null) {
            boolean bl = found = base.func_70301_a(9).func_77952_i() == 4;
        }
        if (base.func_70301_a(10) != null && !found) {
            found = base.func_70301_a(10).func_77952_i() == 4;
        }
        return found;
    }

    public static boolean hasDamageAmpAddon(TurretBase base) {
        boolean found = false;
        if (base.getTier() == 1) {
            return false;
        }
        if (base.func_70301_a(9) != null) {
            boolean bl = found = base.func_70301_a(9).func_77952_i() == 1;
        }
        if (base.func_70301_a(10) != null && !found) {
            found = base.func_70301_a(10).func_77952_i() == 1;
        }
        return found;
    }

    public static boolean hasConcealmentAddon(TurretBase base) {
        boolean found = false;
        if (base.getTier() == 1) {
            return false;
        }
        if (base.func_70301_a(9) != null) {
            boolean bl = found = base.func_70301_a(9).func_77952_i() == 0;
        }
        if (base.func_70301_a(10) != null && !found) {
            found = base.func_70301_a(10).func_77952_i() == 0;
        }
        return found;
    }

    public static boolean hasSolarPanelAddon(TurretBase base) {
        boolean found = false;
        if (base.getTier() == 1) {
            return false;
        }
        if (base.func_70301_a(9) != null) {
            boolean bl = found = base.func_70301_a(9).func_77952_i() == 6;
        }
        if (base.func_70301_a(10) != null && !found) {
            found = base.func_70301_a(10).func_77952_i() == 6;
        }
        return found;
    }

    public static boolean hasPotentiaUpgradeAddon(TurretBase base) {
        boolean found = false;
        if (base.getTier() == 1) {
            return false;
        }
        if (!ModCompatibility.ThaumcraftLoaded) {
            return false;
        }
        if (base.func_70301_a(9) != null) {
            boolean bl = found = base.func_70301_a(9).func_77952_i() == 2;
        }
        if (base.func_70301_a(10) != null && !found) {
            found = base.func_70301_a(10).func_77952_i() == 2;
        }
        return found;
    }

    public static boolean hasSerialPortAddon(TurretBase base) {
        boolean found = false;
        if (base.getTier() == 1) {
            return false;
        }
        if (!ModCompatibility.OpenComputersLoaded && !ModCompatibility.ComputerCraftLoaded) {
            return false;
        }
        if (base.func_70301_a(9) != null) {
            boolean bl = found = base.func_70301_a(9).func_77952_i() == 5;
        }
        if (base.func_70301_a(10) != null && !found) {
            found = base.func_70301_a(10).func_77952_i() == 5;
        }
        return found;
    }

    private static boolean hasRecyclerAddon(TurretBase base) {
        boolean found = false;
        if (base.getTier() == 1) {
            return false;
        }
        if (base.func_70301_a(9) != null) {
            boolean bl = found = base.func_70301_a(9).func_77952_i() == 3;
        }
        if (base.func_70301_a(10) != null && !found) {
            found = base.func_70301_a(10).func_77952_i() == 3;
        }
        return found;
    }

    public static int getAmpLevel(TurretBase base) {
        int amp_level = 0;
        if (base == null) {
            return amp_level;
        }
        int tier = base.getTier();
        if (tier == 1) {
            return amp_level;
        }
        if (base.func_70301_a(9) != null && base.func_70301_a(9).func_77952_i() == 1) {
            amp_level += base.func_70301_a((int)10).field_77994_a;
        }
        if (base.func_70301_a(10) != null && base.func_70301_a(10).func_77952_i() == 1) {
            amp_level += base.func_70301_a((int)9).field_77994_a;
        }
        return amp_level;
    }

    public static void updateSolarPanelAddon(TurretBase base) {
        if (!TurretHeadUtil.hasSolarPanelAddon(base)) {
            return;
        }
        if (base.func_145831_w().func_72935_r() && !base.func_145831_w().func_72896_J() && base.func_145831_w().func_175710_j(base.func_174877_v().func_177981_b(2))) {
            base.receiveEnergy(EnumFacing.DOWN, ConfigHandler.getSolarPanelAddonGen(), false);
        }
    }

    public static boolean canTurretSeeTarget(TurretHead turret, EntityLivingBase target) {
        Vec3d traceStart = new Vec3d((double)((float)turret.func_174877_v().func_177958_n() + 0.5f), (double)((float)turret.func_174877_v().func_177956_o() + 0.5f), (double)((float)turret.func_174877_v().func_177952_p() + 0.5f));
        Vec3d traceEnd = new Vec3d(target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v);
        Vec3d vecDelta = new Vec3d(traceEnd.field_72450_a - traceStart.field_72450_a, traceEnd.field_72448_b - traceStart.field_72448_b, traceEnd.field_72449_c - traceStart.field_72449_c);
        vecDelta = vecDelta.func_72432_b();
        for (int i = 0; i < 10; ++i) {
            RayTraceResult traced;
            block4: {
                block3: {
                    traceStart = traceStart.func_178787_e(vecDelta);
                    traced = turret.func_145831_w().func_72933_a(traceStart, traceEnd);
                    if (traced == null || traced.field_72313_a != RayTraceResult.Type.BLOCK) break block3;
                    IBlockState hitBlock = turret.func_145831_w().func_180495_p(traced.func_178782_a());
                    if (traced.func_178782_a().equals((Object)turret.func_174877_v()) || !hitBlock.func_185904_a().func_76220_a() && MathHelper.func_76132_a((double)MathHelper.func_76132_a((double)(traceStart.field_72450_a - traceEnd.field_72450_a), (double)(traceStart.field_72448_b - traceEnd.field_72448_b)), (double)(traceStart.field_72449_c - traceEnd.field_72449_c)) > 1.0) break block4;
                }
                EntityLivingBase targeted = traced == null ? target : null;
                return targeted != null && targeted.equals((Object)target);
            }
            traceStart = traced.field_72307_f;
        }
        return false;
    }
}

