/*
 * Decompiled with CFR 0.152.
 */
package com.gibraltar.iberia.challenge;

import com.gibraltar.iberia.challenge.Challenge;
import com.gibraltar.iberia.renderer.RenderArmorStandFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiHopper;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiBeacon;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiScreenHorseInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ArmorSlowsCraftingChallenge
extends Challenge {
    private long timeGuiOpened;
    private long armorDelayMs;
    private int leatherDelay;
    private int ironDelay;
    private int chainDelay;
    private int goldDelay;
    private int diamondDelay;
    private boolean quickArmorSwapEnabled;
    private final EntityEquipmentSlot[] slotsToSwap = new EntityEquipmentSlot[5];

    public ArmorSlowsCraftingChallenge() {
        this.slotsToSwap[0] = EntityEquipmentSlot.OFFHAND;
        this.slotsToSwap[1] = EntityEquipmentSlot.HEAD;
        this.slotsToSwap[2] = EntityEquipmentSlot.CHEST;
        this.slotsToSwap[3] = EntityEquipmentSlot.LEGS;
        this.slotsToSwap[4] = EntityEquipmentSlot.FEET;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        if (this.quickArmorSwapEnabled && event.getSide() == Side.CLIENT) {
            RenderingRegistry.registerEntityRenderingHandler(EntityArmorStand.class, (IRenderFactory)new RenderArmorStandFactory());
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public void loadConfig(Configuration config) {
        super.loadConfig(config);
        Property prop = config.get(this.name, "LeatherDelay", 0);
        this.leatherDelay = prop.getInt(0);
        prop = config.get(this.name, "IronDelay", 600);
        this.ironDelay = prop.getInt(600);
        prop = config.get(this.name, "ChainDelay", 400);
        this.chainDelay = prop.getInt(600);
        prop = config.get(this.name, "GoldDelay", 200);
        this.goldDelay = prop.getInt(200);
        prop = config.get(this.name, "DiamondDelay", 1200);
        this.diamondDelay = prop.getInt(1200);
        prop = config.get(this.name, "QuickArmorSwap", true);
        this.quickArmorSwapEnabled = prop.getBoolean(true);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!this.isSlowGui(event.getGui())) {
            return;
        }
        this.timeGuiOpened = Minecraft.func_71386_F();
        Iterable armorInventory = Minecraft.func_71410_x().field_71439_g.func_184193_aE();
        this.armorDelayMs = 0L;
        for (Object item : armorInventory) {
            ItemStack stack = (ItemStack)item;
            if (stack == null || !(stack.func_77973_b() instanceof ItemArmor)) continue;
            ItemArmor armor = (ItemArmor)stack.func_77973_b();
            switch (armor.func_82812_d()) {
                case LEATHER: {
                    this.armorDelayMs += (long)this.leatherDelay;
                    break;
                }
                case IRON: {
                    this.armorDelayMs += (long)this.ironDelay;
                    break;
                }
                case CHAIN: {
                    this.armorDelayMs += (long)this.chainDelay;
                    break;
                }
                case GOLD: {
                    this.armorDelayMs += (long)this.goldDelay;
                    break;
                }
                case DIAMOND: {
                    this.armorDelayMs += (long)this.diamondDelay;
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!this.isSlowGui(event.getGui())) {
            return;
        }
        if (this.timeGuiOpened + this.armorDelayMs <= Minecraft.func_71386_F()) {
            return;
        }
        double visibility = (double)(Minecraft.func_71386_F() - this.timeGuiOpened) / (double)this.armorDelayMs;
        int alpha = (int)Math.round(64.0 - visibility * 64.0);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        int guiWidth = event.getGui().field_146294_l;
        int guiHeight = event.getGui().field_146295_m;
        int guiDrawnHeight = this.guiDrawnHeight((GuiContainer)event.getGui());
        int guiDrawnWidth = this.guiDrawnWidth(event.getGui());
        int guiLeft = (guiWidth - guiDrawnWidth) / 2;
        int guiTop = (guiHeight - guiDrawnHeight) / 2;
        this.draw(vertexbuffer, guiLeft, guiTop, guiDrawnWidth, guiDrawnHeight, 255, 255, 255, 128);
        int guiProgressLeft = guiLeft + (guiDrawnWidth - 16) / 2;
        int guiProgressTop = guiTop + (guiDrawnHeight - 86);
        this.draw(vertexbuffer, guiProgressLeft, guiProgressTop, 16, 2, 0, 0, 0, 128);
        this.draw(vertexbuffer, guiProgressLeft, guiProgressTop, (int)Math.round(16.0 * visibility), 2, 255, 255, 255, 255);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMouseInput(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!this.isSlowGui(event.getGui())) {
            return;
        }
        if (this.timeGuiOpened + this.armorDelayMs > Minecraft.func_71386_F()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyboardInput(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (!this.isSlowGui(event.getGui())) {
            return;
        }
        if (this.timeGuiOpened + this.armorDelayMs > Minecraft.func_71386_F() && Keyboard.getEventKey() != 1) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isSlowGui(GuiScreen gui) {
        return gui instanceof GuiContainer && !(gui instanceof InventoryEffectRenderer) && !(gui instanceof GuiMerchant) && !(gui instanceof GuiScreenHorseInventory) && !gui.field_146297_k.field_71439_g.func_184812_l_();
    }

    @SideOnly(value=Side.CLIENT)
    private int guiDrawnHeight(GuiContainer gui) {
        if (gui instanceof GuiHopper) {
            return 133;
        }
        if (gui instanceof GuiBeacon) {
            return 219;
        }
        if (gui instanceof GuiChest && ((ContainerChest)gui.field_147002_h).func_85151_d().func_70302_i_() / 9 > 3) {
            return 222;
        }
        return 166;
    }

    @SideOnly(value=Side.CLIENT)
    private int guiDrawnWidth(GuiScreen gui) {
        if (gui instanceof GuiBeacon) {
            return 230;
        }
        return 176;
    }

    @SideOnly(value=Side.CLIENT)
    private void draw(VertexBuffer renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!this.quickArmorSwapEnabled || event.getTarget().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityPlayer().func_175149_v() || event.getEntityPlayer().func_184812_l_()) {
            return;
        }
        if (!(event.getTarget() instanceof EntityArmorStand)) {
            return;
        }
        EntityArmorStand armorStand = (EntityArmorStand)event.getTarget();
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            event.setCanceled(true);
            EntityPlayer player = event.getEntityPlayer();
            for (EntityEquipmentSlot slot : this.slotsToSwap) {
                ItemStack playerItem = player.func_184582_a(slot);
                ItemStack armorStandItem = armorStand.func_184582_a(slot);
                player.func_184201_a(slot, armorStandItem);
                armorStand.func_184201_a(slot, playerItem);
            }
        } else {
            boolean isSmall = armorStand.func_175410_n();
            Vec3d vec = event.getLocalPos();
            double d4 = isSmall ? vec.field_72448_b * 2.0 : vec.field_72448_b;
            ItemStack stack = event.getItemStack();
            if (stack == null || !(stack.func_77973_b() instanceof ItemElytra) || event.getHand() != EnumHand.MAIN_HAND) {
                return;
            }
            double d = isSmall ? 0.3 : 0.0;
            if (d4 >= 0.9 + d) {
                double d2 = isSmall ? 1.0 : 0.7;
                if (d4 < 0.9 + d2) {
                    if (armorStand.func_184582_a(EntityEquipmentSlot.CHEST) != null) {
                        return;
                    }
                    event.setCanceled(true);
                    armorStand.func_184201_a(EntityEquipmentSlot.CHEST, stack);
                    event.getEntityPlayer().func_184201_a(EntityEquipmentSlot.MAINHAND, null);
                }
            }
        }
    }
}

