/*
 * Decompiled with CFR 0.152.
 */
package com.gibraltar.iberia.challenge;

import com.gibraltar.iberia.challenge.Challenge;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class DeathWithConsequencesChallenge
extends Challenge {
    private int distanceToNewSpawnHard = 1500;
    private int distanceToNewSpawnNormal = 1000;
    private int distanceToNewSpawnEasy = 500;

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public void loadConfig(Configuration config) {
        super.loadConfig(config);
        Property prop = config.get(this.name, "distanceToNewSpawnHard", 1500);
        this.distanceToNewSpawnHard = prop.getInt(1500);
        prop = config.get(this.name, "distanceToNewSpawnNormal", 1000);
        this.distanceToNewSpawnNormal = prop.getInt(1000);
        prop = config.get(this.name, "distanceToNewSpawnEasy", 500);
        this.distanceToNewSpawnEasy = prop.getInt(500);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        GameRules rules = event.getWorld().func_82736_K();
        rules.func_82764_b("keepInventory", "false");
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
            if (player.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                return;
            }
            WorldProvider world = player.field_70170_p.field_73011_w;
            BlockPos playerPos = new BlockPos((Entity)player);
            BlockPos spawnPoint = world.getSpawnPoint();
            if (!world.func_76569_d()) {
                world = DimensionManager.getProvider((int)world.getRespawnDimension(player));
                playerPos = spawnPoint = world.getSpawnPoint();
            }
            player.setSpawnChunk(null, false, world.getRespawnDimension(player));
            if (spawnPoint.func_177958_n() - playerPos.func_177958_n() == 0) {
                playerPos = playerPos.func_177976_e();
            }
            double angle = Math.atan((double)(playerPos.func_177952_p() - spawnPoint.func_177952_p()) / (double)(playerPos.func_177958_n() - spawnPoint.func_177958_n()));
            if (spawnPoint.func_177958_n() - playerPos.func_177958_n() < 0) {
                angle = Math.PI - angle;
            }
            Random random = new Random((int)((angle += Math.PI) * 180.0 / Math.PI));
            angle += (random.nextDouble() - 0.5) * Math.PI;
            int distanceToNewSpawn = 0;
            switch (player.field_70170_p.func_175659_aa()) {
                case HARD: {
                    distanceToNewSpawn = this.distanceToNewSpawnHard;
                    break;
                }
                case NORMAL: {
                    distanceToNewSpawn = this.distanceToNewSpawnNormal;
                    break;
                }
                case EASY: {
                    distanceToNewSpawn = this.distanceToNewSpawnEasy;
                }
            }
            BlockPos newSpawn = spawnPoint.func_177985_f((int)(Math.cos(angle) * (double)distanceToNewSpawn));
            newSpawn = newSpawn.func_177964_d((int)(Math.sin(angle) * (double)distanceToNewSpawn));
            newSpawn = this.findSpawnPointNear(newSpawn, world);
            world.setSpawnPoint(newSpawn);
        }
    }

    private BlockPos findSpawnPointNear(BlockPos position, WorldProvider world) {
        BiomeProvider biomeprovider = world.func_177499_m();
        List list = biomeprovider.func_76932_a();
        Random random = new Random(world.getSeed());
        BlockPos blockpos = biomeprovider.func_180630_a(position.func_177958_n(), position.func_177952_p(), 256, list, random);
        int i = position.func_177958_n();
        int j = world.func_76557_i();
        int k = position.func_177952_p();
        if (blockpos != null) {
            i = blockpos.func_177958_n();
            k = blockpos.func_177952_p();
        } else {
            System.out.println("Unable to find spawn biome");
        }
        int l = 0;
        while (!world.func_76566_a(i, k)) {
            i += random.nextInt(64) - random.nextInt(64);
            k += random.nextInt(64) - random.nextInt(64);
            if (++l != 1000) continue;
        }
        return new BlockPos(i, j, k);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        MinecraftServer server = event.player.func_184102_h();
        this.setAllWorldTimes(server, 0);
    }

    private void setAllWorldTimes(MinecraftServer server, int time) {
        for (int i = 0; i < server.field_71305_c.length; ++i) {
            server.field_71305_c[i].func_72877_b((long)time);
        }
    }
}

