/*
 * Decompiled with CFR 0.152.
 */
package com.gibraltar.iberia.challenge;

import com.gibraltar.iberia.blocks.BlockHardStone;
import com.gibraltar.iberia.challenge.Challenge;
import com.gibraltar.iberia.world.HardStoneGenerator;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class HardStoneChallenge
extends Challenge {
    public static Block hard_stone;
    Map<String, Float> slowdowns;
    protected int updateLCG = new Random().nextInt();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        hard_stone = new BlockHardStone();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new HardStoneGenerator(), (int)0);
    }

    @Override
    public void loadConfig(Configuration config) {
        super.loadConfig(config);
        Property prop = config.get(this.name, "WoodSlowdown", 10.0);
        prop = config.get(this.name, "StoneSlowdown", 10.0);
        prop = config.get(this.name, "IronSlowdown", 10.0);
        prop = config.get(this.name, "GoldSlowdown", 1.0);
        prop = config.get(this.name, "DiamondSlowdown", 2.0);
        this.slowdowns = new TreeMap<String, Float>();
        ConfigCategory category = config.getCategory(this.name);
        for (Map.Entry entry : category.getValues().entrySet()) {
            String key = ((String)entry.getKey()).trim().toLowerCase();
            if (!key.endsWith("slowdown")) continue;
            key = key.substring(0, key.length() - 8);
            this.slowdowns.put(key, Float.valueOf((float)((Property)entry.getValue()).getDouble(10.0)));
        }
    }

    @Override
    protected boolean hasSubscriptions() {
        return true;
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getState().func_177230_c() != hard_stone) {
            return;
        }
        ItemStack heldItemStack = event.getEntityPlayer().func_184614_ca();
        if (heldItemStack == null || !(heldItemStack.func_77973_b() instanceof ItemPickaxe)) {
            return;
        }
        ItemPickaxe pickaxe = (ItemPickaxe)heldItemStack.func_77973_b();
        String material = pickaxe.func_150913_i().toString().toLowerCase();
        float slowdown = 10.0f;
        if (this.slowdowns.containsKey(material)) {
            slowdown = this.slowdowns.get(material).floatValue();
        } else {
            FMLLog.info((String)"[Iberia] New pickaxe type: %s", (Object[])new Object[]{pickaxe.func_150913_i()});
        }
        event.setNewSpeed(event.getOriginalSpeed() / slowdown);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.side == Side.CLIENT) {
            return;
        }
        int i = event.world.func_82736_K().func_180263_c("randomTickSpeed");
        if (i > 0) {
            Iterator chunkIterator = ((WorldServer)event.world).func_184164_w().func_187300_b();
            Iterator iterator = ForgeChunkManager.getPersistentChunksIterableFor((World)event.world, (Iterator)chunkIterator);
            while (iterator.hasNext()) {
                Chunk chunk = (Chunk)iterator.next();
                int j = chunk.field_76635_g * 16;
                int k = chunk.field_76647_h * 16;
                for (ExtendedBlockStorage extendedblockstorage : chunk.func_76587_i()) {
                    if (extendedblockstorage == Chunk.field_186036_a || extendedblockstorage.func_76663_a()) continue;
                    for (int i1 = 0; i1 < i; ++i1) {
                        BlockPos pos;
                        boolean shouldBeHard;
                        boolean hard;
                        this.updateLCG = this.updateLCG * 3 + 1013904223;
                        int j1 = this.updateLCG >> 2;
                        int k1 = j1 & 0xF;
                        int i2 = j1 >> 16 & 0xF;
                        int l1 = j1 >> 8 & 0xF;
                        IBlockState iblockstate = extendedblockstorage.func_177485_a(k1, i2, l1);
                        Block block = iblockstate.func_177230_c();
                        if (block != Blocks.field_150348_b && block != hard_stone || (hard = block == hard_stone) == (shouldBeHard = BlockHardStone.isSurroundedByCompressingBlocks(event.world, pos = new BlockPos(k1 + j, i2 + extendedblockstorage.func_76662_d(), l1 + k), false))) continue;
                        Block newBlock = shouldBeHard ? hard_stone : Blocks.field_150348_b;
                        event.world.func_180501_a(pos, newBlock.func_176203_a(block.func_176201_c(iblockstate)), 6);
                        if (shouldBeHard) continue;
                        event.world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187540_ab, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
        }
    }
}

