/*
 * Decompiled with CFR 0.152.
 */
package com.gibraltar.iberia.proxy;

import com.gibraltar.iberia.challenge.ArmorSlowsCraftingChallenge;
import com.gibraltar.iberia.challenge.Challenge;
import com.gibraltar.iberia.challenge.DeathWithConsequencesChallenge;
import com.gibraltar.iberia.challenge.FindYourWayChallenge;
import com.gibraltar.iberia.challenge.HardStoneChallenge;
import com.gibraltar.iberia.challenge.SleepToHealChallenge;
import java.io.File;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class CommonProxy {
    public static Configuration config;
    public static File configFile;
    private ArrayList challenges;

    public void preInit(FMLPreInitializationEvent event) {
        configFile = event.getSuggestedConfigurationFile();
        System.out.println(configFile);
        config = new Configuration(configFile);
        config.load();
        this.challenges = new ArrayList();
        this.challenges.add(new HardStoneChallenge());
        this.challenges.add(new SleepToHealChallenge());
        this.challenges.add(new ArmorSlowsCraftingChallenge());
        this.challenges.add(new FindYourWayChallenge());
        this.challenges.add(new DeathWithConsequencesChallenge());
        this.forEachChallenge(challenge -> challenge.loadConfig(config));
        if (config.hasChanged()) {
            config.save();
        }
        this.forEachChallenge(challenge -> {
            if (challenge.enabled) {
                challenge.preInit(event);
            }
        });
        config.save();
    }

    public void init(FMLInitializationEvent event) {
        this.forEachChallenge(challenge -> {
            if (challenge.enabled) {
                challenge.init(event);
            }
        });
    }

    private void forEachChallenge(Consumer<Challenge> action) {
        this.challenges.forEach(action);
    }
}

