/*
 * Decompiled with CFR 0.152.
 */
package lumien.bloodmoon.server;

import lumien.bloodmoon.config.BloodmoonConfig;
import lumien.bloodmoon.network.PacketHandler;
import lumien.bloodmoon.network.messages.MessageBloodmoonStatus;
import lumien.bloodmoon.server.BloodmoonSpawner;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BloodmoonHandler
extends WorldSavedData {
    public static BloodmoonHandler INSTANCE;
    private BloodmoonSpawner bloodMoonSpawner = new BloodmoonSpawner();
    boolean bloodMoon = false;
    boolean forceBloodMoon = false;
    int nightCounter;

    public BloodmoonHandler() {
        super("Bloodmoon");
    }

    public BloodmoonHandler(String name) {
        super("Bloodmoon");
    }

    public void playerJoinedWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayer && this.bloodMoon) {
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageBloodmoonStatus(this.bloodMoon), (EntityPlayerMP)event.getEntity());
        }
    }

    public void endWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            World world = event.world;
            if (world.field_73011_w.getDimension() == 0) {
                int time = (int)(world.func_72820_D() % 24000L);
                if (this.isBloodmoonActive()) {
                    if (!BloodmoonConfig.RESPECT_GAMERULE || world.func_82736_K().func_82766_b("doMobSpawning")) {
                        for (int i = 0; i < BloodmoonConfig.SPAWN_SPEED; ++i) {
                            this.bloodMoonSpawner.findChunksForSpawning((WorldServer)world, world.func_175659_aa() != EnumDifficulty.PEACEFUL, false, false);
                        }
                    }
                    if (time >= 0 && time < 12000) {
                        this.setBloodmoon(false);
                    }
                } else if (time == 12000) {
                    if (BloodmoonConfig.NTH_NIGHT != 0) {
                        --this.nightCounter;
                        if (this.nightCounter < 0) {
                            this.nightCounter = BloodmoonConfig.NTH_NIGHT;
                        }
                        this.func_76185_a();
                    }
                    if (this.forceBloodMoon || Math.random() < BloodmoonConfig.CHANCE || BloodmoonConfig.FULLMOON && world.func_72853_d() == 0 || BloodmoonConfig.NTH_NIGHT != 0 && this.nightCounter == 0) {
                        this.forceBloodMoon = false;
                        this.setBloodmoon(true);
                        if (BloodmoonConfig.SEND_MESSAGE) {
                            for (Object object : world.field_73010_i) {
                                EntityPlayer player = (EntityPlayer)object;
                                player.func_145747_a(new TextComponentTranslation("text.bloodmoon.notify", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                            }
                        }
                        if (this.nightCounter == 0 && BloodmoonConfig.NTH_NIGHT != 0) {
                            this.nightCounter = BloodmoonConfig.NTH_NIGHT;
                            this.func_76185_a();
                        }
                    }
                }
            }
        }
    }

    private void setBloodmoon(boolean bloodMoon) {
        if (this.bloodMoon != bloodMoon) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new MessageBloodmoonStatus(bloodMoon), 0);
            this.func_76185_a();
        }
        this.bloodMoon = bloodMoon;
    }

    public void updateClients() {
        PacketHandler.INSTANCE.sendToDimension((IMessage)new MessageBloodmoonStatus(this.bloodMoon), 0);
    }

    public void force() {
        this.forceBloodMoon = true;
        this.func_76185_a();
    }

    public boolean isBloodmoonActive() {
        return this.bloodMoon;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.bloodMoon = nbt.func_74767_n("bloodMoon");
        this.forceBloodMoon = nbt.func_74767_n("forceBloodMoon");
        this.nightCounter = nbt.func_74762_e("nightCounter");
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        nbt.func_74757_a("bloodMoon", this.bloodMoon);
        nbt.func_74757_a("forceBloodMoon", this.forceBloodMoon);
        nbt.func_74768_a("nightCounter", this.nightCounter);
        return nbt;
    }

    public boolean isBloodmoonScheduled() {
        return this.forceBloodMoon;
    }

    public void stop() {
        this.setBloodmoon(false);
    }
}

