/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles;

import biomesoplenty.api.biome.BOPBiomes;
import com.girafi.waddles.entity.EntityAdeliePenguin;
import com.girafi.waddles.proxy.CommonProxy;
import com.girafi.waddles.utils.ConfigurationHandler;
import java.io.File;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@Mod(modid="waddles", name="Waddles", version="0.5.0", dependencies="required-after:Forge@[12.18.1.2011,)", guiFactory="com.girafi.waddles.client.gui.GuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class Waddles {
    @Mod.Instance(value="waddles")
    public static Waddles instance;
    @SidedProxy(clientSide="com.girafi.waddles.proxy.ClientProxy", serverSide="com.girafi.waddles.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final ResourceLocation LOOT_ENTITIES_PENGUIN_FISH;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigurationHandler.init(new File(event.getModConfigurationDirectory(), "Waddles.cfg"));
        MinecraftForge.EVENT_BUS.register((Object)new ConfigurationHandler());
        proxy.registerRenders();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        EntityRegistry.registerModEntity(EntityAdeliePenguin.class, (String)"penguin", (int)0, (Object)instance, (int)64, (int)1, (boolean)true, (int)0, (int)0xFFFFFF);
        this.addPenguinSpawn(Biomes.field_76774_n, Biomes.field_185445_W, Biomes.field_76775_o, Biomes.field_76776_l, Biomes.field_150577_O);
        if (Loader.isModLoaded((String)"BiomesOPlenty")) {
            if (BOPBiomes.glacier.isPresent()) {
                this.addPenguinSpawn((Biome)BOPBiomes.glacier.get());
            }
            if (BOPBiomes.cold_desert.isPresent()) {
                this.addPenguinSpawn((Biome)BOPBiomes.cold_desert.get());
            }
            if (BOPBiomes.gravel_beach.isPresent()) {
                this.addPenguinSpawn((Biome)BOPBiomes.gravel_beach.get());
            }
        }
    }

    private void addPenguinSpawn(Biome ... biomes) {
        EntityRegistry.addSpawn(EntityAdeliePenguin.class, (int)2, (int)2, (int)5, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])biomes);
    }

    static {
        LOOT_ENTITIES_PENGUIN_FISH = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("waddles", "entities/penguin"));
    }
}

