/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.dimension;

import cpw.mods.fml.common.FMLLog;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.entities.player.GCEntityPlayerMP;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityEntryPod;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.ChunkProviderAsteroids;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;

public class TeleportTypeAsteroids
implements ITeleportType {
    public boolean useParachute() {
        return false;
    }

    public Vector3 getPlayerSpawnLocation(WorldServer world, EntityPlayerMP player) {
        if (player instanceof GCEntityPlayerMP) {
            int x = MathHelper.func_76128_c((double)((GCEntityPlayerMP)player).getPlayerStats().coordsTeleportedFromX);
            int z = MathHelper.func_76128_c((double)((GCEntityPlayerMP)player).getPlayerStats().coordsTeleportedFromZ);
            int attemptCount = 0;
            this.preGenChunks((World)world, x >> 4, z >> 4);
            do {
                BlockVec3 bv3 = null;
                if (world.field_73011_w instanceof WorldProviderAsteroids) {
                    bv3 = ((WorldProviderAsteroids)world.field_73011_w).getClosestAsteroidXZ(x, 0, z);
                }
                if (bv3 == null) continue;
                if (bv3.distanceSquared(new BlockVec3(x, 128, z)) > 25600) break;
                if (ConfigManagerCore.enableDebug) {
                    FMLLog.info((String)("Testing asteroid at x" + bv3.x + " y" + bv3.y + " z" + bv3.z), (Object[])new Object[0]);
                }
                this.loadChunksAround(bv3.x, bv3.z, 2, world.field_73059_b);
                this.loadChunksAround(bv3.x, bv3.z, -3, world.field_73059_b);
                if (this.goodAsteroidEntry((World)world, bv3.x, bv3.y, bv3.z)) {
                    return new Vector3((double)bv3.x, 310.0, (double)bv3.z);
                }
                if (this.goodAsteroidEntry((World)world, bv3.x + 2, bv3.y, bv3.z + 2)) {
                    return new Vector3((double)(bv3.x + 2), 310.0, (double)(bv3.z + 2));
                }
                if (this.goodAsteroidEntry((World)world, bv3.x + 2, bv3.y, bv3.z - 2)) {
                    return new Vector3((double)(bv3.x + 2), 310.0, (double)(bv3.z - 2));
                }
                if (this.goodAsteroidEntry((World)world, bv3.x - 2, bv3.y, bv3.z - 2)) {
                    return new Vector3((double)(bv3.x - 2), 310.0, (double)(bv3.z - 2));
                }
                if (this.goodAsteroidEntry((World)world, bv3.x - 2, bv3.y, bv3.z + 2)) {
                    return new Vector3((double)(bv3.x - 2), 310.0, (double)(bv3.z + 2));
                }
                if (ConfigManagerCore.enableDebug) {
                    FMLLog.info((String)("Removing drilled out asteroid at x" + bv3.x + " z" + bv3.z), (Object[])new Object[0]);
                }
                ((WorldProviderAsteroids)world.field_73011_w).removeAsteroid(bv3.x, bv3.y, bv3.z);
            } while (++attemptCount < 5);
            FMLLog.info((String)"Failed to find good large asteroid landing spot! Falling back to making a small one.", (Object[])new Object[0]);
            this.makeSmallLandingSpot((World)world, x, z);
            return new Vector3((double)x, 310.0, (double)z);
        }
        FMLLog.severe((String)"Failed to cast player to GCEntityPlayerMP!", (Object[])new Object[0]);
        return new Vector3(player.field_70165_t, 310.0, player.field_70161_v);
    }

    private boolean goodAsteroidEntry(World world, int x, int yorig, int z) {
        for (int k = 208; k > 48; --k) {
            if (world.func_147437_c(x, k, z) || Math.abs(k - yorig) > 20) continue;
            for (int y = k + 2; y < 256; ++y) {
                if (world.func_147439_a(x, y, z) == AsteroidBlocks.blockBasic) {
                    world.func_147468_f(x, y, z);
                }
                if (world.func_147439_a(x - 1, y, z) == AsteroidBlocks.blockBasic) {
                    world.func_147468_f(x - 1, y, z);
                }
                if (world.func_147439_a(x, y, z - 1) == AsteroidBlocks.blockBasic) {
                    world.func_147468_f(x, y, z - 1);
                }
                if (world.func_147439_a(x - 1, y, z - 1) != AsteroidBlocks.blockBasic) continue;
                world.func_147468_f(x - 1, y, z - 1);
            }
            if (ConfigManagerCore.enableDebug) {
                FMLLog.info((String)("Found asteroid at x" + x + " z" + z), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    private void makeSmallLandingSpot(World world, int x, int z) {
        this.loadChunksAround(x, z, -1, (ChunkProviderServer)world.func_72863_F());
        for (int k = 255; k > 48; --k) {
            if (!world.func_147437_c(x, k, z)) {
                this.makePlatform(world, x, k - 1, z);
                return;
            }
            if (!world.func_147437_c(x - 1, k, z)) {
                this.makePlatform(world, x - 1, k - 1, z);
                return;
            }
            if (!world.func_147437_c(x - 1, k, z - 1)) {
                this.makePlatform(world, x - 1, k - 1, z - 1);
                return;
            }
            if (world.func_147437_c(x, k, z - 1)) continue;
            this.makePlatform(world, x, k - 1, z - 1);
            return;
        }
        this.makePlatform(world, x, 48 + world.field_73012_v.nextInt(128), z);
    }

    private void loadChunksAround(int x, int z, int i, ChunkProviderServer cp) {
        cp.func_73158_c(x >> 4, z >> 4);
        if (x + i >> 4 != x >> 4) {
            cp.func_73158_c(x + i >> 4, z >> 4);
            if (z + i >> 4 != z >> 4) {
                cp.func_73158_c(x >> 4, z + i >> 4);
                cp.func_73158_c(x + i >> 4, z + i >> 4);
            }
        } else if (z + i >> 4 != z >> 4) {
            cp.func_73158_c(x >> 4, z + i >> 4);
        }
    }

    private void makePlatform(World world, int x, int y, int z) {
        int zz;
        int xx;
        for (xx = -3; xx < 3; ++xx) {
            for (zz = -3; zz < 3; ++zz) {
                if (xx == -3 && (zz == -3 || zz == 2) || xx == 2 && (zz == -3 || zz == 2)) continue;
                this.doBlock(world, x + xx, y, z + zz);
            }
        }
        for (xx = -2; xx < 2; ++xx) {
            for (zz = -2; zz < 2; ++zz) {
                this.doBlock(world, x + xx, y - 1, z + zz);
            }
        }
        this.doBlock(world, x - 1, y - 2, z - 1);
        this.doBlock(world, x - 1, y - 2, z);
        this.doBlock(world, x, y - 2, z);
        this.doBlock(world, x, y - 2, z - 1);
    }

    private void doBlock(World world, int x, int y, int z) {
        int meta = (int)(world.field_73012_v.nextFloat() * 1.5f);
        if (world.func_147437_c(x, y, z)) {
            world.func_147465_d(x, y, z, AsteroidBlocks.blockBasic, meta, 2);
        }
    }

    public Vector3 getEntitySpawnLocation(WorldServer world, Entity entity) {
        return new Vector3(entity.field_70165_t, ConfigManagerCore.disableLander ? 250.0 : 900.0, entity.field_70161_v);
    }

    public Vector3 getParaChestSpawnLocation(WorldServer world, EntityPlayerMP player, Random rand) {
        return null;
    }

    private void preGenChunks(World w, int cx, int cz) {
        this.preGenChunk(w, cx, cz);
        for (int r = 1; r < 3; ++r) {
            int xmin = cx - r;
            int xmax = cx + r;
            int zmin = cz - r;
            int zmax = cz + r;
            for (int i = -r; i < r; ++i) {
                this.preGenChunk(w, xmin, cz + i);
                this.preGenChunk(w, xmax, cz - i);
                this.preGenChunk(w, cx - i, zmin);
                this.preGenChunk(w, cx + i, zmax);
            }
        }
    }

    private void preGenChunk(World w, int chunkX, int chunkZ) {
        w.func_72964_e(chunkX, chunkZ);
        IChunkProvider cp = ((ChunkProviderServer)w.func_72863_F()).field_73246_d;
        if (cp instanceof ChunkProviderAsteroids) {
            ((ChunkProviderAsteroids)cp).addLargeAsteroids(chunkX, chunkZ);
        } else {
            FMLLog.info((String)("GC bug: wrong chunk provider type, found: " + cp.getClass().getName()), (Object[])new Object[0]);
        }
    }

    public void onSpaceDimensionChanged(World newWorld, EntityPlayerMP player, boolean ridingAutoRocket) {
        if (!ridingAutoRocket && player instanceof GCEntityPlayerMP && ((GCEntityPlayerMP)player).getPlayerStats().teleportCooldown <= 0) {
            GCEntityPlayerMP gcPlayer = (GCEntityPlayerMP)player;
            if (gcPlayer.field_71075_bZ.field_75100_b) {
                gcPlayer.field_71075_bZ.field_75100_b = false;
            }
            if (!newWorld.field_72995_K) {
                EntityEntryPod entryPod = new EntityEntryPod(gcPlayer);
                newWorld.func_72838_d((Entity)entryPod);
            }
            gcPlayer.getPlayerStats().teleportCooldown = 10;
        }
    }
}

