/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.world.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Billowed;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.BiomeGenBaseAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlock;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlockHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;

public class ChunkProviderAsteroids
extends ChunkProviderGenerate {
    final Block ASTEROID_STONE = AsteroidBlocks.blockBasic;
    final byte ASTEROID_STONE_META_0 = 0;
    final byte ASTEROID_STONE_META_1 = 1;
    final byte ASTEROID_STONE_META_2 = (byte)2;
    final Block DIRT = Blocks.field_150346_d;
    final byte DIRT_META = 0;
    final Block GRASS = Blocks.field_150349_c;
    final byte GRASS_META = 0;
    final Block LIGHT = Blocks.field_150426_aN;
    final byte LIGHT_META = 0;
    final Block TALL_GRASS = Blocks.field_150329_H;
    final byte TALL_GRASS_META = 1;
    final Block FLOWER = Blocks.field_150328_O;
    final Block LAVA = Blocks.field_150353_l;
    final byte LAVA_META = 0;
    final Block WATER = Blocks.field_150355_j;
    final byte WATER_META = 0;
    private final Random rand;
    private final World worldObj;
    private final NoiseModule asteroidDensity;
    private final NoiseModule asteroidTurbulance;
    private final NoiseModule asteroidSkewX;
    private final NoiseModule asteroidSkewY;
    private final NoiseModule asteroidSkewZ;
    private final SpecialAsteroidBlockHandler coreHandler;
    private final SpecialAsteroidBlockHandler shellHandler;
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Y = 256;
    private static final int CHUNK_SIZE_Z = 16;
    private static final int MAX_ASTEROID_RADIUS = 20;
    private static final int MIN_ASTEROID_RADIUS = 5;
    private static final int MAX_ASTEROID_SKEW = 8;
    private static final int MIN_ASTEROID_Y = 48;
    private static final int MAX_ASTEROID_Y = 208;
    private static final int ASTEROID_CHANCE = 800;
    private static final int ASTEROID_CORE_CHANCE = 2;
    private static final int ASTEROID_SHELL_CHANCE = 2;
    private static final int MIN_BLOCKS_PER_CHUNK = 50;
    private static final int MAX_BLOCKS_PER_CHUNK = 200;
    private static final int ILMENITE_CHANCE = 400;
    private static final int IRON_CHANCE = 300;
    private static final int ALUMINUM_CHANCE = 250;
    private static final int RANDOM_BLOCK_FADE_SIZE = 32;
    private static final int FADE_BLOCK_CHANCE = 5;
    private static final int NOISE_OFFSET_SIZE = 256;
    private static final float MIN_HOLLOW_SIZE = 0.6f;
    private static final float MAX_HOLLOW_SIZE = 0.8f;
    private static final int HOLLOW_CHANCE = 10;
    private static final int MIN_RADIUS_FOR_HOLLOW = 15;
    private static final float HOLLOW_LAVA_SIZE = 0.12f;
    private static final int TREE_CHANCE = 2;
    private static final int TALL_GRASS_CHANCE = 2;
    private static final int FLOWER_CHANCE = 2;
    private static final int WATER_CHANCE = 2;
    private static final int LAVA_CHANCE = 2;
    private static final int GLOWSTONE_CHANCE = 20;
    private ArrayList<float[]> sizeYArray;
    private ArrayList<Integer> xMinArray;
    private ArrayList<Integer> zMinArray;
    private ArrayList<Integer> zSizeArray;
    private ArrayList<Integer> asteroidSizeArray;
    private ArrayList<Integer> asteroidXArray;
    private ArrayList<Integer> asteroidYArray;
    private ArrayList<Integer> asteroidZArray;

    public ChunkProviderAsteroids(World par1World, long par2, boolean par4) {
        super(par1World, par2, par4);
        this.worldObj = par1World;
        this.rand = new Random(par2);
        this.asteroidDensity = new Billowed(this.rand.nextLong(), 2, 0.25f);
        this.asteroidDensity.setFrequency(0.009f);
        this.asteroidDensity.amplitude = 0.6f;
        this.asteroidTurbulance = new Gradient(this.rand.nextLong(), 1, 0.2f);
        this.asteroidTurbulance.setFrequency(0.08f);
        this.asteroidTurbulance.amplitude = 0.5f;
        this.asteroidSkewX = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewX.amplitude = 8.0f;
        this.asteroidSkewX.frequencyX = 0.005f;
        this.asteroidSkewY = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewY.amplitude = 8.0f;
        this.asteroidSkewY.frequencyY = 0.005f;
        this.asteroidSkewZ = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewZ.amplitude = 8.0f;
        this.asteroidSkewZ.frequencyZ = 0.005f;
        this.coreHandler = new SpecialAsteroidBlockHandler();
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_2, 1, 0.3));
        ((Object)((Object)this)).getClass();
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 0, 1, 0.15));
        this.shellHandler = new SpecialAsteroidBlockHandler();
        ((Object)((Object)this)).getClass();
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 1, 5, 0.15));
        this.shellHandler.addBlock(new SpecialAsteroidBlock(AsteroidBlocks.blockDenseIce, 0, 1, 0.15));
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] idArray, byte[] metaArray) {
        this.sizeYArray = new ArrayList();
        this.xMinArray = new ArrayList();
        this.zMinArray = new ArrayList();
        this.zSizeArray = new ArrayList();
        this.asteroidSizeArray = new ArrayList();
        this.asteroidXArray = new ArrayList();
        this.asteroidYArray = new ArrayList();
        this.asteroidZArray = new ArrayList();
        Random random = new Random();
        for (int i = chunkX - 3; i < chunkX + 3; ++i) {
            int xx = i * 16;
            for (int k = chunkZ - 3; k < chunkZ + 3; ++k) {
                int zz = k * 16;
                for (int x = xx; x < xx + 16; x += 2) {
                    for (int z = zz; z < zz + 16; z += 2) {
                        if (!((double)Math.abs(this.randFromPoint(x, z)) < ((double)this.asteroidDensity.getNoise((float)x, (float)z) + 0.4) / 800.0)) continue;
                        random.setSeed(x + z * 3067);
                        int y = random.nextInt(160) + 48;
                        int size = random.nextInt(15) + 5;
                        ((WorldProviderAsteroids)this.worldObj.field_73011_w).addAsteroid(x, y, z);
                        this.generateAsteroid(random, x, y, z, chunkX * 16, chunkZ * 16, size, idArray, metaArray);
                    }
                }
            }
        }
        double density = (double)this.asteroidDensity.getNoise((float)(chunkX * 16), (float)(chunkZ * 16)) * 0.54;
        double numOfBlocks = this.clamp(this.randFromPoint(chunkX, chunkZ), 0.4, 1.0) * 200.0 * density + 50.0;
        int y0 = this.rand.nextInt(2);
        if (this.rand.nextBoolean()) {
            int i = 0;
            while ((double)i < numOfBlocks) {
                int y = this.rand.nextInt(160) + 48;
                if (y0 == y / 16 % 2) {
                    int x = this.rand.nextInt(16);
                    int z = this.rand.nextInt(16);
                    ((Object)((Object)this)).getClass();
                    BlockMetaPair pair = new BlockMetaPair(this.ASTEROID_STONE, 1);
                    if (this.rand.nextInt(400) == 0) {
                        pair = new BlockMetaPair(this.ASTEROID_STONE, 4);
                    } else if (this.rand.nextInt(300) == 0) {
                        pair = new BlockMetaPair(this.ASTEROID_STONE, 5);
                    } else if (this.rand.nextInt(250) == 0) {
                        pair = new BlockMetaPair(this.ASTEROID_STONE, 3);
                    }
                    idArray[this.getIndex((int)x, (int)y, (int)z)] = pair.getBlock();
                    metaArray[this.getIndex((int)x, (int)y, (int)z)] = pair.getMetadata();
                }
                ++i;
            }
        }
    }

    private void generateAsteroid(Random rand, int asteroidX, int asteroidY, int asteroidZ, int chunkX, int chunkZ, int size, Block[] blockArray, byte[] metaArray) {
        float distance;
        int distanceY;
        float sizeZ;
        float sizeX;
        int y;
        int indexBase;
        int distanceZ;
        float sizeY;
        float sizeModY;
        int z;
        int distanceX;
        int indexXZ;
        int indexXY;
        int x;
        int x2;
        int z2;
        SpecialAsteroidBlock core = null;
        SpecialAsteroidBlock shell = null;
        if (rand.nextInt(2) == 0) {
            core = this.coreHandler.getBlock(rand);
        }
        if (rand.nextInt(2) == 0) {
            shell = this.shellHandler.getBlock(rand);
        }
        boolean isHollow = false;
        float hollowSize = rand.nextFloat() * 0.19999999f + 0.6f;
        if (rand.nextInt(10) == 0 && size >= 15) {
            isHollow = true;
            shell = new SpecialAsteroidBlock(AsteroidBlocks.blockDenseIce, 0, 1, 0.15);
        }
        float noiseOffsetX = this.randFromPoint(asteroidX, asteroidY, asteroidZ) * 256.0f;
        float noiseOffsetY = this.randFromPoint(asteroidX * 7, asteroidY * 11, asteroidZ * 13) * 256.0f;
        float noiseOffsetZ = this.randFromPoint(asteroidX * 17, asteroidY * 23, asteroidZ * 29) * 256.0f;
        int xMin = this.clamp(Math.max(chunkX, asteroidX - size - 8 - 2) - chunkX, 0, 16);
        int zMin = this.clamp(Math.max(chunkZ, asteroidZ - size - 8 - 2) - chunkZ, 0, 16);
        int yMin = asteroidY - size - 8 - 2;
        int yMax = asteroidY + size + 8 + 2;
        int xMax = this.clamp(Math.min(chunkX + 16, asteroidX + size + 8 + 2) - chunkX, 0, 16);
        int zMax = this.clamp(Math.min(chunkZ + 16, asteroidZ + size + 8 + 2) - chunkZ, 0, 16);
        int xSize = xMax - xMin;
        int ySize = yMax - yMin;
        int zSize = zMax - zMin;
        if (xSize <= 0 || ySize <= 0 || zSize <= 0) {
            return;
        }
        this.setOtherAxisFrequency(1.0f / ((float)size * 2.0f / 2.0f));
        float[] sizeXArray = new float[ySize * zSize];
        float[] sizeZArray = new float[xSize * ySize];
        float[] sizeYArray = new float[xSize * zSize];
        for (int y2 = 0; y2 < ySize; ++y2) {
            for (z2 = 0; z2 < zSize; ++z2) {
                sizeXArray[y2 * zSize + z2] = this.asteroidSkewX.getNoise((float)y2 + noiseOffsetY, (float)(z2 + chunkZ) + noiseOffsetZ);
            }
        }
        for (x2 = 0; x2 < xSize; ++x2) {
            for (z2 = 0; z2 < zSize; ++z2) {
                sizeYArray[x2 * zSize + z2] = this.asteroidSkewY.getNoise((float)(x2 + chunkX) + noiseOffsetX, (float)(z2 + chunkZ) + noiseOffsetZ);
            }
        }
        for (x2 = 0; x2 < xSize; ++x2) {
            for (int y3 = 0; y3 < ySize; ++y3) {
                sizeZArray[x2 * ySize + y3] = this.asteroidSkewZ.getNoise((float)(x2 + chunkX) + noiseOffsetX, (float)y3 + noiseOffsetY);
            }
        }
        double shellThickness = 0.0;
        if (shell != null) {
            shellThickness = 1.0 - shell.thickness;
        }
        for (x = xMin; x < xMax; ++x) {
            indexXY = (x - xMin) * ySize - yMin;
            indexXZ = (x - xMin) * zSize - zMin;
            distanceX = asteroidX - (x + chunkX);
            distanceX *= distanceX;
            for (z = zMin; z < zMax; ++z) {
                sizeModY = sizeYArray[indexXZ + z];
                sizeY = (float)size + sizeYArray[indexXZ + z];
                sizeY *= sizeY;
                distanceZ = asteroidZ - (z + chunkZ);
                distanceZ *= distanceZ;
                indexBase = x * 256 * 16 | z * 256;
                for (y = yMin; y < yMax; ++y) {
                    int terrainY;
                    int index;
                    sizeX = (float)size + sizeXArray[(y - yMin) * zSize + z - zMin];
                    sizeZ = (float)size + sizeZArray[indexXY + y];
                    sizeX *= sizeX;
                    sizeZ *= sizeZ;
                    distanceY = asteroidY - y;
                    distanceY *= distanceY;
                    distance = (float)distanceX / sizeX + (float)distanceY / sizeY + (float)distanceZ / sizeZ;
                    distance += this.asteroidTurbulance.getNoise((float)(x + chunkX), (float)y, (float)(z + chunkZ));
                    float distanceAbove = (float)distanceX / sizeX + (float)distanceY / sizeY + (float)distanceZ / sizeZ;
                    if ((distanceAbove += this.asteroidTurbulance.getNoise((float)(x + chunkX), (float)(y + 1), (float)(z + chunkZ))) <= 1.0f) {
                        index = indexBase | y + 1;
                        if (isHollow && distance <= hollowSize && y - 1 == (terrainY = this.getTerrainHeightFor(sizeModY, asteroidY - 1, size))) {
                            blockArray[index] = this.LIGHT;
                            ((Object)((Object)this)).getClass();
                            metaArray[index] = 0;
                        }
                    }
                    if (!(distance <= 1.0f)) continue;
                    index = indexBase | y;
                    if (isHollow && distance <= hollowSize) {
                        terrainY = this.getTerrainHeightFor(sizeModY, asteroidY, size);
                        if (y == terrainY) {
                            blockArray[index] = this.GRASS;
                            ((Object)((Object)this)).getClass();
                            metaArray[index] = 0;
                            continue;
                        }
                        if (y < terrainY) {
                            blockArray[index] = this.DIRT;
                            ((Object)((Object)this)).getClass();
                            metaArray[index] = 0;
                            continue;
                        }
                        blockArray[index] = Blocks.field_150350_a;
                        metaArray[index] = 0;
                        continue;
                    }
                    if (core != null && (double)distance <= core.thickness) {
                        blockArray[index] = core.block;
                        metaArray[index] = core.meta;
                        continue;
                    }
                    if (shell != null && (double)distance >= shellThickness) {
                        blockArray[index] = shell.block;
                        metaArray[index] = shell.meta;
                        continue;
                    }
                    blockArray[index] = this.ASTEROID_STONE;
                    ((Object)((Object)this)).getClass();
                    metaArray[index] = 1;
                }
            }
        }
        shellThickness = 0.0;
        if (shell != null) {
            shellThickness = 1.0 - shell.thickness;
        }
        for (x = xMin; x < xMax; ++x) {
            indexXY = (x - xMin) * ySize - yMin;
            indexXZ = (x - xMin) * zSize - zMin;
            distanceX = asteroidX - (x + chunkX);
            distanceX *= distanceX;
            for (z = zMin; z < zMax; ++z) {
                sizeModY = sizeYArray[indexXZ + z];
                sizeY = (float)size + sizeYArray[indexXZ + z];
                sizeY *= sizeY;
                distanceZ = asteroidZ - (z + chunkZ);
                distanceZ *= distanceZ;
                indexBase = x * 256 * 16 | z * 256;
                for (y = yMin; y < yMax; ++y) {
                    sizeX = (float)size + sizeXArray[(y - yMin) * zSize + z - zMin];
                    sizeZ = (float)size + sizeZArray[indexXY + y];
                    sizeX *= sizeX;
                    sizeZ *= sizeZ;
                    distanceY = asteroidY - y;
                    distanceY *= distanceY;
                    distance = (float)distanceX / sizeX + (float)distanceY / sizeY + (float)distanceZ / sizeZ;
                    if (!((distance += this.asteroidTurbulance.getNoise((float)(x + chunkX), (float)y, (float)(z + chunkZ))) <= 1.0f)) continue;
                    int index = indexBase | y;
                    int indexAbove = indexBase | y + 1;
                    if (!isHollow || blockArray[indexAbove] != Blocks.field_150350_a || blockArray[index] != this.ASTEROID_STONE && blockArray[index] != this.GRASS || this.rand.nextInt(20) != 0) continue;
                    blockArray[index] = this.LIGHT;
                    ((Object)((Object)this)).getClass();
                    metaArray[index] = 0;
                }
            }
        }
        if (isHollow) {
            this.sizeYArray.add(sizeYArray);
            this.xMinArray.add(xMin);
            this.zMinArray.add(zMin);
            this.zSizeArray.add(zSize);
            this.asteroidSizeArray.add(size);
            this.asteroidXArray.add(asteroidX);
            this.asteroidYArray.add(asteroidY);
            this.asteroidZArray.add(asteroidZ);
        }
    }

    private final void setOtherAxisFrequency(float frequency) {
        this.asteroidSkewX.frequencyY = frequency;
        this.asteroidSkewX.frequencyZ = frequency;
        this.asteroidSkewY.frequencyX = frequency;
        this.asteroidSkewY.frequencyZ = frequency;
        this.asteroidSkewZ.frequencyX = frequency;
        this.asteroidSkewZ.frequencyY = frequency;
    }

    private final int clamp(int x, int min, int max) {
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        return x;
    }

    private final double clamp(double x, double min, double max) {
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        return x;
    }

    private final int getTerrainHeightFor(float yMod, int asteroidY, int asteroidSize) {
        return (int)((double)(asteroidY - asteroidSize / 4) - (double)(-yMod) * 1.5);
    }

    private final int getTerrainHeightAt(int x, int z, float[] yModArray, int xMin, int zMin, int zSize, int asteroidY, int asteroidSize) {
        int index = (x - xMin) * zSize - zMin;
        if (index < yModArray.length && index >= 0) {
            float yMod = yModArray[index];
            return this.getTerrainHeightFor(yMod, asteroidY, asteroidSize);
        }
        return 1;
    }

    public Chunk func_73154_d(int par1, int par2) {
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        Block[] ids = new Block[65536];
        byte[] meta = new byte[65536];
        this.generateTerrain(par1, par2, ids, meta);
        Chunk var4 = new Chunk(this.worldObj, ids, meta, par1, par2);
        byte[] var5 = var4.func_76605_m();
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var5[var6] = (byte)BiomeGenBaseAsteroids.asteroid.field_76756_M;
        }
        var4.func_76603_b();
        return var4;
    }

    private int getIndex(int x, int y, int z) {
        return x * 256 * 16 | z * 256 | y;
    }

    private float randFromPoint(int x, int y, int z) {
        int n = x + z * 57 + y * 571;
        n = n << 13 ^ n;
        n = n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    private float randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        n = n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        this.worldObj.func_72807_a(x + 16, z + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * var7 + (long)chunkZ * var9 ^ this.worldObj.func_72905_C());
        BlockFalling.field_149832_M = false;
        if (this.sizeYArray != null) {
            for (int asteroidIndex = 0; asteroidIndex < this.sizeYArray.size(); ++asteroidIndex) {
                int k;
                int i;
                float[] sizeYArray = this.sizeYArray.get(asteroidIndex);
                int xMin = this.xMinArray.get(asteroidIndex);
                int zMin = this.zMinArray.get(asteroidIndex);
                int zSize = this.zSizeArray.get(asteroidIndex);
                int asteroidX = this.asteroidXArray.get(asteroidIndex);
                int asteroidY = this.asteroidYArray.get(asteroidIndex);
                int asteroidZ = this.asteroidZArray.get(asteroidIndex);
                int asteroidSize = this.asteroidSizeArray.get(asteroidIndex);
                if (this.rand.nextInt(2) == 0) {
                    i = this.rand.nextInt(16) + x + 8;
                    k = this.rand.nextInt(16) + z + 8;
                    new WorldGenTrees(false).func_76484_a(this.worldObj, this.rand, i, this.getTerrainHeightAt(i - x, k - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k);
                }
                if (this.rand.nextInt(2) == 0) {
                    i = this.rand.nextInt(16) + x + 8;
                    k = this.rand.nextInt(16) + z + 8;
                    ((Object)((Object)this)).getClass();
                    new WorldGenTallGrass(this.TALL_GRASS, 1).func_76484_a(this.worldObj, this.rand, i, this.getTerrainHeightAt(i - x, k - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k);
                }
                if (this.rand.nextInt(2) == 0) {
                    i = this.rand.nextInt(16) + x + 8;
                    k = this.rand.nextInt(16) + z + 8;
                    new WorldGenFlowers(this.FLOWER).func_76484_a(this.worldObj, this.rand, i, this.getTerrainHeightAt(i - x, k - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k);
                }
                if (this.rand.nextInt(2) == 0) {
                    i = this.rand.nextInt(16) + x + 8;
                    k = this.rand.nextInt(16) + z + 8;
                    new WorldGenLakes(this.LAVA).func_76484_a(this.worldObj, this.rand, i, this.getTerrainHeightAt(i - x, k - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k);
                }
                if (this.rand.nextInt(2) != 0) continue;
                i = this.rand.nextInt(16) + x + 8;
                k = this.rand.nextInt(16) + z + 8;
                new WorldGenLakes(this.WATER).func_76484_a(this.worldObj, this.rand, i, this.getTerrainHeightAt(i - x, k - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k);
            }
        }
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int i, int j, int k) {
        if (par1EnumCreatureType == EnumCreatureType.monster) {
            ArrayList<BiomeGenBase.SpawnListEntry> monsters = new ArrayList<BiomeGenBase.SpawnListEntry>();
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedZombie.class, 2000, 1, 1));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 2000, 1, 1));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 2000, 1, 1));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 2000, 1, 1));
            return monsters;
        }
        return null;
    }

    public BlockVec3 isLargeAsteroidAt(int x0, int z0) {
        for (int i0 = 0; i0 <= 32; ++i0) {
            for (int i1 = -i0; i1 <= i0; ++i1) {
                int xToCheck = (x0 >> 4) + i0;
                int zToCheck = (z0 >> 4) + i1;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) + i0;
                zToCheck = (z0 >> 4) - i1;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) - i0;
                zToCheck = (z0 >> 4) + i1;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) - i0;
                zToCheck = (z0 >> 4) - i1;
                if (!this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) continue;
                return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
            }
        }
        return null;
    }

    private boolean isLargeAsteroidAt0(int x0, int z0) {
        for (int x = x0; x < x0 + 16; x += 2) {
            for (int z = z0; z < z0 + 16; z += 2) {
                if (!((double)Math.abs(this.randFromPoint(x, z)) < ((double)this.asteroidDensity.getNoise((float)x, (float)z) + 0.4) / 800.0)) continue;
                return true;
            }
        }
        return false;
    }

    public void addLargeAsteroids(int chunkX, int chunkZ) {
        this.sizeYArray = new ArrayList();
        this.xMinArray = new ArrayList();
        this.zMinArray = new ArrayList();
        this.zSizeArray = new ArrayList();
        this.asteroidSizeArray = new ArrayList();
        this.asteroidXArray = new ArrayList();
        this.asteroidYArray = new ArrayList();
        this.asteroidZArray = new ArrayList();
        Random random = new Random();
        for (int i = chunkX - 3; i < chunkX + 3; ++i) {
            int xx = i * 16;
            for (int k = chunkZ - 3; k < chunkZ + 3; ++k) {
                int zz = k * 16;
                for (int x = xx; x < xx + 16; x += 2) {
                    for (int z = zz; z < zz + 16; z += 2) {
                        if (!((double)Math.abs(this.randFromPoint(x, z)) < ((double)this.asteroidDensity.getNoise((float)x, (float)z) + 0.4) / 800.0)) continue;
                        random.setSeed(x + z * 3067);
                        int y = random.nextInt(160) + 48;
                        ((WorldProviderAsteroids)this.worldObj.field_73011_w).addAsteroid(x, y, z);
                    }
                }
            }
        }
    }
}

