/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.client.render;

import com.gollum.jammyfurniture.client.model.JFIModel;
import com.gollum.jammyfurniture.client.model.sofa.ModelArmChair;
import com.gollum.jammyfurniture.client.model.sofa.ModelSofaCenter;
import com.gollum.jammyfurniture.client.model.sofa.ModelSofaCorner;
import com.gollum.jammyfurniture.client.model.sofa.ModelSofaLeft;
import com.gollum.jammyfurniture.client.model.sofa.ModelSofaRight;
import com.gollum.jammyfurniture.client.render.JFTileEntitySpecialRenderer;
import com.gollum.jammyfurniture.common.tilesentities.sofa.TileEntitySofaCenter;
import com.gollum.jammyfurniture.common.tilesentities.sofa.TileEntitySofaCorner;
import com.gollum.jammyfurniture.common.tilesentities.sofa.TileEntitySofaLeft;
import com.gollum.jammyfurniture.common.tilesentities.sofa.TileEntitySofaRight;
import com.gollum.jammyfurniture.inits.ModBlocks;
import net.minecraft.tileentity.TileEntity;

public class SofaRenderer
extends JFTileEntitySpecialRenderer {
    private ModelArmChair modelArmChair = new ModelArmChair();
    private ModelSofaCenter modelSofaCenter = new ModelSofaCenter();
    private ModelSofaCorner modelSofaCorner = new ModelSofaCorner();
    private ModelSofaRight modelSofaRight = new ModelSofaRight();
    private ModelSofaLeft modelSofaLeft = new ModelSofaLeft();

    @Override
    protected void renderTileEntityAt(TileEntity tileentity, double x, double y, double z, float f, int metadata) {
        String texture;
        float rotation = 0.0f;
        int subBlock = ModBlocks.blockArmChair.getEnabledMetadata(metadata);
        switch (metadata) {
            default: {
                rotation = 0.0f;
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                rotation = 90.0f;
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                rotation = 180.0f;
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                rotation = 270.0f;
            }
        }
        if (this.isInventory) {
            rotation = 180.0f;
        }
        switch (subBlock) {
            default: {
                texture = this.getPrefrixeTexture(tileentity) + "_red";
                break;
            }
            case 4: {
                texture = this.getPrefrixeTexture(tileentity) + "_blue";
                break;
            }
            case 8: {
                texture = this.getPrefrixeTexture(tileentity) + "_green";
                break;
            }
            case 12: {
                texture = this.getPrefrixeTexture(tileentity) + "_grey";
            }
        }
        this.renderModel(this.getModel(tileentity), texture, x, y, z, rotation);
    }

    private String getPrefrixeTexture(TileEntity tileentity) {
        if (tileentity instanceof TileEntitySofaCenter) {
            return "sofacenter";
        }
        if (tileentity instanceof TileEntitySofaCorner) {
            return "sofacorner";
        }
        if (tileentity instanceof TileEntitySofaLeft) {
            return "sofaleft";
        }
        if (tileentity instanceof TileEntitySofaRight) {
            return "sofaright";
        }
        return "armchair";
    }

    private JFIModel getModel(TileEntity tileentity) {
        if (tileentity instanceof TileEntitySofaCenter) {
            return this.modelSofaCenter;
        }
        if (tileentity instanceof TileEntitySofaCorner) {
            return this.modelSofaCorner;
        }
        if (tileentity instanceof TileEntitySofaLeft) {
            return this.modelSofaLeft;
        }
        if (tileentity instanceof TileEntitySofaRight) {
            return this.modelSofaRight;
        }
        return this.modelArmChair;
    }
}

