/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.tilesentities.iron;

import com.gollum.core.common.tileentities.GCLInventoryTileEntity;
import com.gollum.jammyfurniture.ModJammyFurniture;
import com.gollum.jammyfurniture.common.crafting.CookerRecipes;
import com.gollum.jammyfurniture.inits.ModBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityFurnace;

public class TileEntityIronBlocksOne
extends GCLInventoryTileEntity {
    public static final int INV_SIZE_FRIDGE = 9;
    public static final int INV_SIZE_COOKER = 5;
    public static final int INV_SIZE_RUBBISHBIN = 27;
    public static final int INDEX_SLOT_BURN = 1;
    public static final int INDEX_SLOT_BEFORE0 = 0;
    public static final int INDEX_SLOT_BEFORE1 = 3;
    public static final int INDEX_SLOT_AFTER0 = 2;
    public static final int INDEX_SLOT_AFTER1 = 4;
    public static final int COOKING_SPEED0 = 200;
    public static final int COOKING_SPEED1 = 150;
    public int currentItemBurnTime = 0;
    public int cookerBurnTime = 0;
    public int cookerCookTime0 = 0;
    public int cookerCookTime1 = 0;
    long lastClearance = System.currentTimeMillis();
    public short rubishBinOrientation = 0;

    public TileEntityIronBlocksOne() {
        super(Math.max(9, Math.max(5, 27)));
    }

    public int func_70302_i_() {
        if (this.field_145850_b != null && this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            switch (this.getSubBlock()) {
                case 0: 
                case 4: {
                    return 9;
                }
                case 8: {
                    return 5;
                }
                case 12: {
                    return 27;
                }
            }
        }
        return super.func_70302_i_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 1) {
            if (TileEntityIronBlocksOne.isItemFuel(itemStack)) return true;
        }
        if (slot == 0) {
            if (CookerRecipes.smelting().getSmeltingResult(itemStack) == null) return true;
        }
        if (slot != 3) return false;
        if (CookerRecipes.smelting().getSmeltingResult(itemStack) != null) return false;
        return true;
    }

    public String func_145825_b() {
        switch (this.getSubBlock()) {
            case 0: {
                return ModJammyFurniture.i18n.trans("Fridge", new Object[0]);
            }
            case 4: {
                return ModJammyFurniture.i18n.trans("Freezer", new Object[0]);
            }
            case 8: {
                return ModJammyFurniture.i18n.trans("Cooker", new Object[0]);
            }
            case 12: {
                return ModJammyFurniture.i18n.trans("Rubbish Bin", new Object[0]);
            }
        }
        return "ERROR";
    }

    protected void playSoundClosedInventory() {
        String oldSound = this.soundClosedInventory;
        float oldVolume = this.volumeSoundOpenClosedInventory;
        if (this.getSubBlock() == 12) {
            this.soundClosedInventory = "JammyFurniture".toLowerCase() + ":trashclosed";
            this.volumeSoundOpenClosedInventory = 1.5f;
        }
        super.playSoundClosedInventory();
        this.soundClosedInventory = oldSound;
        this.volumeSoundOpenClosedInventory = oldVolume;
    }

    protected void playSoundOpenInventory() {
        String oldSound = this.soundOpenInventory;
        float oldVolume = this.volumeSoundOpenClosedInventory;
        if (this.getSubBlock() == 12) {
            this.soundOpenInventory = "JammyFurniture".toLowerCase() + ":trashopen";
            this.volumeSoundOpenClosedInventory = 1.5f;
        }
        super.playSoundOpenInventory();
        this.soundOpenInventory = oldSound;
        this.volumeSoundOpenClosedInventory = oldVolume;
    }

    public void func_145845_h() {
        super.func_145845_h();
        int metadata = this.func_145832_p();
        int subBlock = this.getSubBlock();
        if (subBlock == 12) {
            if (System.currentTimeMillis() - this.lastClearance >= 60000L) {
                this.removeAllItems();
                this.lastClearance = System.currentTimeMillis();
            }
            return;
        }
        if (subBlock == 8) {
            boolean inventoryChange = false;
            if (this.isBurning()) {
                --this.cookerBurnTime;
            }
            if (!this.field_145850_b.field_72995_K) {
                if (this.cookerBurnTime == 0 && (this.canSmelt(0) || this.canSmelt(1))) {
                    this.currentItemBurnTime = this.cookerBurnTime = TileEntityIronBlocksOne.getItemBurnTime(this.inventory[1]);
                    if (this.cookerBurnTime > 0) {
                        inventoryChange = true;
                        if (this.inventory[1] != null) {
                            --this.inventory[1].field_77994_a;
                            if (this.inventory[1].field_77994_a == 0) {
                                this.inventory[1] = this.inventory[1].func_77973_b().getContainerItem(this.inventory[1]);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt(0)) {
                    ++this.cookerCookTime0;
                    if (this.cookerCookTime0 == 200) {
                        this.cookerCookTime0 = 0;
                        this.smeltItem(0);
                        inventoryChange = true;
                    }
                } else {
                    this.cookerCookTime0 = 0;
                }
                if (this.isBurning() && this.canSmelt(1)) {
                    ++this.cookerCookTime1;
                    if (this.cookerCookTime1 >= 150) {
                        this.cookerCookTime1 = 0;
                        this.smeltItem(1);
                        inventoryChange = true;
                    }
                } else {
                    this.cookerCookTime1 = 0;
                }
            }
            if (inventoryChange) {
                this.func_70296_d();
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.readItems(nbtTagCompound, "FriFreItems", true);
        this.readItems(nbtTagCompound, "CookerItems", true);
        this.readItems(nbtTagCompound, "BinItems", true);
        this.cookerBurnTime = nbtTagCompound.func_74765_d("BurnTime");
        this.cookerCookTime0 = nbtTagCompound.func_74765_d("CookTime");
        this.cookerCookTime1 = nbtTagCompound.func_74765_d("CookTime2");
        this.rubishBinOrientation = nbtTagCompound.func_74765_d("rubishBinOrientation");
        this.currentItemBurnTime = TileEntityIronBlocksOne.getItemBurnTime(this.inventory[1]);
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74777_a("BurnTime", (short)this.cookerBurnTime);
        nbtTagCompound.func_74777_a("CookTime", (short)this.cookerCookTime0);
        nbtTagCompound.func_74777_a("CookTime2", (short)this.cookerCookTime1);
        nbtTagCompound.func_74777_a("rubishBinOrientation", this.rubishBinOrientation);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void removeAllItems() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, null);
        }
    }

    private int getSubBlock() {
        int metadata = this.func_145832_p();
        return ModBlocks.blockIronBlocksOne.getEnabledMetadata(metadata);
    }

    public boolean isBurning() {
        return this.cookerBurnTime > 0;
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return TileEntityIronBlocksOne.getItemBurnTime(par0ItemStack) > 0;
    }

    protected static int getItemBurnTime(ItemStack itemStack) {
        return TileEntityFurnace.func_145952_a((ItemStack)itemStack);
    }

    private boolean canSmelt(int i) {
        int after;
        int before = i == 0 ? 0 : 3;
        int n = after = i == 0 ? 2 : 4;
        if (this.inventory[before] == null) {
            return false;
        }
        ItemStack itemCooked = CookerRecipes.smelting().getSmeltingResult(this.inventory[before]);
        if (itemCooked == null) {
            return false;
        }
        if (this.inventory[after] == null) {
            return true;
        }
        if (!this.inventory[after].func_77969_a(itemCooked)) {
            return false;
        }
        int total = this.inventory[after].field_77994_a + itemCooked.field_77994_a;
        return total <= this.func_70297_j_() && total <= itemCooked.func_77976_d();
    }

    public void smeltItem(int i) {
        int after;
        int before = i == 0 ? 0 : 3;
        int n = after = i == 0 ? 2 : 4;
        if (this.canSmelt(i)) {
            ItemStack itemStack = CookerRecipes.smelting().getSmeltingResult(this.inventory[before]);
            if (this.inventory[after] == null) {
                this.inventory[after] = itemStack.func_77946_l();
            } else if (this.inventory[after].func_77969_a(itemStack)) {
                this.inventory[after].field_77994_a += itemStack.field_77994_a;
            }
            --this.inventory[before].field_77994_a;
            if (this.inventory[before].field_77994_a <= 0) {
                this.inventory[before] = null;
            }
        }
    }

    public int getBurnTimeRemainingScaled(int maxSize) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.cookerBurnTime * maxSize / this.currentItemBurnTime;
    }

    public int getCookProgressScaled0(int par1) {
        return this.cookerCookTime0 * par1 / 200;
    }

    public int getCookProgressScaled1(int par1) {
        return this.cookerCookTime1 * par1 / 150;
    }
}

