/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.tilesentities.iron;

import com.gollum.core.common.tileentities.GCLInventoryTileEntity;
import com.gollum.jammyfurniture.ModJammyFurniture;
import com.gollum.jammyfurniture.common.crafting.DishwasherRecipes;
import com.gollum.jammyfurniture.common.crafting.WashingMachineRecipes;
import com.gollum.jammyfurniture.inits.ModBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityFurnace;

public class TileEntityIronBlocksTwo
extends GCLInventoryTileEntity {
    public static final int INDEX_SLOT_BURN = 1;
    public static final int INDEX_SLOT_0 = 0;
    public static final int INDEX_SLOT_1 = 2;
    public static final int INDEX_SLOT_2 = 3;
    public static final int INDEX_SLOT_3 = 4;
    public int currentItemBurnTime = 0;
    public int burnTime = 0;
    public int slot0Time = 0;
    public int slot1Time = 0;
    public int slot2Time = 0;
    public int slot3Time = 0;
    private long soundTimeMachine = 0L;

    public TileEntityIronBlocksTwo() {
        super(5);
    }

    public String func_145825_b() {
        switch (this.getSubBlock()) {
            case 0: {
                return ModJammyFurniture.i18n.trans("Dishwasher", new Object[0]);
            }
            case 4: {
                return ModJammyFurniture.i18n.trans("Washing Machine", new Object[0]);
            }
        }
        return "ERROR";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        int subBlock = this.getSubBlock();
        if (slot == 1) {
            if (TileEntityIronBlocksTwo.isItemFuel(itemStack)) return true;
        }
        if (slot == 1) return false;
        if (subBlock == 0) {
            if (DishwasherRecipes.smelting().getSmeltingResult(itemStack) == null) return true;
        }
        if (subBlock != 4) return false;
        if (WashingMachineRecipes.smelting().getSmeltingResult(itemStack) != null) return false;
        return true;
    }

    public void func_145845_h() {
        super.func_145845_h();
        int metadata = this.func_145832_p();
        boolean inventoryChange = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.isBurning()) {
                --this.burnTime;
                double x = (double)this.field_145851_c + 0.5;
                double y = (double)this.field_145848_d + 0.5;
                double z = (double)this.field_145849_e + 0.5;
                if (System.currentTimeMillis() - this.soundTimeMachine >= 13000L && this.canSmelt()) {
                    this.field_145850_b.func_72908_a(x, y, z, "JammyFurniture".toLowerCase() + ":machine", 0.6f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.8f);
                    this.soundTimeMachine = System.currentTimeMillis();
                }
            }
            if (!this.isBurning() && this.canSmelt()) {
                this.currentItemBurnTime = this.burnTime = TileEntityIronBlocksTwo.getItemBurnTime(this.inventory[1]);
                if (this.burnTime > 0) {
                    inventoryChange = true;
                    if (this.inventory[1] != null) {
                        --this.inventory[1].field_77994_a;
                        if (this.inventory[1].field_77994_a == 0) {
                            this.inventory[1] = this.inventory[1].func_77973_b().getContainerItem(this.inventory[1]);
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt(0)) {
                ++this.slot0Time;
                if (this.slot0Time >= this.getSmeltTime(0)) {
                    this.slot0Time = 0;
                    this.smeltItem(0);
                    inventoryChange = true;
                }
            } else {
                this.slot0Time = 0;
            }
            if (this.isBurning() && this.canSmelt(1)) {
                ++this.slot1Time;
                if (this.slot1Time >= this.getSmeltTime(1)) {
                    this.slot1Time = 0;
                    this.smeltItem(1);
                    inventoryChange = true;
                }
            } else {
                this.slot1Time = 0;
            }
            if (this.isBurning() && this.canSmelt(2)) {
                ++this.slot2Time;
                if (this.slot2Time >= this.getSmeltTime(2)) {
                    this.slot2Time = 0;
                    this.smeltItem(2);
                    inventoryChange = true;
                }
            } else {
                this.slot2Time = 0;
            }
            if (this.isBurning() && this.canSmelt(3)) {
                ++this.slot3Time;
                if (this.slot3Time >= this.getSmeltTime(3)) {
                    this.slot3Time = 0;
                    this.smeltItem(3);
                    inventoryChange = true;
                }
            } else {
                this.slot3Time = 0;
            }
            if (inventoryChange) {
                this.func_70296_d();
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.readItems(nbtTagCompound, "dwItems", true);
        this.readItems(nbtTagCompound, "wmItems", true);
        this.burnTime = nbtTagCompound.func_74765_d("burnTime");
        this.slot0Time = nbtTagCompound.func_74765_d("slot0Time");
        this.slot1Time = nbtTagCompound.func_74765_d("slot1Time");
        this.slot2Time = nbtTagCompound.func_74765_d("slot2Time");
        this.slot3Time = nbtTagCompound.func_74765_d("slot3Time");
        this.currentItemBurnTime = TileEntityIronBlocksTwo.getItemBurnTime(this.inventory[1]);
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74777_a("burnTime", (short)this.burnTime);
        nbtTagCompound.func_74777_a("slot0Time", (short)this.slot0Time);
        nbtTagCompound.func_74777_a("slot1Time", (short)this.slot1Time);
        nbtTagCompound.func_74777_a("slot2Time", (short)this.slot2Time);
        nbtTagCompound.func_74777_a("slot3Time", (short)this.slot3Time);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return TileEntityIronBlocksTwo.getItemBurnTime(par0ItemStack) > 0;
    }

    protected static int getItemBurnTime(ItemStack itemStack) {
        return TileEntityFurnace.func_145952_a((ItemStack)itemStack);
    }

    public int getSmeltTime(int i) {
        int slot;
        int time = 0;
        int subBlock = this.getSubBlock();
        switch (i) {
            default: {
                slot = 0;
                break;
            }
            case 1: {
                slot = 2;
                break;
            }
            case 2: {
                slot = 3;
                break;
            }
            case 3: {
                slot = 4;
            }
        }
        time = subBlock == 0 ? DishwasherRecipes.smelting().getSmeltingTime(this.inventory[slot]) : WashingMachineRecipes.smelting().getSmeltingTime(this.inventory[slot]);
        return time;
    }

    public boolean canSmelt(int i) {
        int slot;
        int subBlock = this.getSubBlock();
        switch (i) {
            default: {
                slot = 0;
                break;
            }
            case 1: {
                slot = 2;
                break;
            }
            case 2: {
                slot = 3;
                break;
            }
            case 3: {
                slot = 4;
            }
        }
        if (this.inventory[slot] == null) {
            return false;
        }
        ItemStack itemBurned = subBlock == 0 ? DishwasherRecipes.smelting().getSmeltingResult(this.inventory[slot]) : WashingMachineRecipes.smelting().getSmeltingResult(this.inventory[slot]);
        return itemBurned != null;
    }

    public boolean canSmelt() {
        return this.canSmelt(0) || this.canSmelt(1) || this.canSmelt(2) || this.canSmelt(3);
    }

    public void smeltItem(int i) {
        int slot;
        int subBlock = this.getSubBlock();
        switch (i) {
            default: {
                slot = 0;
                break;
            }
            case 1: {
                slot = 2;
                break;
            }
            case 2: {
                slot = 3;
                break;
            }
            case 3: {
                slot = 4;
            }
        }
        if (this.canSmelt(i)) {
            if (this.inventory[slot].field_77994_a <= 0) {
                this.inventory[slot] = null;
            }
            this.inventory[slot].func_77964_b(0);
        }
    }

    public int getBurnTimeRemainingScaled(int maxSize) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.burnTime * maxSize / this.currentItemBurnTime;
    }

    public int getProgressSlot0(int par1) {
        int time = this.getSmeltTime(0);
        return time == 0 ? 0 : this.slot0Time * par1 / time;
    }

    public int getProgressSlot1(int par1) {
        int time = this.getSmeltTime(1);
        return time == 0 ? 0 : this.slot1Time * par1 / time;
    }

    public int getProgressSlot2(int par1) {
        int time = this.getSmeltTime(2);
        return time == 0 ? 0 : this.slot2Time * par1 / time;
    }

    public int getProgressSlot3(int par1) {
        int time = this.getSmeltTime(3);
        return time == 0 ? 0 : this.slot3Time * par1 / time;
    }

    private int getSubBlock() {
        int metadata = this.func_145832_p();
        return ModBlocks.blockIronBlocksOne.getEnabledMetadata(metadata);
    }
}

