/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.client.render.wood;

import com.gollum.jammyfurniture.client.model.wood.ModelBasket;
import com.gollum.jammyfurniture.client.model.wood.ModelKitchenCupboard;
import com.gollum.jammyfurniture.client.model.wood.ModelTV;
import com.gollum.jammyfurniture.client.render.JFTileEntitySpecialRenderer;
import com.gollum.jammyfurniture.common.tilesentities.wood.TileEntityWoodBlocksTwo;
import com.gollum.jammyfurniture.inits.ModBlocks;
import net.minecraft.tileentity.TileEntity;

public class WoodBlocksTwoRenderer
extends JFTileEntitySpecialRenderer {
    private ModelKitchenCupboard modelKitchenCupboard = new ModelKitchenCupboard();
    private ModelTV modelTV = new ModelTV();
    private ModelBasket modelBasket = new ModelBasket();
    private long lastSwitch = 0L;
    private boolean switchTvTexture = false;

    @Override
    protected void renderTileEntityAt(TileEntity tileentity, double x, double y, double z, float f, int metadata) {
        float rotation = 0.0f;
        int subBlock = ModBlocks.blockWoodBlocksTwo.getEnabledMetadata(metadata);
        switch (metadata) {
            default: {
                rotation = 0.0f;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                rotation = 90.0f;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                rotation = 180.0f;
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                rotation = 270.0f;
            }
        }
        if (this.isInventory) {
            rotation = 180.0f;
        }
        switch (subBlock) {
            default: {
                this.renderModel(this.modelKitchenCupboard, "kitchencupboardnotop", x, y, z, rotation);
                break;
            }
            case 4: {
                this.renderModel(this.modelKitchenCupboard, "kitchencupboard", x, y, z, rotation);
                break;
            }
            case 8: {
                String textureTv = "tv";
                if (((TileEntityWoodBlocksTwo)tileentity).tvIsOn()) {
                    textureTv = this.switchTvTexture ? "tv_on1" : "tv_on2";
                    if (System.currentTimeMillis() - this.lastSwitch > 50L) {
                        this.switchTvTexture = !this.switchTvTexture;
                        this.lastSwitch = System.currentTimeMillis();
                    }
                }
                this.renderModel(this.modelTV, textureTv, x, y, z, rotation);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                String textureBasket = "basket_red";
                if (subBlock == 13) {
                    textureBasket = "basket_blue";
                } else if (subBlock == 14) {
                    textureBasket = "basket_green";
                } else if (subBlock == 15) {
                    textureBasket = "basket_grey";
                }
                this.renderModel(this.modelBasket, textureBasket, x, y, z, rotation);
            }
        }
    }
}

