/*
 * Decompiled with CFR 0.152.
 */
package argo.format;

import argo.format.FieldSorter;
import argo.format.JsonEscapedString;
import argo.format.JsonFormatter;
import argo.jdom.JsonField;
import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public final class CompactJsonFormatter
implements JsonFormatter {
    private final FieldSorter fieldSorter;

    public CompactJsonFormatter() {
        this(FieldSorter.DO_NOTHING_FIELD_SORTER);
    }

    private CompactJsonFormatter(FieldSorter fieldSorter) {
        this.fieldSorter = fieldSorter;
    }

    public static CompactJsonFormatter fieldOrderPreservingCompactJsonFormatter() {
        return new CompactJsonFormatter();
    }

    public static CompactJsonFormatter fieldOrderNormalisingCompactJsonFormatter() {
        return new CompactJsonFormatter(FieldSorter.ALPHABETIC_FIELD_SORTER);
    }

    @Override
    public String format(JsonRootNode jsonNode) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.format(jsonNode, stringWriter);
        }
        catch (IOException e) {
            throw new RuntimeException("Coding failure in Argo:  StringWriter threw an IOException", e);
        }
        return stringWriter.toString();
    }

    @Override
    public void format(JsonRootNode jsonNode, Writer writer) throws IOException {
        this.formatJsonNode(jsonNode, writer);
    }

    private void formatJsonNode(JsonNode jsonNode, Writer writer) throws IOException {
        boolean first = true;
        switch (jsonNode.getType()) {
            case ARRAY: {
                writer.append('[');
                for (JsonNode node : jsonNode.getElements()) {
                    if (!first) {
                        writer.append(',');
                    }
                    first = false;
                    this.formatJsonNode(node, writer);
                }
                writer.append(']');
                break;
            }
            case OBJECT: {
                writer.append('{');
                for (JsonField field : this.fieldSorter.sort(jsonNode.getFieldList())) {
                    if (!first) {
                        writer.append(',');
                    }
                    first = false;
                    this.formatJsonNode(field.getName(), writer);
                    writer.append(':');
                    this.formatJsonNode(field.getValue(), writer);
                }
                writer.append('}');
                break;
            }
            case STRING: {
                writer.append('\"').append(JsonEscapedString.escapeString(jsonNode.getText())).append('\"');
                break;
            }
            case NUMBER: {
                writer.append(jsonNode.getText());
                break;
            }
            case FALSE: {
                writer.append("false");
                break;
            }
            case TRUE: {
                writer.append("true");
                break;
            }
            case NULL: {
                writer.append("null");
                break;
            }
            default: {
                throw new RuntimeException("Coding failure in Argo:  Attempt to format a JsonNode of unknown type [" + (Object)((Object)jsonNode.getType()) + "];");
            }
        }
    }
}

