/*
 * Decompiled with CFR 0.152.
 */
package argo.format;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class JsonEscapedString {
    private static final Pattern ESCAPE_CHARACTERS_PATTERN = Pattern.compile("(\\\\|\\\"|\b|\\f|\\n|\\r|\\t)");

    private JsonEscapedString() {
    }

    static String escapeString(String unescapedString) {
        Matcher matcher = ESCAPE_CHARACTERS_PATTERN.matcher(unescapedString);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String match = matcher.group();
            if ("\\".equals(match)) {
                matcher.appendReplacement(sb, "\\\\\\\\");
                continue;
            }
            if ("\"".equals(match)) {
                matcher.appendReplacement(sb, "\\\\\\\"");
                continue;
            }
            if ("\b".equals(match)) {
                matcher.appendReplacement(sb, "\\\\b");
                continue;
            }
            if ("\f".equals(match)) {
                matcher.appendReplacement(sb, "\\\\f");
                continue;
            }
            if ("\n".equals(match)) {
                matcher.appendReplacement(sb, "\\\\n");
                continue;
            }
            if ("\r".equals(match)) {
                matcher.appendReplacement(sb, "\\\\r");
                continue;
            }
            if ("\t".equals(match)) {
                matcher.appendReplacement(sb, "\\\\t");
                continue;
            }
            throw new RuntimeException("Coding failure in Argo: JSON String escaping matched a character [" + match + "] for which no replacement is defined.");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

