/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.client.gui.config;

import com.gollum.core.client.gui.config.GuiConfigEntries;
import com.gollum.core.client.gui.config.element.ConfigElement;
import com.gollum.core.common.config.ConfigProp;
import com.gollum.core.common.config.JsonConfigProp;
import com.gollum.core.common.mod.GollumMod;
import cpw.mods.fml.client.GuiModList;
import cpw.mods.fml.client.config.GuiButtonExt;
import cpw.mods.fml.client.config.GuiUnicodeGlyphButton;
import cpw.mods.fml.client.config.HoverChecker;
import cpw.mods.fml.common.ModContainer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;

public abstract class GuiConfig
extends GuiScreen {
    protected ArrayList<ConfigElement> configElements = new ArrayList();
    protected GuiConfigEntries entryList;
    protected GuiButtonExt btDone;
    protected GuiButtonExt btUndo;
    protected GuiButtonExt btReset;
    private HoverChecker undoHoverChecker;
    private HoverChecker resetHoverChecker;
    protected GuiScreen parent;
    public GollumMod mod;
    private String title;
    public String titleLine2 = null;
    protected boolean needsRefresh = true;

    public GuiConfig(GuiScreen parent) {
        this.parent = parent;
        this.mod = this.getMod();
        this.title = this.mod.getModId();
    }

    protected abstract void initConfigElement();

    public GollumMod getMod() {
        if (this.parent instanceof GuiModList) {
            try {
                Field f = this.parent.getClass().getDeclaredField("selectedMod");
                f.setAccessible(true);
                ModContainer modContainer = (ModContainer)f.get(this.parent);
                return (GollumMod)modContainer.getMod();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.parent instanceof GuiConfig) {
            return ((GuiConfig)this.parent).mod;
        }
        return null;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.entryList == null) {
            this.initConfigElement();
        }
        if (this.needsRefresh) {
            this.entryList = new GuiConfigEntries(this, this.field_146297_k);
            this.needsRefresh = false;
        }
        int undoGlyphWidth = this.field_146297_k.field_71466_p.func_78256_a("\u21b6") * 2;
        int resetGlyphWidth = this.field_146297_k.field_71466_p.func_78256_a("\u2604") * 2;
        int doneWidth = Math.max(this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])) + 20, 100);
        int undoWidth = this.field_146297_k.field_71466_p.func_78256_a(" " + I18n.func_135052_a((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0])) + undoGlyphWidth + 20;
        int resetWidth = this.field_146297_k.field_71466_p.func_78256_a(" " + I18n.func_135052_a((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0])) + resetGlyphWidth + 20;
        int buttonWidthHalf = (doneWidth + 5 + undoWidth + 5 + resetWidth) / 2;
        this.field_146292_n.clear();
        this.btDone = new GuiButtonExt(2000, this.field_146294_l / 2 - buttonWidthHalf, this.field_146295_m - 29, doneWidth, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.btDone);
        this.btUndo = new GuiUnicodeGlyphButton(2002, this.field_146294_l / 2 - buttonWidthHalf + doneWidth + 5, this.field_146295_m - 29, undoWidth, 20, " " + I18n.func_135052_a((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0]), "\u21b6", 2.0f);
        this.field_146292_n.add(this.btUndo);
        this.btReset = new GuiUnicodeGlyphButton(2001, this.field_146294_l / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5, this.field_146295_m - 29, resetWidth, 20, " " + I18n.func_135052_a((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0]), "\u2604", 2.0f);
        this.field_146292_n.add(this.btReset);
        this.undoHoverChecker = new HoverChecker((GuiButton)this.btUndo, 800);
        this.resetHoverChecker = new HoverChecker((GuiButton)this.btReset, 800);
        this.entryList.initGui();
    }

    public int getTopEntryList() {
        return this.titleLine2 != null ? 33 : 23;
    }

    public boolean mustntDisplay() {
        return false;
    }

    public abstract void saveValue();

    public GuiScreen getParent() {
        if (this.parent instanceof GuiConfig && ((GuiConfig)this.parent).mustntDisplay()) {
            return ((GuiConfig)this.parent).getParent();
        }
        return this.parent;
    }

    public void displayParent() {
        this.saveValue();
        if (this.parent instanceof GuiConfig && ((GuiConfig)this.parent).mustntDisplay()) {
            ((GuiConfig)this.parent).displayParent();
            return;
        }
        this.field_146297_k.func_147108_a(this.getParent());
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 2000) {
            this.displayParent();
        } else if (button.field_146127_k == 2001) {
            this.setToDefault();
        } else if (button.field_146127_k == 2002) {
            this.undoChanges();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.entryList.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 8, 0xFFFFFF);
        String title2 = this.titleLine2;
        if (this.titleLine2 != null) {
            int strWidth = this.field_146297_k.field_71466_p.func_78256_a(title2);
            int elipsisWidth = this.field_146297_k.field_71466_p.func_78256_a("...");
            if (strWidth > this.field_146294_l - 6 && strWidth > elipsisWidth) {
                title2 = this.field_146297_k.field_71466_p.func_78269_a(title2, this.field_146294_l - 6 - elipsisWidth).trim() + "...";
            }
            this.func_73732_a(this.field_146289_q, title2, this.field_146294_l / 2, 18, 0xFFFFFF);
        }
        this.btDone.field_146124_l = this.isValidValues();
        this.btUndo.field_146124_l = this.isChanged() && this.undoIsVisible();
        this.btReset.field_146124_l = !this.isDefault() && this.resetIsVisible();
        this.btUndo.field_146125_m = this.undoIsVisible();
        this.btReset.field_146125_m = this.resetIsVisible();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.undoHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(this.field_146297_k.field_71466_p.func_78271_c(I18n.func_135052_a((String)"fml.configgui.tooltip.undoAll", (Object[])new Object[0]), 300), mouseX, mouseY);
        }
        if (this.resetHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(this.field_146297_k.field_71466_p.func_78271_c(I18n.func_135052_a((String)"fml.configgui.tooltip.resetAll", (Object[])new Object[0]), 300), mouseX, mouseY);
        }
        this.entryList.drawScreenPost(mouseX, mouseY, partialTicks);
    }

    public void func_73733_a(int p_73733_1_, int p_73733_2_, int p_73733_3_, int p_73733_4_, int p_73733_5_, int p_73733_6_) {
        super.func_73733_a(p_73733_1_, p_73733_2_, p_73733_3_, p_73733_4_, p_73733_5_, p_73733_6_);
    }

    public boolean resetIsVisible() {
        return true;
    }

    public boolean undoIsVisible() {
        return true;
    }

    protected boolean isValidValues() {
        return this.entryList.isValidValues();
    }

    protected boolean isChanged() {
        return this.entryList.isChanged();
    }

    protected boolean isDefault() {
        return this.entryList.isDefault();
    }

    protected void setToDefault() {
        this.entryList.setToDefault();
    }

    protected void undoChanges() {
        this.entryList.undoChanges();
    }

    public void drawToolTip(List stringList, int x, int y) {
        this.func_146283_a(stringList, x, y);
    }

    protected void func_73864_a(int x, int y, int mouseEvent) {
        if (mouseEvent != 0 || !this.entryList.func_148179_a(x, y, mouseEvent)) {
            this.entryList.mouseClicked(x, y, mouseEvent);
            super.func_73864_a(x, y, mouseEvent);
        }
    }

    protected void func_146286_b(int x, int y, int mouseEvent) {
        if (mouseEvent != 0 || !this.entryList.func_148181_b(x, y, mouseEvent)) {
            super.func_146286_b(x, y, mouseEvent);
        }
    }

    protected void func_73869_a(char eventChar, int eventKey) {
        if (eventKey == 1) {
            this.field_146297_k.func_147108_a(this.parent);
        } else {
            this.entryList.keyTyped(eventChar, eventKey);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.entryList.updateScreen();
    }

    public boolean isArray() {
        return false;
    }

    public boolean displayEntriesLabel() {
        return true;
    }

    public boolean canAdd() {
        return false;
    }

    public boolean canRemove() {
        return false;
    }

    public Object newValue() {
        return null;
    }

    public ConfigProp newConfigProp() {
        return new JsonConfigProp();
    }
}

