/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.config.type;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.config.IConfigMerge;
import com.gollum.core.common.config.type.ConfigJsonType;
import com.gollum.core.tools.registered.RegisteredObjects;
import com.gollum.core.tools.simplejson.Json;
import com.gollum.core.tools.simplejson.JsonArray;
import com.gollum.core.tools.simplejson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;

public class BuildingConfigType
extends ConfigJsonType
implements IConfigMerge {
    public String modId = null;
    public TreeMap<String, Group> lists = new TreeMap();

    public BuildingConfigType() {
    }

    public BuildingConfigType(Json json, String modId) throws Exception {
        this.modId = modId;
        this.readConfig(json);
    }

    @Override
    public void readConfig(Json json) {
        for (Map.Entry<String, Json> entry : json.allChildWithKey()) {
            String groupName = entry.getKey();
            Json jsonGroup = entry.getValue();
            Group group = new Group();
            group.globalSpawnRate = jsonGroup.child("globalSpawnRate").intValue();
            group.buildings = this.readBuildings(jsonGroup.child("buildings"));
            this.lists.put(groupName, group);
        }
    }

    private TreeMap<String, Group.Building> readBuildings(Json json) {
        TreeMap<String, Group.Building> rtn = new TreeMap<String, Group.Building>();
        for (Map.Entry<String, Json> entryBuilding : json.allChildWithKey()) {
            String buildingName = entryBuilding.getKey();
            Json jsonBuilding = entryBuilding.getValue();
            Group.Building building = new Group.Building();
            building.enabled = jsonBuilding.child("enabled").boolValue();
            building.dimentions = this.readDimentions(jsonBuilding.child("dimentions"));
            rtn.put(buildingName, building);
        }
        return rtn;
    }

    private TreeMap<Integer, Group.Building.Dimention> readDimentions(Json json) {
        TreeMap<Integer, Group.Building.Dimention> rtn = new TreeMap<Integer, Group.Building.Dimention>();
        for (Map.Entry<String, Json> entryDimention : json.allChildWithKey()) {
            Integer id = Integer.parseInt(entryDimention.getKey());
            Json jsonDimention = entryDimention.getValue();
            Group.Building.Dimention dimention = new Group.Building.Dimention();
            dimention.spawnRate = jsonDimention.child("spawnRate").intValue();
            dimention.spawnMin = jsonDimention.child("spawnMin").intValue();
            dimention.spawnMax = jsonDimention.child("spawnMax").intValue();
            for (Json jsonBlock : jsonDimention.child("blocksSpawn").allChild()) {
                String key = jsonBlock.strValue();
                try {
                    Block b = RegisteredObjects.instance().getBlock(key);
                    if (b != null) {
                        dimention.blocksSpawn.add(b);
                        continue;
                    }
                    ModGollumCoreLib.log.severe("Error block not found : " + key);
                }
                catch (Exception e) {
                    ModGollumCoreLib.log.severe("Error block not found : " + key);
                }
            }
            rtn.put(id, dimention);
        }
        return rtn;
    }

    @Override
    public Json writeConfig() {
        JsonObject builder = new JsonObject();
        for (Map.Entry<String, Group> entry : this.lists.entrySet()) {
            String groupName = entry.getKey();
            Group group = entry.getValue();
            JsonObject jsonGroup = Json.create(new Json.EntryObject("globalSpawnRate", Json.create((Object)group.globalSpawnRate)), new Json.EntryObject("buildings", this.getJsonBuildings(group.buildings)));
            ((Json)builder).add(groupName, jsonGroup);
        }
        return builder;
    }

    private Json getJsonBuildings(TreeMap<String, Group.Building> buildings) {
        JsonObject jsonBuildings = new JsonObject();
        for (Map.Entry<String, Group.Building> entryBuilding : buildings.entrySet()) {
            String buildingName = entryBuilding.getKey();
            Group.Building building = entryBuilding.getValue();
            JsonObject jsonBuilding = Json.create(new Json.EntryObject("enabled", Json.create(building.enabled)), new Json.EntryObject("dimentions", this.getJsonDimentions(building.dimentions)));
            ((Json)jsonBuildings).add(buildingName, jsonBuilding);
        }
        return jsonBuildings;
    }

    private Json getJsonDimentions(TreeMap<Integer, Group.Building.Dimention> dimentions) {
        JsonObject jsonDimentions = new JsonObject();
        for (Map.Entry<Integer, Group.Building.Dimention> entryDimentions : dimentions.entrySet()) {
            Integer dimentionId = entryDimentions.getKey();
            Group.Building.Dimention dimention = entryDimentions.getValue();
            JsonObject jsonDimention = Json.create(new Json.EntryObject("spawnMin", Json.create((Object)dimention.spawnMin)), new Json.EntryObject("spawnMax", Json.create((Object)dimention.spawnMax)), new Json.EntryObject("spawnRate", Json.create((Object)dimention.spawnRate)), new Json.EntryObject("blocksSpawn", this.getJsonBlocks(dimention.blocksSpawn)));
            ((Json)jsonDimentions).add(dimentionId.toString(), jsonDimention);
        }
        return jsonDimentions;
    }

    private Json getJsonBlocks(ArrayList<Block> blocksSpawn) {
        JsonArray jsonBlocksSpawn = new JsonArray();
        for (Block block : blocksSpawn) {
            try {
                ((Json)jsonBlocksSpawn).add(Json.create(RegisteredObjects.instance().getRegisterName(block)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsonBlocksSpawn;
    }

    @Override
    public boolean merge(Object newValueObj) {
        BuildingConfigType newValue = (BuildingConfigType)newValueObj;
        for (Map.Entry<String, Group> entry : this.lists.entrySet()) {
            String groupName = entry.getKey();
            Group group = entry.getValue();
            if (!newValue.lists.containsKey(groupName)) continue;
            Group newGroup = newValue.lists.get(groupName);
            group.globalSpawnRate = newGroup.globalSpawnRate;
            for (Map.Entry<String, Group.Building> entryBuilding : group.buildings.entrySet()) {
                String buildingName = entryBuilding.getKey();
                Group.Building building = entryBuilding.getValue();
                if (!newGroup.buildings.containsKey(buildingName)) continue;
                group.buildings.put(buildingName, newGroup.buildings.get(buildingName));
            }
        }
        return false;
    }

    @Override
    public Object clone() {
        BuildingConfigType cloned = (BuildingConfigType)super.clone();
        cloned.modId = this.modId;
        return cloned;
    }

    public static class Group {
        public Integer globalSpawnRate = null;
        public TreeMap<String, Building> buildings = new TreeMap();

        public static class Building {
            public boolean enabled = true;
            public TreeMap<Integer, Dimention> dimentions = new TreeMap();

            public static class Dimention {
                public Integer spawnRate = 1;
                public Integer spawnMin = 3;
                public Integer spawnMax = 256;
                public ArrayList<Block> blocksSpawn = new ArrayList();
            }
        }
    }
}

