/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.version;

import argo.jdom.JdomParser;
import argo.jdom.JsonRootNode;
import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.context.ModContext;
import com.gollum.core.common.log.Logger;
import com.gollum.core.common.mod.GollumMod;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class VersionChecker
extends Thread {
    private static boolean display = true;
    private GollumMod mod = ModContext.instance().getCurrent();
    private String message = null;
    private String type = "";

    public static void setDisplay(boolean display) {
        VersionChecker.display = display;
    }

    public VersionChecker() {
        MinecraftForge.EVENT_BUS.register((Object)new EnterWorldHandler());
        this.start();
    }

    @Override
    public void run() {
        String player = "MINECRAFT_SERVER";
        if (ModGollumCoreLib.proxy.isRemote()) {
            player = Minecraft.func_71410_x().func_110432_I().func_111285_a();
        }
        try {
            String modid = this.mod.getModId();
            String modidEnc = URLEncoder.encode(this.mod.getModId(), "UTF-8");
            String versionEnc = URLEncoder.encode(this.mod.getVersion(), "UTF-8");
            String playerEnc = URLEncoder.encode(player, "UTF-8");
            String mcVersionEnc = URLEncoder.encode(this.mod.getMinecraftVersion(), "UTF-8");
            String localeEnc = URLEncoder.encode(this.getCurrentLanguage(), "UTF-8");
            URL url = new URL("http://minecraft-mods.elewendyl.fr/index.php/mmods/default/version?mod=" + modidEnc + "&version=" + versionEnc + "&player=" + playerEnc + "&mversion=" + mcVersionEnc + "&locale=" + localeEnc);
            ModGollumCoreLib.log.debug("URL Checker : " + url);
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(url.openStream()));
            String strJSON = bufferedreader.readLine();
            JdomParser parser = new JdomParser();
            JsonRootNode root = parser.parse(strJSON);
            try {
                this.message = root.getStringValue("message");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.type = root.getStringValue("type");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.type.equals("info")) {
                Logger.log("VersionChecker " + modid, 1, this.message);
            } else {
                Logger.log("VersionChecker " + modid, 3, this.message);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getCurrentLanguage() {
        if (ModGollumCoreLib.proxy.isRemote()) {
            return Minecraft.func_71410_x().field_71474_y.field_74363_ab;
        }
        return "";
    }

    public class EnterWorldHandler {
        private boolean nagged = false;

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void OnPlayerTickEvent(EntityJoinWorldEvent event) {
            if (event.world.field_72995_K) {
                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                if (this.nagged || !display) {
                    return;
                }
                if (VersionChecker.this.message != null) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("-------------------------------"));
                    ChatComponentText text = new ChatComponentText(VersionChecker.this.message);
                    text.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
                    player.func_145747_a((IChatComponent)text);
                    player.func_145747_a((IChatComponent)new ChatComponentText("-------------------------------"));
                }
                this.nagged = true;
            }
        }
    }
}

