/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.tools.helper;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.context.ModContext;
import com.gollum.core.common.mod.GollumMod;
import com.gollum.core.tools.helper.IBlockHelper;
import com.gollum.core.tools.registry.BlockRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockHelper
implements IBlockHelper {
    public boolean vanillaRegister = false;
    public boolean vanillaTexture = false;
    public boolean vanillaPicked = false;
    public boolean vanillaDamageDropped = false;
    protected GollumMod mod;
    protected Block parent;
    protected String registerName;
    protected Class<? extends ItemBlock> itemBlockClass = ItemBlock.class;

    public BlockHelper(Block parent, String registerName) {
        this.parent = parent;
        this.registerName = registerName;
        this.mod = ModContext.instance().getCurrent();
        BlockRegistry.instance().add((IBlockHelper)this.parent);
        this.parent.func_149663_c(this.registerName);
    }

    @Override
    public BlockHelper getGollumHelper() {
        return this;
    }

    @Override
    public Block setItemBlockClass(Class<? extends ItemBlock> itemClass) {
        this.itemBlockClass = itemClass;
        return this.parent;
    }

    @Override
    public void register() {
        if (this.vanillaRegister) {
            return;
        }
        GameRegistry.registerBlock((Block)this.parent, this.itemBlockClass, (String)this.getRegisterName());
    }

    @Override
    public String getRegisterName() {
        return this.registerName;
    }

    @Override
    public Item getBlockItem() {
        return Item.func_150898_a((Block)this.parent);
    }

    @Override
    public void breakBlockInventory(World world, int x, int y, int z, Block oldBlock) {
        Random random = new Random();
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemStack = inventory.func_70301_a(i);
                if (itemStack == null) continue;
                float f = random.nextFloat() * 0.8f + 0.1f;
                float f1 = random.nextFloat() * 0.8f + 0.1f;
                float f2 = random.nextFloat() * 0.8f + 0.1f;
                while (itemStack.field_77994_a > 0) {
                    int k1 = random.nextInt(21) + 10;
                    if (k1 > itemStack.field_77994_a) {
                        k1 = itemStack.field_77994_a;
                    }
                    itemStack.field_77994_a -= k1;
                    EntityItem entityItem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemStack.func_77973_b(), k1, itemStack.func_77960_j()));
                    float f3 = 0.05f;
                    entityItem.field_70159_w = (float)random.nextGaussian() * f3;
                    entityItem.field_70181_x = (float)random.nextGaussian() * f3 + 0.2f;
                    entityItem.field_70179_y = (float)random.nextGaussian() * f3;
                    if (itemStack.func_77942_o()) {
                        entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)entityItem);
                }
            }
            world.func_147453_f(x, y, z, oldBlock);
        }
    }

    @Override
    public String getTextureKey() {
        return ((IBlockHelper)this.parent).getRegisterName().toLowerCase();
    }

    public IIcon loadTexture(IIconRegister iconRegister) {
        return this.loadTexture(iconRegister, "");
    }

    public IIcon loadTexture(IIconRegister iconRegister, String sufixe) {
        return this.loadTexture(iconRegister, sufixe, false);
    }

    public IIcon loadTexture(IIconRegister iconRegister, String sufixe, boolean dontUseTextureKey) {
        String key = dontUseTextureKey ? sufixe : ((IBlockHelper)this.parent).getTextureKey() + sufixe;
        String texture = this.mod.getModId().toLowerCase() + ":" + key;
        ModGollumCoreLib.log.debug("Register icon " + texture + "\"");
        return iconRegister.func_94245_a(texture);
    }

    @Override
    public void registerBlockIcons(IIconRegister iconRegister) {
        ((IBlockHelper)this.parent).setIcon(this.loadTexture(iconRegister));
    }

    @Override
    public IBlockHelper setIcon(IIcon icon) {
        ModGollumCoreLib.log.warning("setIcon don't be call by helper. It's stub");
        ((IBlockHelper)this.parent).setIcon(icon);
        return this;
    }
}

