/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.tools.simplejson;

import argo.jdom.JsonArrayNodeBuilder;
import argo.jdom.JsonNodeBuilder;
import argo.jdom.JsonNodeBuilders;
import com.gollum.core.tools.simplejson.Json;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonArray
extends Json {
    public JsonArray() {
        this.value = new ArrayList();
    }

    @Override
    public String strValue() {
        return ((List)this.value).size() + "";
    }

    @Override
    public boolean boolValue() {
        return ((List)this.value).size() > 0;
    }

    @Override
    public Json child(int i) {
        return this.containsKey(i) ? (Json)((List)this.value).get(i) : JsonArray.create();
    }

    @Override
    public Json child(String key) {
        try {
            return this.child(Integer.parseInt(key));
        }
        catch (Exception exception) {
            return JsonArray.create();
        }
    }

    @Override
    public Collection<Json> allChild() {
        return (List)this.value;
    }

    @Override
    public Set<Map.Entry<String, Json>> allChildWithKey() {
        HashSet<Map.Entry<String, Json>> h = new HashSet<Map.Entry<String, Json>>();
        int i = 0;
        for (Json val : (List)this.value) {
            h.add(new AbstractMap.SimpleEntry<String, Json>(i + "", val));
            ++i;
        }
        return h;
    }

    @Override
    public int size() {
        return ((List)this.value).size();
    }

    @Override
    public void add(Json child) {
        ((List)this.value).add(child);
    }

    @Override
    public boolean containsKey(int i) {
        return i < ((List)this.value).size();
    }

    @Override
    public boolean containsKey(String key) {
        try {
            return this.containsKey(Integer.parseInt(key));
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void clear() {
        ((List)this.value).clear();
    }

    @Override
    public boolean contains(Json json) {
        return ((List)this.value).contains(json);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.size() != ((JsonArray)obj).size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (((Json)((List)this.value).get(i)).equals(((List)((JsonArray)obj).value).get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Json.TYPE getType() {
        return Json.TYPE.ARRAY;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof List) {
            ArrayList<Json> tmpList = new ArrayList<Json>();
            for (Object json : (List)value) {
                if (!(json instanceof Json)) {
                    return;
                }
                tmpList.add((Json)json);
            }
            this.value = tmpList;
        }
    }

    @Override
    public JsonNodeBuilder argoJson() {
        JsonArrayNodeBuilder ar = JsonNodeBuilders.anArrayBuilder();
        for (Json val : (List)this.value) {
            ar.withElement(val.argoJson());
        }
        return ar;
    }
}

