/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.client.gui.config;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.client.gui.config.GuiConfig;
import com.gollum.core.client.gui.config.element.CategoryElement;
import com.gollum.core.client.gui.config.element.TypedValueElement;
import com.gollum.core.client.gui.config.entry.CategoryEntry;
import com.gollum.core.common.config.ConfigProp;
import java.util.LinkedHashMap;
import java.util.Map;

public class GuiValueConfig
extends GuiConfig {
    private String category;
    private CategoryEntry parentEntry;

    public GuiValueConfig(CategoryEntry parentEntry) {
        super(parentEntry.parent.parent);
        this.parentEntry = parentEntry;
        this.titleLine2 = ((GuiConfig)this.parent).titleLine2 + " > " + parentEntry.getLabel();
        this.category = parentEntry.configElement.getName();
        ModGollumCoreLib.log.debug("Category : " + this.category);
    }

    @Override
    protected void initConfigElement() {
        try {
            LinkedHashMap values = (LinkedHashMap)this.parentEntry.getValue();
            LinkedHashMap dValues = (LinkedHashMap)this.parentEntry.configElement.getDefaultValue();
            for (Map.Entry entry : values.entrySet()) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                try {
                    Object cloned = value.getClass().getMethod("clone", new Class[0]).invoke(value, new Object[0]);
                    value = cloned;
                }
                catch (Exception e) {
                    // empty catch block
                }
                Object defaultValue = dValues.get(name);
                Class type = ((CategoryElement)this.parentEntry.configElement).getType(name);
                ConfigProp prop = ((CategoryElement)this.parentEntry.configElement).getProp(name);
                this.configElements.add(new TypedValueElement(type, name, value, defaultValue, prop));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveValue() {
        LinkedHashMap values = (LinkedHashMap)this.parentEntry.getValue();
        LinkedHashMap<String, Object> newValues = this.entryList.getValues();
        for (Map.Entry entry : values.entrySet()) {
            if (!newValues.containsKey(entry.getKey())) continue;
            Object value = newValues.get(entry.getKey());
            try {
                Object cloned;
                value = cloned = value.getClass().getMethod("clone", new Class[0]).invoke(value, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            values.put(entry.getKey(), value);
        }
        this.parentEntry.setValue(values);
    }

    @Override
    public void displayParent() {
        if (this.entryList.requiresMcRestart()) {
            this.parentEntry.mustBeRestart = true;
        }
        super.displayParent();
    }
}

