/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.mod;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.client.gui.config.ConfigModGuiFactory;
import com.gollum.core.common.config.Config;
import com.gollum.core.common.context.ModContext;
import com.gollum.core.common.i18n.I18n;
import com.gollum.core.common.log.Logger;
import com.gollum.core.tools.handler.GCLArrayGuiHandler;
import com.gollum.core.tools.handler.GCLGuiHandler;
import com.gollum.core.tools.registry.BlockRegistry;
import com.gollum.core.tools.registry.GCLNetworkRegistry;
import com.gollum.core.tools.registry.InventoryRegistry;
import com.gollum.core.tools.registry.ItemRegistry;
import cpw.mods.fml.common.FMLModContainer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;

public abstract class GollumMod {
    private String modId = "Error";
    private String modName;
    private String version;
    private String minecraftVersion;
    private int mobId = 0;

    public GollumMod() {
        for (Annotation annotation : this.getClass().getAnnotations()) {
            if (!(annotation instanceof Mod)) continue;
            this.modId = ((Mod)annotation).modid();
        }
        this.modName = "Error";
        for (Annotation annotation : this.getClass().getAnnotations()) {
            if (!(annotation instanceof Mod)) continue;
            this.modName = ((Mod)annotation).name();
        }
        this.version = "0.0.0 [DEV]";
        for (Annotation annotation : this.getClass().getAnnotations()) {
            if (!(annotation instanceof Mod)) continue;
            this.version = ((Mod)annotation).version();
        }
        this.minecraftVersion = Loader.instance().getMinecraftModContainer().getVersion();
    }

    public String getModId() {
        return this.modId;
    }

    public String getModName() {
        return this.modName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public ModContainer getContainer() {
        return (ModContainer)Loader.instance().getIndexedModList().get(this.getModId());
    }

    public int nextMobID() {
        return ++this.mobId;
    }

    public I18n i18n() {
        I18n i18n = null;
        try {
            Field f = this.getClass().getDeclaredField("i18n");
            f.setAccessible(true);
            i18n = (I18n)f.get(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return i18n;
    }

    public Logger log() {
        Logger log = null;
        try {
            Field f = this.getClass().getDeclaredField("log");
            f.setAccessible(true);
            log = (Logger)f.get(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return log;
    }

    protected void initGuiConfig() {
        ModContainer container = this.getContainer();
        if (container instanceof FMLModContainer) {
            try {
                Field f = container.getClass().getDeclaredField("descriptor");
                f.setAccessible(true);
                Map descriptor = (Map)f.get(container);
                if (!descriptor.containsKey("guiFactory")) {
                    descriptor.put("guiFactory", ConfigModGuiFactory.class.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void initLog() {
        try {
            Field fieldLog = this.getClass().getDeclaredField("log");
            if (fieldLog != null) {
                fieldLog.set(null, new Logger());
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected void initI18n() {
        try {
            Field fieldI18n = this.getClass().getDeclaredField("i18n");
            if (fieldI18n != null) {
                fieldI18n.set(null, new I18n());
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected void initConfig() {
        try {
            Field fieldConfig = this.getClass().getDeclaredField("config");
            if (fieldConfig != null) {
                fieldConfig.set(null, fieldConfig.getType().newInstance());
                Config config = (Config)fieldConfig.get(null);
                config.loadConfig();
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public void handler(FMLPreInitializationEvent event) {
        ModContext.instance().setCurrent(this);
        this.initLog();
        this.initI18n();
        this.initGuiConfig();
        this.initConfig();
        this.preInit(event);
        BlockRegistry.instance().registerAll();
        ItemRegistry.instance().registerAll();
        ModContext.instance().pop();
    }

    public void handler(FMLInitializationEvent event) {
        ModContext.instance().setCurrent(this);
        this.init(event);
        this.initGuiCommon();
        if (ModGollumCoreLib.proxy.isRemote()) {
            this.initGuiClient();
        }
        GCLNetworkRegistry.instance().registerGuiHandler(new GCLGuiHandler(InventoryRegistry.instance().getGuiInventoryList()));
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GCLArrayGuiHandler(GCLNetworkRegistry.instance().getGuiHandlers()));
        ModContext.instance().pop();
    }

    public void handler(FMLPostInitializationEvent event) {
        ModContext.instance().setCurrent(this);
        this.postInit(event);
        ModContext.instance().pop();
    }

    public boolean equals(Object o) {
        if (o instanceof GollumMod) {
            return this.getModId().equals(((GollumMod)o).getModId());
        }
        return this == o;
    }

    public void initGuiCommon() {
    }

    public void initGuiClient() {
    }

    public abstract void preInit(FMLPreInitializationEvent var1);

    public abstract void init(FMLInitializationEvent var1);

    public abstract void postInit(FMLPostInitializationEvent var1);
}

