/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.resources;

import com.gollum.core.common.resources.AbstractResourcePack;
import com.gollum.core.common.resources.ResourcePackFileNotFoundException;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileResourcePack
extends AbstractResourcePack
implements Closeable {
    public static final Splitter entryNameSplitter = Splitter.on((char)'/').omitEmptyStrings().limit(3);
    private ZipFile resourcePackZipFile;
    private static final String __OBFID = "CL_00001075";

    public FileResourcePack(File p_i1290_1_) {
        super(p_i1290_1_);
    }

    private ZipFile getResourcePackZipFile() throws IOException {
        if (this.resourcePackZipFile == null) {
            this.resourcePackZipFile = new ZipFile(this.resourcePackFile);
        }
        return this.resourcePackZipFile;
    }

    @Override
    protected InputStream getInputStreamByName(String p_110591_1_) throws IOException {
        ZipFile zipfile = this.getResourcePackZipFile();
        ZipEntry zipentry = zipfile.getEntry(p_110591_1_);
        if (zipentry == null) {
            throw new ResourcePackFileNotFoundException(this.resourcePackFile, p_110591_1_);
        }
        return zipfile.getInputStream(zipentry);
    }

    @Override
    public boolean hasResourceName(String p_110593_1_) {
        try {
            return this.getResourcePackZipFile().getEntry(p_110593_1_) != null;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    @Override
    public Set getResourceDomains() {
        ZipFile zipfile;
        try {
            zipfile = this.getResourcePackZipFile();
        }
        catch (IOException ioexception) {
            return Collections.emptySet();
        }
        Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
        HashSet hashset = Sets.newHashSet();
        while (enumeration.hasMoreElements()) {
            ArrayList arraylist;
            ZipEntry zipentry = enumeration.nextElement();
            String s = zipentry.getName();
            if (!s.startsWith("assets/") || (arraylist = Lists.newArrayList((Iterable)entryNameSplitter.split((CharSequence)s))).size() <= 1) continue;
            String s1 = (String)arraylist.get(1);
            if (!s1.equals(s1.toLowerCase())) {
                this.logNameNotLowercase(s1);
                continue;
            }
            hashset.add(s1);
        }
        return hashset;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        if (this.resourcePackZipFile != null) {
            this.resourcePackZipFile.close();
            this.resourcePackZipFile = null;
        }
    }
}

