/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.resources;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.resources.FileResourcePack;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.ResourceLocation;

public class ResourceLoader {
    private static ConcurrentHashMap<String, FileResourcePack> resourcePachs = new ConcurrentHashMap();

    public InputStream asset(String assetPath, String modId) throws IOException {
        return this.get(assetPath, modId);
    }

    protected InputStream get(String path, String modId) throws IOException {
        InputStream is = null;
        Map modContainers = Loader.instance().getIndexedModList();
        if (modContainers.containsKey(modId)) {
            ModContainer modContainer = (ModContainer)modContainers.get(modId);
            File modSource = modContainer.getSource();
            if (modSource.isDirectory()) {
                ModGollumCoreLib.log.debug("Read in directory 'assets/" + modId.toLowerCase() + "/" + path + "'.");
                File file = new File(modSource, "assets/" + modId.toLowerCase() + "/" + path);
                if (file.exists()) {
                    is = new FileInputStream(file);
                }
            } else if (modContainer.getMod() != null) {
                ModGollumCoreLib.log.debug("Read in jar file '" + path + "'.");
                ModGollumCoreLib.log.debug("Read in jar file '" + modId.toLowerCase() + ":" + path + "'.");
                ResourceLocation location = new ResourceLocation(modId.toLowerCase() + ":" + path);
                is = this.getResourcePack(modSource).getInputStream(location);
            }
        }
        return is;
    }

    public boolean assetExist(String assetPath, String modId) {
        return this.exist(assetPath, modId);
    }

    protected FileResourcePack getResourcePack(File file) {
        if (!resourcePachs.containsKey(file.getPath())) {
            resourcePachs.put(file.getPath(), new FileResourcePack(file));
        }
        return resourcePachs.get(file.getPath());
    }

    protected boolean exist(String path, String modId) {
        boolean rtn = false;
        try {
            Map modContainers = Loader.instance().getIndexedModList();
            if (modContainers.containsKey(modId)) {
                ModContainer modContainer = (ModContainer)modContainers.get(modId);
                File modSource = modContainer.getSource();
                if (modSource.isDirectory()) {
                    ModGollumCoreLib.log.debug("Test in directory 'assets/" + modId.toLowerCase() + "/" + path + "'.");
                    rtn = new File(modSource, "assets/" + modId.toLowerCase() + "/" + path).exists();
                } else if (modContainer.getMod() != null) {
                    try {
                        ModGollumCoreLib.log.debug("Test in jar file '" + modId.toLowerCase() + ":" + path + "'.");
                        ResourceLocation location = new ResourceLocation(modId.toLowerCase() + ":" + path);
                        rtn = this.getResourcePack(modSource).getInputStream(location) != null;
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rtn;
    }
}

