/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.tools.helper.blocks;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.tools.helper.BlockHelper;
import com.gollum.core.tools.helper.IBlockHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class HBlockPistonBase
extends BlockPistonBase
implements IBlockHelper {
    protected BlockHelper helper;
    protected boolean isStickyPiston;
    protected IIcon iconTop;
    protected IIcon iconOpen;
    protected IIcon iconBottom;
    protected String suffixTop = "_top";
    protected String suffixSticky = "_sticky";
    protected String suffixOpen = "_open";
    protected String suffixBottom = "_bottom";
    protected String suffixSide = "_side";

    public HBlockPistonBase(String registerName, boolean isSticky) {
        super(isSticky);
        ModGollumCoreLib.log.info("Create block registerName : " + registerName);
        this.helper = new BlockHelper((Block)this, registerName);
        this.isStickyPiston = isSticky;
    }

    @Override
    public BlockHelper getGollumHelper() {
        return this.helper;
    }

    @Override
    public void register() {
        this.helper.register();
    }

    @Override
    public String getRegisterName() {
        return this.helper.getRegisterName();
    }

    @Override
    public Block setItemBlockClass(Class<? extends ItemBlock> itemClass) {
        return this.helper.setItemBlockClass(itemClass);
    }

    @Override
    public Item getBlockItem() {
        return this.helper.getBlockItem();
    }

    @Override
    public void breakBlockInventory(World world, int x, int y, int z, Block oldBlock) {
        this.helper.breakBlockInventory(world, x, y, z, oldBlock);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        if (this.helper.vanillaTexture) {
            super.func_149651_a(iconRegister);
            return;
        }
        this.registerBlockIconsTop(iconRegister);
        this.registerBlockIconsOpen(iconRegister);
        this.registerBlockIconsBottom(iconRegister);
        this.registerBlockIconsSide(iconRegister);
    }

    protected void registerBlockIconsTop(IIconRegister iconRegister) {
        this.iconTop = this.helper.loadTexture(iconRegister, this.suffixTop + (this.isStickyPiston ? this.suffixSticky : ""));
    }

    protected void registerBlockIconsOpen(IIconRegister iconRegister) {
        this.iconOpen = this.helper.loadTexture(iconRegister, this.suffixOpen);
    }

    protected void registerBlockIconsBottom(IIconRegister iconRegister) {
        this.iconBottom = this.helper.loadTexture(iconRegister, this.suffixBottom);
    }

    protected void registerBlockIconsSide(IIconRegister iconRegister) {
        this.field_149761_L = this.helper.loadTexture(iconRegister, this.suffixSide);
    }

    @Override
    public IBlockHelper setIcon(IIcon icon) {
        this.field_149761_L = icon;
        return this;
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (this.helper.vanillaTexture) {
            return super.func_149691_a(side, metadata);
        }
        int orientation = HBlockPistonBase.func_150076_b((int)metadata);
        if (orientation > 5) {
            return this.iconTop;
        }
        if (side == orientation) {
            if (HBlockPistonBase.func_150075_c((int)metadata) || this.field_149759_B > 0.0 || this.field_149760_C > 0.0 || this.field_149754_D > 0.0 || this.field_149755_E < 1.0 || this.field_149756_F < 1.0 || this.field_149757_G < 1.0) {
                return this.iconOpen;
            }
            return this.iconTop;
        }
        return side != Facing.field_71588_a[orientation] ? this.field_149761_L : this.iconBottom;
    }

    @Override
    public String getTextureKey() {
        return this.helper.getTextureKey();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_150073_e() {
        if (this.helper.vanillaTexture) {
            return super.func_150073_e();
        }
        return this.iconTop;
    }
}

