/*
 * Decompiled with CFR 0.152.
 */
package foxz.command;

import foxz.command.CmdClone;
import foxz.command.CmdFaction;
import foxz.command.CmdNpc;
import foxz.command.CmdQuest;
import foxz.command.CmdScript;
import foxz.command.CmdTrader;
import foxz.commandhelper.ChMcLogger;
import foxz.commandhelper.annotations.Command;
import foxz.commandhelper.annotations.SubCommand;
import foxz.commandhelper.permissions.OpOnly;
import foxz.commandhelper.permissions.ParamCheck;
import foxz.commandhelper.permissions.PlayerOnly;
import foxz.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;

@Command(name="noppes", desc="noppes root command", sub={CmdClone.class, CmdTrader.class, CmdScript.class, CmdQuest.class})
public class CmdNoppes
extends ChMcLogger {
    public CmdFaction cmdfaction;
    public CmdNpc cmdnpc;
    public static Map<String, Class<?>> SlayMap = new HashMap();

    public CmdNoppes(Object sender) {
        super(sender);
        this.cmdfaction = new CmdFaction(this.ctorParm);
        this.cmdnpc = new CmdNpc(this.ctorParm);
        SlayMap.clear();
        HashMap list = new HashMap(EntityList.field_75625_b);
        for (String name : list.keySet()) {
            Class cls = (Class)list.get(name);
            if (EntityNPCInterface.class.isAssignableFrom(cls) || !EntityLivingBase.class.isAssignableFrom(cls)) continue;
            SlayMap.put(name.toLowerCase(), (Class<?>)list.get(name));
        }
        SlayMap.remove("monster");
        SlayMap.remove("mob");
        SlayMap.put("all", EntityLivingBase.class);
        SlayMap.put("mobs", EntityMob.class);
        SlayMap.put("animals", EntityAnimal.class);
        SlayMap.put("items", EntityItem.class);
        SlayMap.put("xporbs", EntityXPOrb.class);
    }

    @SubCommand(name="create", desc="Creates an NPC", usage="[name]", permissions={PlayerOnly.class, OpOnly.class})
    public Boolean cmdCreate(String[] args) {
        EntityPlayerMP player = (EntityPlayerMP)this.pcParam;
        World pw = player.func_130014_f_();
        EntityCustomNpc npc = new EntityCustomNpc(pw);
        if (args.length > 0) {
            npc.display.name = args[0];
        }
        npc.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_71109_bG, player.field_70726_aT);
        npc.startPos = new int[]{MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v)};
        pw.func_72838_d((Entity)npc);
        npc.func_70606_j(npc.func_110138_aP());
        NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.MainMenuDisplay, npc);
        return true;
    }

    @SubCommand(name="faction", desc="Faction operations", usage="<player> <faction> <command>", permissions={OpOnly.class, ParamCheck.class})
    public Boolean faction(String[] args) {
        String playername = args[0];
        String factionname = args[1];
        EntityPlayer player = Utils.getOnlinePlayer(playername);
        if (player != null) {
            this.cmdfaction.selectedPlayerData = PlayerDataController.instance.getPlayerData(player);
        } else {
            String name = PlayerDataController.instance.hasPlayer(playername);
            if (playername.isEmpty() || name.isEmpty()) {
                this.sendmessage(String.format("Unknow player '%s'", playername));
                return false;
            }
            this.cmdfaction.selectedPlayerData = new PlayerData(name);
        }
        this.cmdfaction.selectedFaction = FactionController.getInstance().getFactionFromName(factionname);
        if (this.cmdfaction.selectedFaction == null) {
            this.sendmessage(String.format("Unknow facion '%", factionname));
            return false;
        }
        this.cmdfaction.processCommand(this.pcParam, args);
        if (player == null) {
            PlayerDataController.instance.savePlayerData(playername, this.cmdfaction.selectedPlayerData.getNBT());
        }
        return true;
    }

    @SubCommand(desc="NPC manipulations", usage="<npc> <command>", permissions={OpOnly.class, ParamCheck.class})
    public boolean npc(String[] args) {
        String npcname = args[0].replace("%", " ");
        EntityPlayerMP player = (EntityPlayerMP)this.pcParam;
        boolean hit = false;
        List<EntityNPCInterface> list = Utils.getNearbeEntityFromPlayer(EntityNPCInterface.class, player, 80);
        for (EntityNPCInterface npc : list) {
            if (!npc.display.name.equalsIgnoreCase(npcname)) continue;
            hit = true;
            this.cmdnpc.selectedNpc = npc;
            this.cmdnpc.processCommand(this.pcParam, args);
        }
        if (!hit) {
            this.sendmessage(String.format("Npc '%s' was not found", npcname));
        }
        return true;
    }

    @SubCommand(name="slay", desc="Kills given entity within range. Also has all, mobs, animal options. Can have multiple types", usage="<type>.. [range]", permissions={PlayerOnly.class, OpOnly.class, ParamCheck.class})
    public Boolean slay(String[] args) {
        EntityPlayerMP player = (EntityPlayerMP)this.pcParam;
        ArrayList toDelete = new ArrayList();
        for (String delete : args) {
            Class<?> cls = SlayMap.get(delete.toLowerCase());
            if (cls != null) {
                toDelete.add(cls);
            }
            if (!delete.equals("mobs")) continue;
            toDelete.add(EntityGhast.class);
            toDelete.add(EntityDragon.class);
        }
        int count = 0;
        int range = 120;
        try {
            range = Integer.parseInt(args[args.length - 1]);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        AxisAlignedBB box = player.field_70121_D.func_72314_b((double)range, (double)range, (double)range);
        List list = player.field_70170_p.func_72872_a(EntityLivingBase.class, box);
        for (Entity entity : list) {
            if (entity instanceof EntityPlayer || entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n() || entity instanceof EntityNPCInterface || !this.delete(entity, toDelete)) continue;
            ++count;
        }
        if (toDelete.contains(EntityXPOrb.class)) {
            list = player.field_70170_p.func_72872_a(EntityXPOrb.class, box);
            for (Entity entity : list) {
                entity.field_70128_L = true;
                ++count;
            }
        }
        if (toDelete.contains(EntityItem.class)) {
            list = player.field_70170_p.func_72872_a(EntityItem.class, box);
            for (Entity entity : list) {
                entity.field_70128_L = true;
                ++count;
            }
        }
        player.func_145747_a((IChatComponent)new ChatComponentTranslation(count + " entities deleted", new Object[0]));
        return true;
    }

    private boolean delete(Entity entity, ArrayList<Class<?>> toDelete) {
        for (Class<?> delete : toDelete) {
            if (delete == EntityAnimal.class && entity instanceof EntityHorse || !delete.isAssignableFrom(entity.getClass())) continue;
            entity.field_70128_L = true;
            return true;
        }
        return false;
    }
}

