/*
 * Decompiled with CFR 0.152.
 */
package foxz.command;

import foxz.commandhelper.ChMcLogger;
import foxz.commandhelper.annotations.Command;
import foxz.commandhelper.annotations.SubCommand;
import foxz.commandhelper.permissions.OpOnly;
import foxz.commandhelper.permissions.ParamCheck;
import foxz.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.Quest;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.QuestData;

@Command(name="quest", usage="help", desc="Quest operations")
public class CmdQuest
extends ChMcLogger {
    public CmdQuest(Object sender) {
        super(sender);
    }

    @SubCommand(desc="Start a quest", usage="<player> <quest>", permissions={OpOnly.class, ParamCheck.class})
    public Boolean start(String[] args) {
        PlayerData playerdata;
        int questid;
        String playername = args[0];
        try {
            questid = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            this.sendmessage("QuestID must be an integer");
            return false;
        }
        EntityPlayer player = Utils.getOnlinePlayer(playername);
        if (player != null) {
            playerdata = PlayerDataController.instance.getPlayerData(player);
        } else {
            String name = PlayerDataController.instance.hasPlayer(playername);
            if (playername.isEmpty() || name.isEmpty()) {
                this.sendmessage(String.format("Unknow player '%s'", playername));
                return false;
            }
            playerdata = new PlayerData(name);
        }
        Quest quest = QuestController.instance.quests.get(questid);
        if (quest == null) {
            this.sendmessage("Unknown QuestID");
            return false;
        }
        QuestData questdata = new QuestData(quest);
        playerdata.questData.activeQuests.put(questid, questdata);
        return true;
    }

    @SubCommand(desc="Finish a quest", usage="<player> <quest>", permissions={OpOnly.class, ParamCheck.class})
    public Boolean finish(String[] args) {
        PlayerData playerdata;
        int questid;
        String playername = args[0];
        try {
            questid = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            this.sendmessage("QuestID must be an integer");
            return false;
        }
        EntityPlayer player = Utils.getOnlinePlayer(playername);
        if (player != null) {
            playerdata = PlayerDataController.instance.getPlayerData(player);
        } else {
            String name = PlayerDataController.instance.hasPlayer(playername);
            if (playername.isEmpty() || name.isEmpty()) {
                this.sendmessage(String.format("Unknow player '%s'", playername));
                return false;
            }
            playerdata = new PlayerData(name);
        }
        Quest quest = QuestController.instance.quests.get(questid);
        if (quest == null) {
            this.sendmessage("Unknown QuestID");
            return false;
        }
        QuestData questdata = new QuestData(quest);
        playerdata.questData.finishedQuests.put(questid, System.currentTimeMillis());
        return true;
    }

    @SubCommand(desc="Stop a started quest", usage="<player> <quest>", permissions={OpOnly.class, ParamCheck.class})
    public Boolean stop(String[] args) {
        PlayerData playerdata;
        int questid;
        String playername = args[0];
        try {
            questid = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            this.sendmessage("QuestID must be an integer");
            return false;
        }
        EntityPlayer player = Utils.getOnlinePlayer(playername);
        if (player != null) {
            playerdata = PlayerDataController.instance.getPlayerData(player);
        } else {
            String name = PlayerDataController.instance.hasPlayer(playername);
            if (playername.isEmpty() || name.isEmpty()) {
                this.sendmessage(String.format("Unknow player '%s'", playername));
                return false;
            }
            playerdata = new PlayerData(name);
        }
        Quest quest = QuestController.instance.quests.get(questid);
        if (quest == null) {
            this.sendmessage("Unknown QuestID");
            return false;
        }
        QuestData questdata = new QuestData(quest);
        playerdata.questData.activeQuests.remove(questid);
        return true;
    }

    @SubCommand(desc="Removes a quest from finished and active quests", usage="<player> <quest>", permissions={OpOnly.class, ParamCheck.class})
    public Boolean remove(String[] args) {
        PlayerData playerdata;
        int questid;
        String playername = args[0];
        try {
            questid = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            this.sendmessage("QuestID must be an integer");
            return false;
        }
        EntityPlayer player = Utils.getOnlinePlayer(playername);
        if (player != null) {
            playerdata = PlayerDataController.instance.getPlayerData(player);
        } else {
            String name = PlayerDataController.instance.hasPlayer(playername);
            if (playername.isEmpty() || name.isEmpty()) {
                this.sendmessage(String.format("Unknow player '%s'", playername));
                return false;
            }
            playerdata = new PlayerData(name);
        }
        Quest quest = QuestController.instance.quests.get(questid);
        if (quest == null) {
            this.sendmessage("Unknown QuestID");
            return false;
        }
        QuestData questdata = new QuestData(quest);
        playerdata.questData.activeQuests.remove(questid);
        playerdata.questData.finishedQuests.remove(questid);
        return true;
    }
}

