/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.village.MerchantRecipeList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.constants.EnumPacketClient;

public class Server {
    public static boolean sendData(EntityPlayerMP player, EnumPacketClient enu, Object ... obs) {
        try {
            ByteBuf buf = Server.getBytes(enu, obs);
            if (buf == null) {
                return false;
            }
            CustomNpcs.Channel.sendTo(new FMLProxyPacket(buf, "CustomNPCs"), player);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void sendAssociatedData(Entity entity, EnumPacketClient enu, Object ... obs) {
        try {
            ByteBuf buf = Server.getBytes(enu, obs);
            if (buf == null) {
                return;
            }
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 60.0);
            CustomNpcs.Channel.sendToAllAround(new FMLProxyPacket(buf, "CustomNPCs"), point);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendToAll(EnumPacketClient enu, Object ... obs) {
        try {
            ByteBuf buf = Server.getBytes(enu, obs);
            if (buf == null) {
                return;
            }
            CustomNpcs.Channel.sendToAll(new FMLProxyPacket(buf, "CustomNPCs"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ByteBuf getBytes(Enum enu, Object ... obs) throws IOException {
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        out.writeInt(enu.ordinal());
        for (Object ob : obs) {
            if (ob == null) continue;
            if (ob instanceof Map) {
                Map map = (Map)ob;
                out.writeInt(map.size());
                for (String key : map.keySet()) {
                    int value = (Integer)map.get(key);
                    out.writeInt(value);
                    out.writeUTF(key);
                }
                continue;
            }
            if (ob instanceof MerchantRecipeList) {
                ((MerchantRecipeList)ob).func_151391_a(new PacketBuffer(buf));
                continue;
            }
            if (ob instanceof List) {
                List list = (List)ob;
                out.writeInt(list.size());
                for (String s : list) {
                    out.writeUTF(s);
                }
                continue;
            }
            if (ob instanceof Enum) {
                out.writeInt(((Enum)ob).ordinal());
                continue;
            }
            if (ob instanceof Integer) {
                out.writeInt(((Integer)ob).intValue());
                continue;
            }
            if (ob instanceof Boolean) {
                out.writeBoolean(((Boolean)ob).booleanValue());
                continue;
            }
            if (ob instanceof String) {
                out.writeUTF((String)ob);
                continue;
            }
            if (ob instanceof Float) {
                out.writeFloat(((Float)ob).floatValue());
                continue;
            }
            if (ob instanceof Long) {
                out.writeLong(((Long)ob).longValue());
                continue;
            }
            if (ob instanceof Double) {
                out.writeDouble(((Double)ob).doubleValue());
                continue;
            }
            if (!(ob instanceof NBTTagCompound)) continue;
            CompressedStreamTools.func_74800_a((NBTTagCompound)((NBTTagCompound)ob), (DataOutput)out);
        }
        out.close();
        if (buf.array().length >= Short.MAX_VALUE) {
            System.err.println("Packet " + enu + " was too big to be send");
            return null;
        }
        return buf;
    }
}

